/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.uitoolkit.impl.awt;

import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import sun.awt.EmbeddedFrame;
import sun.awt.SunToolkit;
import sun.awt.UngrabEvent;

class PluginPopupHelper
implements ChangeListener {
    private EmbeddedFrame win;
    private Point origWinLocation;
    private Timer timer;

    PluginPopupHelper() {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!(e.getSource() instanceof MenuSelectionManager)) {
            return;
        }
        MenuElement[] path = ((MenuSelectionManager)e.getSource()).getSelectedPath();
        if (path.length == 0) {
            this.stopPolling();
        } else {
            Component ownerComponent = this.getMenuOwnerComponent(path);
            if (ownerComponent != null) {
                this.startPolling((EmbeddedFrame)ownerComponent);
            }
        }
    }

    private Component getMenuOwnerComponent(MenuElement[] path) {
        for (int i = 0; i < path.length; ++i) {
            Component comp = this.getMenuOwnerComponent(path[i]);
            if (comp == null) continue;
            return comp;
        }
        return null;
    }

    private Component getMenuOwnerComponent(MenuElement mEl) {
        Window windowAncestor;
        Component comp = mEl.getComponent();
        if (!(comp instanceof JPopupMenu)) {
            return null;
        }
        Component ownerComp = ((JPopupMenu)comp).getInvoker();
        if (ownerComp != null && (windowAncestor = SwingUtilities.getWindowAncestor(ownerComp)) instanceof EmbeddedFrame) {
            return windowAncestor;
        }
        return null;
    }

    private void windowMoved(Component window) {
        SunToolkit.postEvent(SunToolkit.targetToAppContext(window), new UngrabEvent(window));
    }

    private void startPolling(EmbeddedFrame windowAncestor) {
        if (this.win != null) {
            return;
        }
        this.win = windowAncestor;
        if (this.win != null) {
            this.origWinLocation = this.win.getLocationOnScreen();
            if (this.timer == null) {
                this.timer = new Timer(20, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (PluginPopupHelper.this.win != null && !PluginPopupHelper.this.win.getLocationOnScreen().equals(PluginPopupHelper.this.origWinLocation)) {
                            PluginPopupHelper.this.windowMoved(PluginPopupHelper.this.win);
                            PluginPopupHelper.this.timer.stop();
                        }
                    }
                });
            }
            this.timer.start();
        }
    }

    private void stopPolling() {
        if (this.win != null) {
            this.timer.stop();
            this.win = null;
        }
    }
}

