/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.message;

import java.util.LinkedList;
import sun.plugin2.message.Conversation;
import sun.plugin2.message.Message;

class Queue {
    private LinkedList<Message> messages = new LinkedList();
    private Thread waiter;

    Queue() {
    }

    public synchronized void put(Message message) {
        this.messages.add(message);
        this.notifyAll();
    }

    public synchronized Message get() {
        if (this.messages.size() == 0) {
            return null;
        }
        return this.messages.removeFirst();
    }

    public synchronized Message get(int id, Conversation conversation) {
        for (int i = 0; i < this.messages.size(); ++i) {
            Message msg = this.messages.get(i);
            if (id >= 0 && msg.getID() != id || conversation != null && !conversation.equals(msg.getConversation())) continue;
            this.messages.remove(i);
            return msg;
        }
        return null;
    }

    public synchronized Message waitForMessage(long milliseconds) throws InterruptedException {
        if (this.messages.size() == 0) {
            this.waiter = Thread.currentThread();
            try {
                this.wait(milliseconds);
            }
            finally {
                this.waiter = null;
            }
        }
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message waitForMessage(long milliseconds, int id, Conversation conversation) throws InterruptedException {
        Message msg = this.get(id, conversation);
        if (msg != null) {
            return msg;
        }
        boolean infinite = milliseconds == 0L;
        do {
            long startTime = System.currentTimeMillis();
            this.waiter = Thread.currentThread();
            try {
                this.wait(milliseconds);
            }
            finally {
                this.waiter = null;
            }
            long endTime = System.currentTimeMillis();
            if (infinite) continue;
            milliseconds -= Math.max(0L, endTime - startTime);
        } while ((msg = this.get(id, conversation)) == null && (infinite || milliseconds > 0L));
        return msg;
    }

    public synchronized void interrupt() {
        if (this.waiter != null) {
            this.waiter.interrupt();
        }
    }
}

