/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.message;

import java.io.IOException;
import java.net.PasswordAuthentication;
import sun.plugin2.message.Conversation;
import sun.plugin2.message.PluginMessage;
import sun.plugin2.message.Serializer;

public class GetAuthenticationReplyMessage
extends PluginMessage {
    public static final int ID = 44;
    private String username;
    private char[] password;
    private String errorMessage;

    public GetAuthenticationReplyMessage(Conversation c) {
        super(44, c);
    }

    public GetAuthenticationReplyMessage(Conversation c, PasswordAuthentication auth, String errorMessage) {
        this(c);
        if (auth != null) {
            this.username = auth.getUserName();
            this.password = auth.getPassword();
        }
        this.errorMessage = errorMessage;
    }

    public PasswordAuthentication getAuthentication() {
        if (this.username == null) {
            return null;
        }
        return new PasswordAuthentication(this.username, this.password);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public void writeFields(Serializer ser) throws IOException {
        ser.writeUTF(this.username);
        ser.writeCharArray(this.password);
        ser.writeUTF(this.errorMessage);
    }

    @Override
    public void readFields(Serializer ser) throws IOException {
        this.username = ser.readUTF();
        this.password = ser.readCharArray();
        this.errorMessage = ser.readUTF();
    }
}

