/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.message;

import com.sun.deploy.util.BufferUtil;
import com.sun.deploy.util.ByteBufferWrapper;
import java.io.IOException;
import java.nio.ByteBuffer;
import sun.plugin2.message.Conversation;
import sun.plugin2.message.Serializer;

public abstract class AbstractSerializer
implements Serializer {
    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.writeByte(v ? (byte)1 : 0);
    }

    @Override
    public abstract void writeByte(byte var1) throws IOException;

    @Override
    public void writeShort(short s) throws IOException {
        this.writeByte((byte)(s >>> 8));
        this.writeByte((byte)s);
    }

    @Override
    public void writeChar(char c) throws IOException {
        this.writeShort((short)c);
    }

    @Override
    public void writeInt(int i) throws IOException {
        this.writeByte((byte)(i >>> 24));
        this.writeByte((byte)(i >>> 16));
        this.writeByte((byte)(i >>> 8));
        this.writeByte((byte)i);
    }

    @Override
    public void writeLong(long l) throws IOException {
        this.writeByte((byte)(l >>> 56));
        this.writeByte((byte)(l >>> 48));
        this.writeByte((byte)(l >>> 40));
        this.writeByte((byte)(l >>> 32));
        this.writeByte((byte)(l >>> 24));
        this.writeByte((byte)(l >>> 16));
        this.writeByte((byte)(l >>> 8));
        this.writeByte((byte)l);
    }

    @Override
    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToRawIntBits(f));
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToRawLongBits(d));
    }

    @Override
    public void writeByteArray(byte[] b) throws IOException {
        this.writeByteArray(b, 0, b == null ? 0 : b.length);
    }

    @Override
    public void writeByteArray(byte[] b, int offset, int length) throws IOException {
        if (b == null) {
            this.writeBoolean(false);
            return;
        }
        this.writeBoolean(true);
        this.writeInt(length);
        for (int i = 0; i < length; ++i) {
            this.writeByte(b[offset + i]);
        }
    }

    @Override
    public void writeCharArray(char[] c) throws IOException {
        this.writeCharArray(c, 0, c == null ? 0 : c.length);
    }

    @Override
    public void writeCharArray(char[] c, int offset, int length) throws IOException {
        if (c == null) {
            this.writeBoolean(false);
            return;
        }
        this.writeBoolean(true);
        this.writeInt(length);
        for (int i = 0; i < length; ++i) {
            this.writeChar(c[offset + i]);
        }
    }

    @Override
    public void writeIntegerArray(Integer[] ii) throws IOException {
        if (ii == null || ii.length == 0) {
            this.writeBoolean(false);
            return;
        }
        this.writeBoolean(true);
        this.writeInt(ii.length);
        for (Integer ii1 : ii) {
            this.writeInt(ii1);
        }
    }

    @Override
    public void writeUTF(String s) throws IOException {
        if (s == null) {
            this.writeBoolean(false);
            return;
        }
        this.writeBoolean(true);
        int len = s.length();
        this.writeInt(len);
        for (int i = 0; i < len; ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    @Override
    public void writeUTFArray(String[] ss) throws IOException {
        if (ss == null) {
            this.writeBoolean(false);
            return;
        }
        this.writeBoolean(true);
        this.writeInt(ss.length);
        for (String s : ss) {
            this.writeUTF(s);
        }
    }

    @Override
    public void writeConversation(Conversation conversation) throws IOException {
        if (conversation == null) {
            this.writeBoolean(false);
            return;
        }
        this.writeBoolean(true);
        conversation.writeFields(this);
    }

    @Override
    public abstract void flush() throws IOException;

    @Override
    public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    @Override
    public abstract byte readByte() throws IOException;

    @Override
    public short readShort() throws IOException {
        short s = (short)((this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF);
        return s;
    }

    @Override
    public char readChar() throws IOException {
        return (char)this.readShort();
    }

    @Override
    public int readInt() throws IOException {
        int i = this.readByte() & 0xFF;
        i = i << 8 | this.readByte() & 0xFF;
        i = i << 8 | this.readByte() & 0xFF;
        i = i << 8 | this.readByte() & 0xFF;
        return i;
    }

    @Override
    public long readLong() throws IOException {
        long l = this.readByte() & 0xFF;
        l = l << 8 | (long)(this.readByte() & 0xFF);
        l = l << 8 | (long)(this.readByte() & 0xFF);
        l = l << 8 | (long)(this.readByte() & 0xFF);
        l = l << 8 | (long)(this.readByte() & 0xFF);
        l = l << 8 | (long)(this.readByte() & 0xFF);
        l = l << 8 | (long)(this.readByte() & 0xFF);
        l = l << 8 | (long)(this.readByte() & 0xFF);
        return l;
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public ByteBuffer readByteBuffer() throws IOException {
        if (!this.readBoolean()) {
            return null;
        }
        int length = this.readInt();
        ByteBufferWrapper res = BufferUtil.allocateDirect((int)length);
        for (int i = 0; i < length; ++i) {
            res.put(this.readByte());
        }
        res.rewind();
        return res.getBuffer();
    }

    @Override
    public byte[] readByteArray() throws IOException {
        if (!this.readBoolean()) {
            return null;
        }
        int length = this.readInt();
        byte[] res = new byte[length];
        boolean offset = false;
        for (int i = 0; i < length; ++i) {
            res[i] = this.readByte();
        }
        return res;
    }

    @Override
    public char[] readCharArray() throws IOException {
        if (!this.readBoolean()) {
            return null;
        }
        int length = this.readInt();
        char[] res = new char[length];
        for (int i = 0; i < length; ++i) {
            res[i] = this.readChar();
        }
        return res;
    }

    @Override
    public Integer[] readIntegerArray() throws IOException {
        if (!this.readBoolean()) {
            return null;
        }
        int length = this.readInt();
        Integer[] res = new Integer[length];
        for (int i = 0; i < length; ++i) {
            res[i] = this.readInt();
        }
        return res;
    }

    @Override
    public String readUTF() throws IOException {
        if (!this.readBoolean()) {
            return null;
        }
        int len = this.readInt();
        StringBuilder buf = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            buf.append(this.readChar());
        }
        return buf.toString();
    }

    @Override
    public String[] readUTFArray() throws IOException {
        if (!this.readBoolean()) {
            return null;
        }
        int num = this.readInt();
        String[] res = new String[num];
        for (int i = 0; i < num; ++i) {
            res[i] = this.readUTF();
        }
        return res;
    }

    @Override
    public Conversation readConversation() throws IOException {
        if (!this.readBoolean()) {
            return null;
        }
        Conversation conversation = new Conversation();
        conversation.readFields(this);
        return conversation;
    }
}

