/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.main.client;

import com.sun.deploy.trace.Trace;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import sun.plugin2.applet.Applet2ExecutionContext;
import sun.plugin2.applet.Applet2Manager;

public class PluginProxySelector
extends ProxySelector {
    private static HashMap<String, List<Proxy>> proxyCache = new HashMap();

    public static void initialize() {
        proxyCache.clear();
        ProxySelector.setDefault(new PluginProxySelector());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Proxy> select(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        List proxyList = null;
        try {
            String scheme = uri.getScheme();
            boolean isSocketURI = scheme.equalsIgnoreCase("socket") || scheme.equalsIgnoreCase("serversocket");
            URL url = PluginProxySelector.getURLFromURI(uri, isSocketURI);
            String key = PluginProxySelector.buildProxyKey(url);
            PluginProxySelector pluginProxySelector = this;
            synchronized (pluginProxySelector) {
                List<Proxy> proxyInfo = proxyCache.get(key);
                if (proxyInfo == null) {
                    Applet2ExecutionContext appExeCtx = Applet2Manager.getCurrentAppletExecutionContext();
                    proxyInfo = appExeCtx.getProxyList(url, isSocketURI);
                    proxyCache.put(key, proxyInfo);
                }
                proxyList = (List)((ArrayList)proxyInfo).clone();
            }
            if (proxyList.size() > 0) {
                Trace.msgNetPrintln((String)"net.proxy.connect", (Object[])new Object[]{url, proxyList.get(0)});
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return proxyList;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        if (uri == null || sa == null || ioe == null) {
            throw new IllegalArgumentException("Arguments can't be null.");
        }
        Trace.msgNetPrintln((String)"net.proxy.connectionFailure", (Object[])new Object[]{uri.toString() + ", " + sa.toString() + ioe.toString()});
        try {
            this.removeProxyFromCache(uri.toURL(), sa.toString());
        }
        catch (Exception e) {
            Trace.securityPrintException((Throwable)e);
        }
    }

    private static URL getURLFromURI(URI uri, boolean isSocketURI) {
        String auth;
        if (uri == null) {
            return null;
        }
        String host = uri.getHost();
        int port = uri.getPort();
        if (host == null && (auth = uri.getAuthority()) != null) {
            int i = auth.indexOf(64);
            if (i >= 0) {
                auth = auth.substring(i + 1);
            }
            if ((i = auth.lastIndexOf(58)) >= 0) {
                try {
                    port = Integer.parseInt(auth.substring(i + 1));
                }
                catch (NumberFormatException e) {
                    port = -1;
                }
                auth = auth.substring(0, i);
            }
            host = auth;
        }
        URL url = null;
        try {
            url = isSocketURI ? (port == -1 ? new URL("http://" + host + "/") : new URL("http://" + host + ":" + port + "/")) : uri.toURL();
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        return url;
    }

    private static String buildProxyKey(URL url) {
        StringBuilder keyBuffer = new StringBuilder();
        keyBuffer.append(url.getProtocol());
        keyBuffer.append(url.getHost());
        keyBuffer.append(url.getPort());
        return keyBuffer.toString();
    }

    private synchronized void removeProxyFromCache(URL url, String connection) {
        String key = PluginProxySelector.buildProxyKey(url);
        if (proxyCache.containsKey(key)) {
            List<Proxy> proxyList = proxyCache.get(key);
            ArrayList<Proxy> removedProxies = new ArrayList<Proxy>();
            ListIterator<Proxy> iter = proxyList.listIterator();
            while (iter.hasNext()) {
                Proxy proxy = iter.next();
                InetSocketAddress proxyAddr = (InetSocketAddress)proxy.address();
                if (proxyAddr == null || !connection.contains(proxyAddr.getHostName())) continue;
                removedProxies.add(proxy);
            }
            iter = removedProxies.listIterator();
            while (iter.hasNext()) {
                proxyList.remove(iter.next());
            }
            if (proxyList.size() == 0) {
                proxyCache.remove(key);
            }
        }
    }
}

