/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.main.client;

import com.sun.deploy.config.Config;
import java.io.IOException;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;
import sun.plugin2.applet.Plugin2Manager;
import sun.plugin2.liveconnect.BrowserSideObject;
import sun.plugin2.main.client.LiveConnectSupport;
import sun.plugin2.main.client.MessagePassingExecutionContext;
import sun.plugin2.message.Conversation;
import sun.plugin2.message.JavaObjectOpMessage;
import sun.plugin2.message.JavaScriptCallMessage;
import sun.plugin2.message.JavaScriptEvalMessage;
import sun.plugin2.message.JavaScriptMemberOpMessage;
import sun.plugin2.message.JavaScriptReplyMessage;
import sun.plugin2.message.JavaScriptSlotOpMessage;
import sun.plugin2.message.JavaScriptToStringMessage;
import sun.plugin2.message.Message;
import sun.plugin2.message.Pipe;

public class MessagePassingJSObject
extends JSObject {
    static final IllegalArgumentException BAD_METHOD_NAME_EXCEPTION = new IllegalArgumentException("Method name should not be null.");
    private BrowserSideObject object;
    private int appletID;
    private Pipe pipe;
    private Plugin2Manager manager;
    private static final boolean DEBUG = Config.getDebug();

    public MessagePassingJSObject(BrowserSideObject object, int appletID, Pipe pipe) {
        this.object = object;
        this.appletID = appletID;
        this.pipe = pipe;
        this.manager = null;
    }

    public MessagePassingJSObject(BrowserSideObject object, int appletID, Pipe pipe, Plugin2Manager manager) {
        this.object = object;
        this.appletID = appletID;
        this.pipe = pipe;
        this.manager = manager;
    }

    public BrowserSideObject getBrowserSideObject() {
        return this.object;
    }

    public int getAppletID() {
        return this.appletID;
    }

    public Plugin2Manager getManager() {
        return this.manager;
    }

    @Override
    public Object call(String methodName, Object ... args) throws JSException {
        if (this.isInvalidJSMethodName(methodName)) {
            throw BAD_METHOD_NAME_EXCEPTION;
        }
        if (this.manager != null) {
            this.manager.decreaseJava2JSCounter();
        }
        if ("eval".equals(methodName) && this.concatenatable(args)) {
            return this.eval(this.concat(args));
        }
        Conversation c = this.pipe.beginConversation();
        try {
            MessagePassingExecutionContext.AllowSetForegroundWindow();
            JavaScriptCallMessage msg = new JavaScriptCallMessage(c, this.object, this.appletID, methodName, this.convert(args));
            this.pipe.send(msg);
            Object object = this.waitForReply(c);
            return object;
        }
        catch (IOException e) {
            throw this.newJSException(e);
        }
        finally {
            this.pipe.endConversation(c);
        }
    }

    @Override
    public Object eval(String s) throws JSException {
        if (s == null || s.length() == 0) {
            return null;
        }
        if (this.manager != null) {
            this.manager.decreaseJava2JSCounter();
        }
        Conversation c = this.pipe.beginConversation();
        try {
            MessagePassingExecutionContext.AllowSetForegroundWindow();
            JavaScriptEvalMessage msg = new JavaScriptEvalMessage(c, this.object, this.appletID, s);
            this.pipe.send(msg);
            Object object = this.waitForReply(c);
            return object;
        }
        catch (IOException e) {
            throw this.newJSException(e);
        }
        finally {
            this.pipe.endConversation(c);
        }
    }

    @Override
    public Object getMember(String name) throws JSException {
        if (this.isInvalidJSMethodName(name)) {
            throw BAD_METHOD_NAME_EXCEPTION;
        }
        if (this.manager != null) {
            this.manager.decreaseJava2JSCounter();
        }
        return this.doMemberOp(name, 1, null);
    }

    @Override
    public void setMember(String name, Object value) throws JSException {
        if (this.isInvalidJSMethodName(name)) {
            throw BAD_METHOD_NAME_EXCEPTION;
        }
        if (this.manager != null) {
            this.manager.decreaseJava2JSCounter();
        }
        this.doMemberOp(name, 2, value);
    }

    @Override
    public void removeMember(String name) throws JSException {
        if (this.isInvalidJSMethodName(name)) {
            throw BAD_METHOD_NAME_EXCEPTION;
        }
        if (this.manager != null) {
            this.manager.decreaseJava2JSCounter();
        }
        this.doMemberOp(name, 3, null);
    }

    @Override
    public Object getSlot(int index) throws JSException {
        if (this.manager != null) {
            this.manager.decreaseJava2JSCounter();
        }
        return this.doSlotOp(index, 1, null);
    }

    @Override
    public void setSlot(int index, Object value) throws JSException {
        if (this.manager != null) {
            this.manager.decreaseJava2JSCounter();
        }
        this.doSlotOp(index, 2, value);
    }

    public String toString() {
        if (this.manager != null) {
            this.manager.decreaseJava2JSCounter();
        }
        Conversation c = this.pipe.beginConversation();
        try {
            JavaScriptToStringMessage msg = new JavaScriptToStringMessage(c, this.object, this.appletID);
            this.pipe.send(msg);
            String string = (String)this.waitForReply(c);
            return string;
        }
        catch (IOException e) {
            throw this.newJSException(e);
        }
        finally {
            this.pipe.endConversation(c);
        }
    }

    private Object waitForReply(Conversation c) throws JSException {
        try {
            Message msg;
            block9: while (true) {
                msg = this.pipe.receive(0L, c);
                switch (msg.getID()) {
                    case 27: {
                        JavaScriptReplyMessage reply = (JavaScriptReplyMessage)msg;
                        if (reply.getExceptionMessage() != null) {
                            throw this.newJSException(reply.getExceptionMessage());
                        }
                        return LiveConnectSupport.importObject(reply.getResult(), this.appletID);
                    }
                    case 33: {
                        try {
                            LiveConnectSupport.doObjectOp((JavaObjectOpMessage)msg);
                        }
                        catch (IOException e) {
                            throw this.newJSException(e);
                        }
                    }
                    continue block9;
                }
                break;
            }
            throw this.newJSException("Unexpected reply message ID " + msg.getID() + " from web browser");
        }
        catch (IOException e) {
            throw this.newJSException(e);
        }
        catch (InterruptedException e) {
            throw this.newJSException(e);
        }
    }

    private Object[] convert(Object[] args) {
        if (args == null) {
            return null;
        }
        Object[] newArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            newArgs[i] = LiveConnectSupport.exportObject(args[i], this.appletID, false, false);
        }
        return newArgs;
    }

    private Object doMemberOp(String memberName, int kind, Object arg) throws JSException {
        Conversation c = this.pipe.beginConversation();
        try {
            JavaScriptMemberOpMessage msg = new JavaScriptMemberOpMessage(c, this.object, this.appletID, memberName, kind, LiveConnectSupport.exportObject(arg, this.appletID, false, false));
            this.pipe.send(msg);
            Object object = this.waitForReply(c);
            return object;
        }
        catch (IOException e) {
            throw this.newJSException(e);
        }
        finally {
            this.pipe.endConversation(c);
        }
    }

    private Object doSlotOp(int slot, int kind, Object arg) throws JSException {
        Conversation c = this.pipe.beginConversation();
        try {
            JavaScriptSlotOpMessage msg = new JavaScriptSlotOpMessage(c, this.object, this.appletID, slot, kind, LiveConnectSupport.exportObject(arg, this.appletID, false, false));
            this.pipe.send(msg);
            Object object = this.waitForReply(c);
            return object;
        }
        catch (IOException e) {
            throw this.newJSException(e);
        }
        finally {
            this.pipe.endConversation(c);
        }
    }

    private JSException newJSException(Exception cause) {
        JSException res = new JSException(cause);
        if (DEBUG) {
            res.printStackTrace();
        }
        return res;
    }

    private JSException newJSException(String message) {
        JSException res = new JSException(message);
        if (DEBUG) {
            res.printStackTrace();
        }
        return res;
    }

    private boolean concatenatable(Object[] args) {
        if (args == null) {
            return true;
        }
        for (Object arg : args) {
            if (arg instanceof String) continue;
            return false;
        }
        return true;
    }

    private String concat(Object[] args) {
        StringBuilder buf = new StringBuilder();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                buf.append(args[i]);
                if (i >= args.length - 1) continue;
                buf.append(" ");
            }
        }
        return buf.toString();
    }

    private boolean isInvalidJSMethodName(String methodName) {
        return methodName == null || methodName.replaceAll("\\s", "").isEmpty();
    }
}

