/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.ipc.windows;

import java.util.Map;
import sun.plugin2.ipc.Event;
import sun.plugin2.ipc.IPCFactory;
import sun.plugin2.ipc.NamedPipe;
import sun.plugin2.ipc.windows.WindowsEvent;
import sun.plugin2.ipc.windows.WindowsNamedPipe;
import sun.plugin2.os.windows.SECURITY_ATTRIBUTES;
import sun.plugin2.os.windows.Windows;

public class WindowsIPCFactory
extends IPCFactory {
    public static final String PIPE_NAME_PREFIX = "\\\\.\\pipe\\";
    private static final int TIMEOUT = 5000;
    private SECURITY_ATTRIBUTES securityAttributes = SECURITY_ATTRIBUTES.create();
    private static int currentHandleID;
    private static final String SECURITY_DESCRIPTOR = "S:(ML;;NW;;;LW)D:(A;;FRFW;;;AU)(A;;FRFW;;;S-1-15-3-4096)";

    public WindowsIPCFactory() {
        this.securityAttributes.nLength(SECURITY_ATTRIBUTES.size());
        this.securityAttributes.bInheritHandle(1);
    }

    @Override
    public Event createEvent(Map<String, String> parameters) {
        String name = null;
        long handle = 0L;
        if (parameters == null || parameters.get("evt_name") == null) {
            name = this.nextHandleName("evt");
            handle = Windows.CreateEventA(this.securityAttributes, false, false, name);
            if (handle == 0L) {
                throw new RuntimeException("Error creating Event object");
            }
        } else {
            name = parameters.get("evt_name");
            handle = Windows.OpenEventA(2031619, true, name);
            if (handle == 0L) {
                throw new RuntimeException("Error opening Event object \"" + name + "\"");
            }
        }
        return new WindowsEvent(handle, name);
    }

    @Override
    public NamedPipe createNamedPipe(Map<String, String> parameters) {
        String writeName = null;
        String readName = null;
        long writeHandle = -1L;
        long readHandle = -1L;
        boolean iAmServer = false;
        if (parameters == null || parameters.get("write_pipe_name") == null || parameters.get("read_pipe_name") == null) {
            writeName = this.nextHandleName("pipe");
            readName = this.nextHandleName("pipe");
        } else {
            writeName = parameters.get("write_pipe_name");
            writeHandle = Windows.CreateNamedPipeA(PIPE_NAME_PREFIX + writeName, 2, 0, 255, 4096, 4096, 5000, null, SECURITY_DESCRIPTOR);
            if (writeHandle == -1L) {
                throw new RuntimeException("Error creating named pipe for writing");
            }
            readName = parameters.get("read_pipe_name");
            readHandle = Windows.CreateNamedPipeA(PIPE_NAME_PREFIX + readName, 1, 0, 255, 4096, 4096, 5000, null, SECURITY_DESCRIPTOR);
            if (readHandle == -1L) {
                throw new RuntimeException("Error creating named pipe for reading");
            }
            iAmServer = true;
        }
        return new WindowsNamedPipe(writeHandle, readHandle, writeName, readName, iAmServer);
    }

    private String nextHandleName(String handleType) {
        return "jpi2_pid" + Windows.GetCurrentProcessId() + "_" + handleType + WindowsIPCFactory.nextHandleID();
    }

    private static synchronized int nextHandleID() {
        return ++currentHandleID;
    }
}

