/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.applet;

import com.sun.deploy.appcontext.AppContext;
import com.sun.deploy.config.Config;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.CrossDomainXML;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.DeployURLClassLoader;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.HashSet;
import jdk.internal.misc.SharedSecrets;
import sun.plugin2.applet.Applet2ExecutionContext;
import sun.plugin2.applet.Plugin2ClassLoader;
import sun.plugin2.applet.Plugin2Manager;
import sun.security.util.SecurityConstants;

public class SecurityManagerHelper {
    private static final Field fcontext;
    private static final String PRINT_DIALOG_KEY = "sun.plugin.security.printDialog";
    private static final ThreadLocal<Boolean> inThreadGroupCheck;

    static void resetHelper(final HashSet<String> restrictedPackages) {
        restrictedPackages.clear();
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Enumeration<?> e = System.getProperties().propertyNames();
                while (e.hasMoreElements()) {
                    String value;
                    String name = (String)e.nextElement();
                    if (name == null || !name.startsWith("package.restrict.access.") || (value = System.getProperty(name)) == null || !value.equalsIgnoreCase("true")) continue;
                    String pkg = name.substring(24);
                    restrictedPackages.add(pkg);
                }
                return null;
            }
        });
    }

    static void checkAccessHelper(Thread t, SecurityManager sm, ClassLoader loader, Class<?>[] context) {
        if (!SecurityManagerHelper.isThreadTerminated(t) && !SecurityManagerHelper.inThreadGroup(sm, t, loader, context)) {
            sm.checkPermission(SecurityConstants.MODIFY_THREAD_PERMISSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkAccessHelper(ThreadGroup g, SecurityManager sm, ClassLoader loader, Class<?>[] context) {
        if (inThreadGroupCheck.get().equals(Boolean.TRUE)) {
            sm.checkPermission(SecurityConstants.MODIFY_THREADGROUP_PERMISSION);
        } else {
            try {
                inThreadGroupCheck.set(Boolean.TRUE);
                if (!SecurityManagerHelper.inThreadGroup(sm, g, loader, context)) {
                    sm.checkPermission(SecurityConstants.MODIFY_THREADGROUP_PERMISSION);
                }
            }
            finally {
                inThreadGroupCheck.set(Boolean.FALSE);
            }
        }
    }

    private static boolean isThreadTerminated(Thread t) {
        try {
            return t.getState() == Thread.State.TERMINATED;
        }
        catch (Throwable e) {
            return !t.isAlive();
        }
    }

    private static Plugin2ClassLoader currentAppletClassLoader(ClassLoader loader, Class<?>[] context) {
        if (loader == null || loader instanceof Plugin2ClassLoader) {
            return (Plugin2ClassLoader)((Object)loader);
        }
        for (Class<?> context1 : context) {
            loader = context1.getClassLoader();
            if (!(loader instanceof Plugin2ClassLoader)) continue;
            return (Plugin2ClassLoader)((Object)loader);
        }
        for (Class<?> aClass : context) {
            final ClassLoader currentLoader = aClass.getClassLoader();
            if (!(currentLoader instanceof DeployURLClassLoader) || (loader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    ProtectionDomain[] pds = null;
                    try {
                        AccessControlContext acc = ((DeployURLClassLoader)currentLoader).getAccessControlContext();
                        if (acc == null) {
                            return null;
                        }
                        if (Config.isJavaVersionAtLeast9()) {
                            pds = SharedSecrets.getJavaSecurityAccess().getProtectDomains(acc);
                        } else if (fcontext != null) {
                            pds = (ProtectionDomain[])fcontext.get(acc);
                        }
                        if (pds == null) {
                            return null;
                        }
                    }
                    catch (Exception e) {
                        throw new UnsupportedOperationException(e);
                    }
                    for (ProtectionDomain pd : pds) {
                        ClassLoader cl = pd.getClassLoader();
                        if (!(cl instanceof Plugin2ClassLoader)) continue;
                        return cl;
                    }
                    return null;
                }
            })) == null) continue;
            return (Plugin2ClassLoader)((Object)loader);
        }
        loader = Thread.currentThread().getContextClassLoader();
        if (loader instanceof Plugin2ClassLoader) {
            return (Plugin2ClassLoader)((Object)loader);
        }
        return null;
    }

    private static boolean inThreadGroup(SecurityManager sm, ThreadGroup g, ClassLoader loader, Class<?>[] context) {
        if (SecurityManagerHelper.currentAppletClassLoader(loader, context) == null) {
            return false;
        }
        ThreadGroup appletTG = SecurityManagerHelper.getThreadGroupHelper(sm, loader, context);
        if (appletTG == null) {
            return false;
        }
        return appletTG.parentOf(g);
    }

    private static boolean inThreadGroup(SecurityManager sm, Thread thread, ClassLoader loader, Class<?>[] context) {
        return SecurityManagerHelper.inThreadGroup(sm, thread.getThreadGroup(), loader, context);
    }

    static void checkPackageAccessHelper(SecurityManager sm, String pkgname, HashSet<String> restrictedPackages) {
        sm.checkPackageAccess(pkgname);
        for (String pkg : restrictedPackages) {
            if (!pkgname.equals(pkg) && !pkgname.startsWith(pkg + ".")) continue;
            sm.checkPermission(new RuntimePermission("accessClassInPackage." + pkgname));
        }
    }

    static void checkConnectHelper(SecurityManager sm, String host, int port, Object context, boolean hasContextParam, Class<?>[] classContext) {
        int mode;
        URL url = null;
        int n = mode = port < 0 ? port : -4;
        if (mode == -2 || mode == -3) {
            try {
                url = new URL(host);
                host = url.getHost();
                port = url.getPort();
                if (port == -1) {
                    port = url.getDefaultPort();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (CrossDomainXML.quickCheck((Class[])classContext, (String)host, (int)port)) {
            return;
        }
        try {
            if (hasContextParam) {
                sm.checkConnect(host, port, context);
            } else {
                sm.checkConnect(host, port);
            }
        }
        catch (SecurityException ex) {
            if (CrossDomainXML.check((Class[])classContext, (URL)url, (String)host, (int)port, (mode == -2 ? 1 : 0) != 0)) {
                return;
            }
            throw ex;
        }
    }

    static void checkURLPermissionHelper(SecurityManager sm, Permission perm, Object context, boolean hasContextParam, Class<?>[] classContext) {
        URL url = null;
        String host = null;
        int port = -1;
        try {
            url = new URL(perm.getName());
            host = url.getHost();
            port = url.getPort();
            if (port == -1) {
                port = url.getDefaultPort();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (url == null || host == null || port < 0) {
            if (hasContextParam) {
                sm.checkPermission(perm, context);
            } else {
                sm.checkPermission(perm);
            }
            return;
        }
        if (CrossDomainXML.quickCheck((Class[])classContext, (String)host, (int)port)) {
            return;
        }
        try {
            if (hasContextParam) {
                sm.checkPermission(perm, context);
            } else {
                sm.checkPermission(perm);
            }
        }
        catch (SecurityException ex) {
            if (CrossDomainXML.check((Class[])classContext, (URL)url, (String)host, (int)port, (boolean)false)) {
                return;
            }
            throw ex;
        }
    }

    static void checkPermissionHelper(Permission perm) {
        Applet2ExecutionContext ctx;
        if (perm.getName().equals("setSecurityManager") && !(ctx = Plugin2Manager.getCurrentAppletExecutionContext()).requestCustomSecurityManager()) {
            throw new SecurityException("JVM Shared, not allowed to set security manager");
        }
    }

    static void checkPrintJobAccessHelper(SecurityManager sm) {
        try {
            sm.checkPrintJobAccess();
            return;
        }
        catch (SecurityException securityException) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    SecurityManagerHelper.showPrintDialog();
                    return null;
                }
            });
            return;
        }
    }

    private static void showPrintDialog() {
        int result;
        String title = ResourceManager.getString((String)"plugin.print.title");
        String message = ResourceManager.getString((String)"plugin.print.message");
        String checkBoxStr = ResourceManager.getString((String)"plugin.print.always");
        String printFlag = (String)ToolkitStore.get().getAppContext().get((Object)PRINT_DIALOG_KEY);
        LocalApplicationProperties lap = null;
        if (printFlag == null && (lap = SecurityManagerHelper.getLap()) != null) {
            printFlag = lap.get(PRINT_DIALOG_KEY);
        }
        if (!Trace.isAutomationEnabled() && printFlag == null) {
            result = ToolkitStore.getUI().showMessageDialog(null, null, 7, title, null, message, null, null, checkBoxStr, null);
        } else {
            Trace.msgSecurityPrintln((String)"securitymgr.automation.printing");
            result = 0;
        }
        if (result != 0 && result != 2) {
            throw new SecurityException("checkPrintJobAccess");
        }
        ToolkitStore.get().getAppContext().put((Object)PRINT_DIALOG_KEY, (Object)"skip");
        if (result == 2 && lap != null) {
            lap.put(PRINT_DIALOG_KEY, "skip");
            try {
                lap.store();
            }
            catch (IOException e) {
                Trace.ignored((Throwable)e);
            }
        }
    }

    private static LocalApplicationProperties getLap() {
        Plugin2Manager manager = Plugin2Manager.getCurrentManager();
        if (manager != null) {
            return ResourceProvider.get().getLocalApplicationProperties(manager.getAppInfo().getLapURL(), null, true);
        }
        return null;
    }

    static void checkSecurityAccessHelper(SecurityManager sm, String action) {
        if (action != null && action.equals("java")) {
            return;
        }
        sm.checkSecurityAccess(action);
    }

    static AppContext getAppContextHelper(ClassLoader loader, Class<?>[] context) {
        Plugin2ClassLoader appletLoader = SecurityManagerHelper.currentAppletClassLoader(loader, context);
        if (appletLoader == null) {
            return null;
        }
        AppContext appContext = appletLoader.getAppContext();
        if (appContext == null) {
            throw new SecurityException("Applet classloader has invalid AppContext");
        }
        return appContext;
    }

    static ThreadGroup getThreadGroupHelper(SecurityManager sm, ClassLoader loader, Class<?>[] context) {
        ThreadGroup loaderGroup;
        Plugin2ClassLoader appletLoader = SecurityManagerHelper.currentAppletClassLoader(loader, context);
        ThreadGroup threadGroup = loaderGroup = appletLoader == null ? null : appletLoader.getThreadGroup();
        if (loaderGroup != null) {
            return loaderGroup;
        }
        return sm.getThreadGroup();
    }

    static {
        Field fc = null;
        if (!Config.isJavaVersionAtLeast9()) {
            try {
                fc = AccessControlContext.class.getDeclaredField("context");
                fc.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                throw new UnsupportedOperationException(e);
            }
        }
        fcontext = fc;
        inThreadGroupCheck = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }
        };
    }
}

