/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.viewer.context;

import java.applet.AudioClip;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.plugin.security.PluginClassLoader;
import sun.plugin.viewer.context.AppletAudioClip;
import sun.plugin.viewer.context.PluginAudioClip;

final class AppletAudioClipFactory {
    AppletAudioClipFactory() {
    }

    static AudioClip createAudioClip(final URL url) {
        AudioClip clip = AccessController.doPrivileged(new PrivilegedAction<AudioClip>(){

            @Override
            public AudioClip run() {
                try {
                    Thread t = Thread.currentThread();
                    ClassLoader cl = t.getContextClassLoader();
                    if (cl != null && cl instanceof PluginClassLoader) {
                        String clipName;
                        InputStream is;
                        PluginClassLoader pcl = (PluginClassLoader)((Object)cl);
                        String clsLoaderURLString = pcl.getBaseURL().toString();
                        String audioURLString = url.toString();
                        int i = audioURLString.indexOf(clsLoaderURLString);
                        if (i == 0 && (is = pcl.getResourceAsStream(clipName = audioURLString.charAt(clsLoaderURLString.length()) == '/' ? audioURLString.substring(clsLoaderURLString.length() + 1) : audioURLString.substring(clsLoaderURLString.length()))) != null) {
                            BufferedInputStream bis = new BufferedInputStream(is);
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            byte[] buffer = new byte[8192];
                            int byteRead = 0;
                            while ((byteRead = bis.read(buffer, 0, 8192)) != -1) {
                                bos.write(buffer, 0, byteRead);
                            }
                            bis.close();
                            byte[] data = bos.toByteArray();
                            if (data != null && data.length > 0) {
                                return new AppletAudioClip(data);
                            }
                        }
                    }
                    return new AppletAudioClip(url);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        if (clip != null) {
            return new PluginAudioClip(clip);
        }
        return null;
    }
}

