/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.net.CrossDomainXML;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLPermission;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import sun.applet.AppletSecurity;

public class ActivatorSecurityManager
extends AppletSecurity {
    private final Set<ThreadGroup> lockedThreadGroup = new HashSet<ThreadGroup>();

    public void checkSecurityAccess(String action) {
        if (action != null && action.equals("java")) {
            return;
        }
        super.checkSecurityAccess(action);
    }

    public void checkPrintJobAccess() {
        try {
            super.checkPrintJobAccess();
            return;
        }
        catch (SecurityException securityException) {
            new CheckPrint_1_2();
            return;
        }
    }

    void showPrintDialog() {
        String title = ResourceManager.getString((String)"plugin.print.title");
        String message = ResourceManager.getString((String)"plugin.print.message");
        String checkBoxStr = ResourceManager.getString((String)"plugin.print.always");
        String printFlag = (String)ToolkitStore.get().getAppContext().get((Object)"sun.plugin.security.printDialog");
        int result = 0;
        if (!Trace.isAutomationEnabled() && printFlag == null) {
            result = ToolkitStore.getUI().showMessageDialog(null, null, 7, title, null, message, null, checkBoxStr, null, null);
        } else {
            Trace.msgSecurityPrintln((String)"securitymgr.automation.printing");
            result = 0;
        }
        if (result == 2) {
            ToolkitStore.get().getAppContext().put((Object)"sun.plugin.security.printDialog", (Object)"skip");
        } else if (result != 0) {
            throw new SecurityException("checkPrintJobAccess");
        }
    }

    public Class<?>[] getExecutionStackContext() {
        return super.getClassContext();
    }

    public synchronized void checkAccess(ThreadGroup g) {
        super.checkAccess(g);
        if (g.parentOf(Thread.currentThread().getThreadGroup()) && this.lockedThreadGroup.contains(g)) {
            throw new IllegalThreadStateException("forbid thread creation in disposed TG");
        }
    }

    public synchronized void lockThreadGroup(ThreadGroup g) {
        if (g != null) {
            this.lockedThreadGroup.add(g);
        }
    }

    public synchronized void unlockThreadGroup(ThreadGroup g) {
        if (g != null) {
            this.lockedThreadGroup.remove(g);
        }
    }

    public void checkConnect(String host, int port) {
        this.checkConnectHelper(host, port, null, false, this.getClassContext());
    }

    public void checkConnect(String host, int port, Object context) {
        this.checkConnectHelper(host, port, context, true, this.getClassContext());
    }

    private void checkConnectHelper(String host, int port, Object context, boolean hasContextParam, Class<?>[] classContext) {
        int mode;
        URL url = null;
        int n = mode = port < 0 ? port : -4;
        if (mode == -2 || mode == -3) {
            try {
                url = new URL(host);
                host = url.getHost();
                port = url.getPort();
                if (port == -1) {
                    port = url.getDefaultPort();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (CrossDomainXML.quickCheck((Class[])classContext, (String)host, (int)port)) {
            return;
        }
        try {
            if (hasContextParam) {
                super.checkConnect(host, port, context);
            } else {
                super.checkConnect(host, port);
            }
        }
        catch (SecurityException ex) {
            if (CrossDomainXML.check((Class[])classContext, (URL)url, (String)host, (int)port, (mode == -2 ? 1 : 0) != 0)) {
                return;
            }
            throw ex;
        }
    }

    public void checkPermission(Permission perm) {
        if (Config.isJavaVersionAtLeast18() && perm instanceof URLPermission) {
            this.checkURLPermissionHelper(perm, null, false, this.getClassContext());
            return;
        }
        super.checkPermission(perm);
    }

    public void checkPermission(Permission perm, Object context) {
        if (Config.isJavaVersionAtLeast18() && perm instanceof URLPermission) {
            this.checkURLPermissionHelper(perm, context, true, this.getClassContext());
            return;
        }
        super.checkPermission(perm, context);
    }

    private void checkURLPermissionHelper(Permission perm, Object context, boolean hasContextParam, Class<?>[] classContext) {
        URL url = null;
        String host = null;
        int port = -1;
        try {
            url = new URL(perm.getName());
            host = url.getHost();
            port = url.getPort();
            if (port == -1) {
                port = url.getDefaultPort();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (url == null || host == null || port < 0) {
            if (hasContextParam) {
                super.checkPermission(perm, context);
            } else {
                super.checkPermission(perm);
            }
            return;
        }
        if (CrossDomainXML.quickCheck((Class[])classContext, (String)host, (int)port)) {
            return;
        }
        try {
            if (hasContextParam) {
                super.checkPermission(perm, context);
            } else {
                super.checkPermission(perm);
            }
        }
        catch (SecurityException ex) {
            if (CrossDomainXML.check((Class[])classContext, (URL)url, (String)host, (int)port, (boolean)false)) {
                return;
            }
            throw ex;
        }
    }

    private class CheckPrint_1_2
    implements PrivilegedAction<Void> {
        CheckPrint_1_2() {
            AccessController.doPrivileged(this);
        }

        @Override
        public Void run() {
            ActivatorSecurityManager.this.showPrintDialog();
            return null;
        }
    }
}

