/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import java.security.AccessController;
import java.security.PrivilegedAction;

public class SystemPropertyUtil {
    public static String getProperty(String propName, String defaultValue) {
        return AccessController.doPrivileged(new DeployGetPropertyAction(propName, defaultValue));
    }

    public static String getProperty(String propName) {
        return AccessController.doPrivileged(new DeployGetPropertyAction(propName));
    }

    public static Integer getIntProperty(String propName, int defaultValue) {
        return AccessController.doPrivileged(new DeployGetIntegerAction(propName, defaultValue));
    }

    public static Integer getIntProperty(String propName) {
        return AccessController.doPrivileged(new DeployGetIntegerAction(propName));
    }

    public static Boolean getBooleanProperty(String propName) {
        return AccessController.doPrivileged(new DeployGetBooleanAction(propName));
    }

    private static class DeployGetBooleanAction
    implements PrivilegedAction<Boolean> {
        private String theProp;

        public DeployGetBooleanAction(String theProp) {
            this.theProp = theProp;
        }

        @Override
        public Boolean run() {
            return Boolean.getBoolean(this.theProp);
        }
    }

    private static class DeployGetIntegerAction
    implements PrivilegedAction<Integer> {
        private String theProp;
        private int defaultVal;
        private boolean defaultSet = false;

        public DeployGetIntegerAction(String theProp) {
            this.theProp = theProp;
        }

        public DeployGetIntegerAction(String theProp, int defaultVal) {
            this.theProp = theProp;
            this.defaultVal = defaultVal;
            this.defaultSet = true;
        }

        @Override
        public Integer run() {
            Integer value = Integer.getInteger(this.theProp);
            if (value == null && this.defaultSet) {
                return this.defaultVal;
            }
            return value;
        }
    }

    private static class DeployGetPropertyAction
    implements PrivilegedAction<String> {
        private String theProp;
        private String defaultVal;

        public DeployGetPropertyAction(String theProp) {
            this.theProp = theProp;
        }

        public DeployGetPropertyAction(String theProp, String defaultVal) {
            this.theProp = theProp;
            this.defaultVal = defaultVal;
        }

        @Override
        public String run() {
            String value = System.getProperty(this.theProp);
            return value == null ? this.defaultVal : value;
        }
    }
}

