/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.SessionState;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Properties;
import java.util.PropertyPermission;

public class SessionProperties
extends Properties
implements SessionState.Client {
    private static final long serialVersionUID = 497074925397848464L;
    private String _filename;
    private static final AccessControlContext ACC_SESSION_INSTANCE;

    public SessionProperties(String filename) {
        this._filename = filename;
    }

    @Override
    public void importState(final File folder) {
        try {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    block6: {
                        try {
                            File f = new File(folder, SessionProperties.this._filename);
                            if (!f.exists()) break block6;
                            try (FileInputStream fis = new FileInputStream(f);){
                                SessionProperties.this.load(fis);
                            }
                        }
                        catch (Exception e) {
                            Trace.ignored(e);
                        }
                    }
                    return null;
                }
            }, ACC_SESSION_INSTANCE);
        }
        catch (Exception e) {
            Trace.ignored(e);
        }
    }

    @Override
    public void exportState(final File folder) {
        try {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    block6: {
                        try {
                            File f = new File(folder, SessionProperties.this._filename);
                            folder.mkdirs();
                            FileOutputStream fos = new FileOutputStream(f);
                            if (fos == null) break block6;
                            try {
                                SessionProperties.this.store(fos, "Session Data");
                            }
                            finally {
                                if (fos != null) {
                                    fos.flush();
                                    fos.close();
                                }
                            }
                        }
                        catch (Exception e) {
                            Trace.ignored(e);
                        }
                    }
                    return null;
                }
            }, ACC_SESSION_INSTANCE);
        }
        catch (Exception e) {
            Trace.ignored(e);
        }
    }

    static {
        Permissions perms = new Permissions();
        FilePermission perm1 = new FilePermission("<<ALL FILES>>", "read,write");
        ((PermissionCollection)perms).add(perm1);
        PropertyPermission perm2 = new PropertyPermission("*", "read,write");
        ((PermissionCollection)perms).add(perm2);
        ACC_SESSION_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
    }
}

