/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.Config;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class JarUtil {
    private static final String META_FILE_DIR = "META-INF/";
    private static final String META_VERSIONS_DIR = "META-INF/versions/";

    public static boolean isSigningRelated(String entryName) {
        if (entryName == null) {
            return false;
        }
        if (!(entryName = entryName.toUpperCase(Locale.ENGLISH)).startsWith(META_FILE_DIR)) {
            return false;
        }
        if ((entryName = entryName.substring(9)).indexOf(47) != -1) {
            return false;
        }
        if (entryName.endsWith(".DSA") || entryName.endsWith(".RSA") || entryName.endsWith(".SF") || entryName.endsWith(".EC") || entryName.equals("MANIFEST.MF")) {
            return true;
        }
        if (entryName.startsWith("SIG-")) {
            int extIndex = entryName.lastIndexOf(46);
            if (extIndex != -1) {
                String ext = entryName.substring(extIndex + 1);
                if (ext.length() > 3 || ext.length() < 1) {
                    return false;
                }
                for (int index = 0; index < ext.length(); ++index) {
                    char cc = ext.charAt(index);
                    if (cc >= 'A' && cc <= 'Z' || cc >= '0' && cc <= '9') continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean isDirectory(ZipEntry ze) {
        return ze.isDirectory() && ze.getSize() == 0L && ze.getCrc() == 0L;
    }

    public static boolean canSkipEntry(ZipEntry ze) {
        return JarUtil.isSigningRelated(ze.getName()) || JarUtil.isDirectory(ze);
    }

    public static boolean allJarEntriesSigned(JarFile jf, boolean skipMeta) throws IOException {
        if (jf == null || jf.getManifest() == null) {
            return false;
        }
        Set<String> manifestEntries = jf.getManifest().getEntries().keySet();
        Enumeration<JarEntry> entries = jf.entries();
        while (entries.hasMoreElements()) {
            JarEntry je = entries.nextElement();
            String name = je.getName();
            if (JarUtil.canSkipEntry(je) || manifestEntries.contains(name)) continue;
            Trace.println("unsigned entry: " + name, TraceLevel.SECURITY);
            if (skipMeta && name.startsWith(META_FILE_DIR) && !name.startsWith(META_VERSIONS_DIR) && !name.endsWith(".class")) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlobSigned(JarFile jf) throws IOException {
        if (jf == null || jf.getManifest() == null) {
            return false;
        }
        boolean hasBLOBFile = false;
        boolean hasSFFile = false;
        Enumeration<JarEntry> entries = jf.entries();
        while (entries.hasMoreElements()) {
            String entryName = entries.nextElement().getName().toUpperCase();
            if (!entryName.startsWith(META_FILE_DIR)) continue;
            if (entryName.equals("META-INF/SIGNATURE.BSF")) {
                hasBLOBFile = true;
                continue;
            }
            if (!entryName.endsWith(".SF")) continue;
            hasSFFile = true;
            break;
        }
        return hasBLOBFile && !hasSFFile;
    }

    public static boolean hasPerEntryManifestEntry(URL url) {
        String version = (String)ToolkitStore.get().getAppContext().get("deploy-" + url);
        Resource re = null;
        try {
            re = ResourceProvider.get().getCachedResource(url, version);
            if (re == null) {
                re = ResourceProvider.get().getResource(url, version);
            }
        }
        catch (IOException ioe) {
            Trace.ignored(ioe);
        }
        if (re != null && re.isJarFile()) {
            JarFile jf = re.getJarFile();
            if (jf != null) {
                try {
                    if (jf.getManifest() != null && !jf.getManifest().getEntries().isEmpty()) {
                        return true;
                    }
                }
                catch (IOException ioe) {
                    Trace.ignored(ioe);
                }
            }
        } else {
            Trace.println("Unable to retrieve resource from: " + url + ", " + version, TraceLevel.SECURITY);
        }
        return false;
    }

    public static JarFile createJarFile(File file, boolean verify) throws IOException {
        if (Config.isJavaVersionAtLeast9()) {
            return new JarFile(file, verify, 1, Runtime.version());
        }
        return new JarFile(file, verify);
    }
}

