/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.impl.awt;

import com.sun.applet2.preloader.Preloader;
import com.sun.deploy.appcontext.AppContext;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.UIToolkit;
import com.sun.deploy.uitoolkit.WindowFactory;
import com.sun.deploy.uitoolkit.impl.awt.AWTAppContext;
import com.sun.deploy.uitoolkit.impl.awt.AWTWindowFactory;
import com.sun.deploy.uitoolkit.impl.awt.ui.DownloadWindow;
import com.sun.deploy.uitoolkit.impl.awt.ui.UIFactoryImpl;
import com.sun.deploy.uitoolkit.ui.UIFactory;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

public class UIToolkitImpl
extends UIToolkit {
    private final UIFactory uiFactory = new UIFactoryImpl();
    private AppContext appContext;

    @Override
    public AppContext getAppContext() {
        return AWTAppContext.getInstance();
    }

    @Override
    public AppContext createAppContext() {
        return AWTAppContext.createAppContext();
    }

    @Override
    public void init() throws Exception {
    }

    @Override
    public void dispose() throws Exception {
    }

    @Override
    public UIFactory getUIFactory() {
        return this.uiFactory;
    }

    public boolean isDisposed(Object win) {
        Window window = (Window)win;
        return !window.isDisplayable();
    }

    @Override
    public WindowFactory getWindowFactory() {
        return new AWTWindowFactory();
    }

    @Override
    public Preloader getDefaultPreloader() {
        Trace.println("AWT UIToolkit get Downloadwindow as preloader ", TraceLevel.UI);
        return new DownloadWindow();
    }

    @Override
    public boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    @Override
    public void setContextClassLoader(final ClassLoader cl) {
        if (cl == null) {
            return;
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.currentThread().setContextClassLoader(cl);
                    }
                    catch (Throwable t) {
                        Trace.ignored(t);
                    }
                }
            });
        }
        catch (InterruptedException ignore) {
            Trace.ignoredException(ignore);
        }
        catch (InvocationTargetException ignore) {
            Trace.ignoredException(ignore);
        }
    }

    @Override
    public void warmup() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        this.getAppContext().invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
    }
}

