/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class HexDumpEncoderWrapper {
    private static final Class<?> encoderClass;
    private static final Method encodeBuffer;
    private static final Constructor<?> encoderCon;

    public static String encodeBuffer(byte[] src) {
        try {
            Object encoder = encoderCon.newInstance(new Object[0]);
            return (String)encodeBuffer.invoke(encoder, new Object[]{src});
        }
        catch (InvocationTargetException x) {
            HexDumpEncoderWrapper.rethrowCause(x);
            return null;
        }
        catch (ReflectiveOperationException x) {
            throw new InternalError(x);
        }
    }

    private static void rethrowCause(InvocationTargetException t) {
        Throwable cause = t.getTargetException();
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        throw new AssertionError((Object)t);
    }

    static {
        try {
            Class<?> c;
            try {
                c = Class.forName("sun.security.util.HexDumpEncoder");
            }
            catch (ClassNotFoundException x) {
                c = Class.forName("sun.misc.HexDumpEncoder");
            }
            encoderClass = c;
            encodeBuffer = encoderClass.getMethod("encodeBuffer", byte[].class);
            encoderCon = encoderClass.getConstructor(new Class[0]);
        }
        catch (ReflectiveOperationException x) {
            throw new InternalError(x);
        }
    }
}

