/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy;

import com.sun.deploy.net.proxy.BrowserProxyConfig;
import com.sun.deploy.net.proxy.BrowserProxyConfigCanonicalizer;
import com.sun.deploy.net.proxy.BrowserProxyInfo;
import com.sun.deploy.net.proxy.UserDefinedProxyConfig;
import com.sun.deploy.services.Service;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Properties;
import java.util.PropertyPermission;

public class StaticProxyManager {
    private static final AccessControlContext ACC_PROP_INSTANCE;

    public static void reset() {
        try {
            UserDefinedProxyConfig upc = new UserDefinedProxyConfig();
            BrowserProxyInfo bpi = upc.getBrowserProxyInfo();
            Service service = ServiceManager.getService();
            if (bpi.getType() == 3) {
                BrowserProxyConfig bpc = service.getProxyConfig();
                bpi = bpc.getBrowserProxyInfo();
            } else if (bpi.getType() == 2) {
                BrowserProxyConfigCanonicalizer bpcc = new BrowserProxyConfigCanonicalizer(upc, service.getAutoProxyHandler());
                bpi = bpcc.getBrowserProxyInfo();
            }
            final BrowserProxyInfo info = bpi;
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    StaticProxyManager.setProperties(info);
                    return null;
                }
            }, ACC_PROP_INSTANCE);
            Trace.msgNetPrintln(bpi.toString());
        }
        catch (Throwable e) {
            e.printStackTrace();
            ToolkitStore.getUI().showExceptionDialog(null, null, e, null, null, null, null);
        }
    }

    private static void setProperties(BrowserProxyInfo info) {
        Properties props = System.getProperties();
        switch (info.getType()) {
            case 0: {
                props.remove("trustProxy");
                props.remove("http.proxyHost");
                props.remove("http.proxyPort");
                props.remove("http.nonProxyHosts");
                props.remove("https.proxyHost");
                props.remove("https.proxyPort");
                props.remove("https.nonProxyHosts");
                props.remove("ftp.proxyHost");
                props.remove("ftp.proxyPort");
                props.remove("ftp.nonProxyHosts");
                props.remove("gopherProxySet");
                props.remove("gopherProxyHost");
                props.remove("gopherProxyPort");
                props.remove("socksProxyHost");
                props.remove("socksProxyPort");
                break;
            }
            case 1: 
            case 2: {
                props.put("trustProxy", "true");
                if (info.getHttpHost() != null) {
                    props.put("http.proxyHost", info.getHttpHost());
                    props.put("http.proxyPort", String.valueOf(info.getHttpPort()));
                    props.put("http.nonProxyHosts", info.getOverridesString());
                }
                if (info.getHttpsHost() != null) {
                    props.put("https.proxyHost", info.getHttpsHost());
                    props.put("https.proxyPort", String.valueOf(info.getHttpsPort()));
                    props.put("https.nonProxyHosts", info.getOverridesString());
                }
                if (info.getFtpHost() != null) {
                    props.put("ftp.proxyHost", info.getFtpHost());
                    props.put("ftp.proxyPort", String.valueOf(info.getFtpPort()));
                    props.put("ftp.nonProxyHosts", info.getOverridesString());
                }
                if (info.getGopherHost() != null) {
                    props.put("gopherProxySet", "true");
                    props.put("gopherProxyHost", info.getGopherHost());
                    props.put("gopherProxyPort", String.valueOf(info.getGopherPort()));
                }
                if (info.getHttpHost() != null || info.getSocksHost() == null) break;
                props.put("socksProxyHost", info.getSocksHost());
                props.put("socksProxyPort", String.valueOf(info.getSocksPort()));
                break;
            }
            case 3: {
                throw new IllegalStateException("StaticProxyManager:  ProxyType should not be BROWSER");
            }
        }
        System.setProperties(props);
    }

    static {
        Permissions perms = new Permissions();
        PropertyPermission perm = new PropertyPermission("*", "read,write");
        ((PermissionCollection)perms).add(perm);
        ACC_PROP_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
    }
}

