/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net;

import com.sun.deploy.util.SessionProperties;
import com.sun.deploy.util.SessionState;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class UpdateTracker {
    private static Object DONE = new Object();
    private static Object PENDING = new Object();
    private static Map<String, Object> state = new HashMap<String, Object>();
    private static SessionProperties sessionProps = new SessionProperties("update.tracker");

    public static synchronized void checkDone(String url) {
        if (url != null) {
            state.put(url, DONE);
            sessionProps.setProperty(UpdateTracker.encodeKey(url), "true");
        }
    }

    private static String encodeKey(String key) {
        String encoded = key.replaceAll("=", "\\=").replaceAll(":", "\\:");
        return encoded;
    }

    public static synchronized void addPending(String url) {
        if (url != null && state.get(url) != DONE) {
            state.put(url, PENDING);
        }
    }

    public static synchronized boolean isUpdated(String url) {
        return url != null && state.get(url) == DONE;
    }

    public static synchronized boolean isUpdateCheckNeeded(String url) {
        return url != null && state.get(url) == null;
    }

    public static synchronized void forceUpdate(String url) {
        state.remove(url);
    }

    public static void clear() {
        state.clear();
    }

    static {
        SessionState.register(sessionProps);
        Set<String> keys = sessionProps.stringPropertyNames();
        for (String key : keys) {
            state.put(key, DONE);
        }
    }
}

