/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.DeployCacheHandler;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.net.CanceledDownloadException;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

class DeployFileOutputStream
extends FileOutputStream {
    private final URL _url;
    private final URLConnection _conn;
    private File _file;
    private boolean _isPack = false;
    private boolean closed = false;
    private boolean finalized = false;
    private boolean aborted = false;

    DeployFileOutputStream(File file, URL url, URLConnection conn, boolean isPack) throws FileNotFoundException {
        super(file);
        this._url = url;
        this._conn = conn;
        this._file = file;
        this._isPack = isPack;
    }

    void setAbort(boolean b) {
        this.aborted = b;
    }

    protected void finalize() throws IOException {
        this.finalized = true;
        super.finalize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws IOException {
        super.close();
        if (this.closed) return;
        if (this.finalized) return;
        if (this.aborted) {
            return;
        }
        this.closed = true;
        URL urlNoQuery = HttpUtils.removeQueryStringFromURL(this._url);
        String jarVersion = (String)ToolkitStore.get().getAppContext().get("deploy-" + urlNoQuery.toString());
        boolean applyJarDiff = false;
        String mimeType = this._conn.getContentType();
        if (mimeType != null && mimeType.equalsIgnoreCase("application/x-java-jnlp-error")) {
            throw new IOException("version requested not returned");
        }
        String downloadVersion = this._conn.getHeaderField("x-java-jnlp-version-id");
        if (downloadVersion == null && Environment.isJavaPlugin()) {
            downloadVersion = jarVersion;
        }
        applyJarDiff = mimeType != null && mimeType.equalsIgnoreCase("application/x-java-archive-diff");
        InputStream fis = null;
        try {
            fis = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws IOException {
                    return new BufferedInputStream(new FileInputStream(DeployFileOutputStream.this._file));
                }
            }, DeployCacheHandler.ACC_FILE_INSTANCE);
        }
        catch (PrivilegedActionException e) {
            Trace.ignoredException(e);
        }
        String contentType = this._conn.getRequestProperty("content-type");
        try {
            CacheEntry oldCE;
            CacheEntry ce;
            int cType = 0;
            cType = this._isPack ? 4352 : (contentType != null && contentType.equals("application/x-java-archive") ? 256 : 1);
            boolean decompress = DownloadEngine.isInternalUse();
            if (!decompress && !HttpUtils.refusesIdentityEncodings(this._conn)) {
                decompress = true;
            }
            if ((ce = Cache.downloadResourceToCache(urlNoQuery, downloadVersion, this._conn, this._url, applyJarDiff, cType, fis, decompress)) != null && (oldCE = (CacheEntry)MemoryCache.addLoadedResource(urlNoQuery.toString(), ce)) != null && oldCE.getVersion() == null && ce.getVersion() == null) {
                Cache.markResourceIncomplete(oldCE);
            }
        }
        catch (CanceledDownloadException ce) {
            try {
                throw new IOException(ce.getMessage());
            }
            catch (Throwable throwable) {
                super.close();
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws IOException {
                            if (DeployFileOutputStream.this._file != null) {
                                DeployFileOutputStream.this._file.delete();
                            }
                            return null;
                        }
                    }, DeployCacheHandler.ACC_FILE_INSTANCE);
                    throw throwable;
                }
                catch (PrivilegedActionException e) {
                    Trace.ignoredException(e);
                }
                throw throwable;
            }
        }
        super.close();
        try {
            AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */, DeployCacheHandler.ACC_FILE_INSTANCE);
            return;
        }
        catch (PrivilegedActionException e) {
            Trace.ignoredException(e);
            return;
        }
    }
}

