/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.association.AssociationDesc;
import com.sun.deploy.cache.AbstractLocalApplicationProperties;
import com.sun.deploy.cache.DefaultLocalApplicationProperties;
import com.sun.deploy.model.LocalApplicationProperties;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

class CompositeLocalApplicationProperties
extends AbstractLocalApplicationProperties {
    private static final String INSTALLED_KEY_PREFIX = "installed.";
    private static final Set<String> LOCAL_KEYS = new HashSet<String>(Arrays.asList("rebootNeeded", "nativeLibDir", "installDir", "launchCount", "askedInstall", "locallyInstalled", "extensionInstalled", "jnlpInstalled", "indirectPath", "mime.types.", "title", "extensions."));
    private LocalApplicationProperties localProperies;
    private LocalApplicationProperties roamingProperties;

    CompositeLocalApplicationProperties(URL location, String versionId, boolean isApplicationDescriptor) {
        this.localProperies = new DefaultLocalApplicationProperties(location, versionId, isApplicationDescriptor, LocalApplicationProperties.Kind.LOCAL);
        this.roamingProperties = new DefaultLocalApplicationProperties(location, versionId, isApplicationDescriptor, LocalApplicationProperties.Kind.ROAMING);
    }

    @Override
    public URL getLocation() {
        return this.roamingProperties.getLocation();
    }

    @Override
    public String getVersionId() {
        return this.roamingProperties.getVersionId();
    }

    @Override
    public void setLastAccessed(Date date) {
        this.localProperies.setLastAccessed(date);
    }

    @Override
    public Date getLastAccessed() {
        return this.localProperies.getLastAccessed();
    }

    @Override
    public int getLaunchCount() {
        return this.localProperies.getLaunchCount();
    }

    @Override
    public void incrementLaunchCount() {
        this.localProperies.incrementLaunchCount();
    }

    @Override
    public void setAskedForInstall(boolean askedForInstall) {
        this.localProperies.setAskedForInstall(askedForInstall);
    }

    @Override
    public boolean getAskedForInstall() {
        return this.localProperies.getAskedForInstall();
    }

    @Override
    public void setRebootNeeded(boolean reboot) {
        this.localProperies.setRebootNeeded(reboot);
    }

    @Override
    public boolean isRebootNeeded() {
        return this.localProperies.isRebootNeeded();
    }

    @Override
    public void setShortcutInstalled(boolean installed) {
        this.localProperies.setShortcutInstalled(installed);
    }

    @Override
    public boolean isShortcutInstalled() {
        return this.localProperies.isShortcutInstalled();
    }

    @Override
    public boolean isShortcutInstalledSystem() {
        return this.localProperies.isShortcutInstalledSystem();
    }

    @Override
    public void setExtensionInstalled(boolean installed) {
        this.localProperies.setExtensionInstalled(installed);
    }

    @Override
    public boolean isExtensionInstalled() {
        return this.localProperies.isExtensionDescriptor();
    }

    @Override
    public void setJnlpInstalled(boolean installed) {
        this.localProperies.setJnlpInstalled(installed);
    }

    @Override
    public boolean isJnlpInstalled() {
        return this.localProperies.isJnlpInstalled();
    }

    @Override
    public boolean forceUpdateCheck() {
        return this.roamingProperties.forceUpdateCheck();
    }

    @Override
    public void setForceUpdateCheck(boolean state) {
        this.roamingProperties.setForceUpdateCheck(state);
    }

    @Override
    public boolean isApplicationDescriptor() {
        return this.roamingProperties.isApplicationDescriptor();
    }

    @Override
    public boolean isExtensionDescriptor() {
        return this.roamingProperties.isExtensionDescriptor();
    }

    @Override
    public AssociationDesc[] getAssociations() {
        return this.localProperies.getAssociations();
    }

    @Override
    public void addAssociation(AssociationDesc association) {
        this.localProperies.addAssociation(association);
    }

    @Override
    public void setAssociations(AssociationDesc[] associations) {
        this.localProperies.setAssociations(associations);
    }

    @Override
    public String getNativeLibDirectory() {
        return this.localProperies.getNativeLibDirectory();
    }

    @Override
    public void setNativeLibDirectory(String path) {
        this.localProperies.setNativeLibDirectory(path);
    }

    @Override
    public String getInstallDirectory() {
        return this.localProperies.getInstallDirectory();
    }

    @Override
    public void setInstallDirectory(String path) {
        this.localProperies.setInstallDirectory(path);
    }

    @Override
    public String getRegisteredTitle() {
        return this.localProperies.getRegisteredTitle();
    }

    @Override
    public void setRegisteredTitle(String title) {
        this.localProperies.setRegisteredTitle(title);
    }

    @Override
    public void setEnableCustomPreloader(boolean enable) {
        this.roamingProperties.setEnableCustomPreloader(enable);
    }

    @Override
    public boolean getEnableCustomPreloader() {
        return this.roamingProperties.getEnableCustomPreloader();
    }

    @Override
    public void put(String key, String value) {
        if (LOCAL_KEYS.contains(key) || key.startsWith(INSTALLED_KEY_PREFIX)) {
            this.localProperies.put(key, value);
        } else {
            this.roamingProperties.put(key, value);
        }
    }

    @Override
    public String get(String key) {
        if (LOCAL_KEYS.contains(key) || key.startsWith(INSTALLED_KEY_PREFIX)) {
            return this.localProperies.get(key);
        }
        return this.roamingProperties.get(key);
    }

    @Override
    public void store() throws IOException {
        this.roamingProperties.store();
        this.localProperies.store();
    }

    @Override
    public void refreshIfNecessary() {
        this.roamingProperties.refreshIfNecessary();
        this.localProperies.refreshIfNecessary();
    }

    @Override
    public void refresh() {
        this.roamingProperties.refresh();
        this.localProperies.refresh();
    }

    @Override
    public void setDraggedApplet() {
        this.roamingProperties.setDraggedApplet();
    }

    @Override
    public boolean isDraggedApplet() {
        return this.roamingProperties.isDraggedApplet();
    }

    @Override
    public String getDocumentBase() {
        return this.roamingProperties.getDocumentBase();
    }

    @Override
    public void setDocumentBase(String documentBase) {
        this.roamingProperties.setDocumentBase(documentBase);
    }

    @Override
    public String getCodebase() {
        return this.roamingProperties.getCodebase();
    }

    @Override
    public void setCodebase(String codebase) {
        this.roamingProperties.setCodebase(codebase);
    }

    @Override
    public String getMainPublisher() {
        return this.roamingProperties.getMainPublisher();
    }

    @Override
    public String getMainTitle() {
        return this.roamingProperties.getMainTitle();
    }

    @Override
    public void clearMainPublisherAndTitle() {
        this.roamingProperties.clearMainPublisherAndTitle();
    }

    @Override
    public void storeMainPublisherAndTitle(String mainPublisher, String mainTitle) {
        this.roamingProperties.storeMainPublisherAndTitle(mainPublisher, mainTitle);
    }

    @Override
    public void setOriginalURL(String string) {
        this.roamingProperties.setOriginalURL(string);
    }

    @Override
    public String getOriginalURL() {
        return this.roamingProperties.getOriginalURL();
    }
}

