/*
 * Decompiled with CFR 0.152.
 */
package com.sun.applet2.preloader.event;

import com.sun.applet2.preloader.event.PreloaderEvent;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.net.URL;

public class DownloadEvent
extends PreloaderEvent {
    public static final int DOWNLOADING = 0;
    public static final int VERIFYING = 1;
    public static final int PATCHING = 2;
    private long completed;
    private long total;
    private int percent;
    private URL url;
    private String version;
    private String resourceLabel;
    private int downloadtype;
    protected boolean isStart = false;
    protected boolean isComplete = false;
    protected boolean isExplicit = false;
    private final String[] types = new String[]{"load", "verify", "patch"};

    public DownloadEvent(int eventtype, URL location, String ver, String label, long completed, long total, int progress) {
        super(3);
        this.downloadtype = eventtype;
        this.url = location;
        this.version = ver;
        this.resourceLabel = label;
        this.completed = completed;
        this.total = total;
        this.percent = progress;
    }

    public void normalize(int baseline) {
        if (baseline >= 100 || this.percent >= 100) {
            this.percent = 100;
            return;
        }
        if (baseline < 0) {
            Trace.println("warning: progress baseline could not be negative!", TraceLevel.PRELOADER);
            return;
        }
        if (this.percent < baseline) {
            Trace.println("warning: progress baseline above the progress value! " + this.percent + " < " + baseline, TraceLevel.PRELOADER);
            this.percent = 0;
            return;
        }
        this.percent = 100 * (this.percent - baseline) / (100 - baseline);
        if (this.percent == 0) {
            this.percent = 1;
        }
    }

    public URL getURL() {
        return this.url;
    }

    public String getVersion() {
        return this.version;
    }

    public String getResourceLabel() {
        return this.resourceLabel;
    }

    public int getDownloadType() {
        return this.downloadtype;
    }

    public long getCompletedCount() {
        return this.completed;
    }

    public long getTotalCount() {
        return this.total;
    }

    public int getOverallPercentage() {
        return this.percent;
    }

    public boolean isStart() {
        return this.isStart;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public boolean isExplicit() {
        return this.isExplicit;
    }

    public void sendExplicitEvent(boolean b) {
        this.isExplicit = b;
    }

    public String toString() {
        return "DownloadEvent[type=" + this.types[this.downloadtype] + ",loaded=" + this.getCompletedCount() + ", total=" + this.getTotalCount() + ", percent=" + this.getOverallPercentage() + "]";
    }
}

