/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.main.client;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.OSType;
import com.sun.deploy.util.SystemUtils;
import java.io.IOException;
import sun.plugin2.message.Conversation;
import sun.plugin2.message.HeartbeatMessage;
import sun.plugin2.message.Message;
import sun.plugin2.message.Pipe;

public class HeartbeatThread
extends Thread {
    private static final boolean DEBUG = Config.getDebug();
    private static final boolean VERBOSE = Config.getVerbose();
    private static final long TIMEOUT_AFTER_SLEEP = 30000L;
    private static final int SLEEP_THRESHOLD_MULTIPLIER = 2;
    private static final int MAX_LOST_BEAT_COUNT = 5;
    private final Pipe pipe;
    private final boolean clientSide;
    protected boolean alive = true;
    protected Conversation conversation;
    protected HeartbeatMessage beat;
    private long MICRO_COUNT = 1000000L;

    public HeartbeatThread(String name, Pipe pipe) {
        this(name, pipe, true);
        this.setDaemon(true);
    }

    public HeartbeatThread(String name, Pipe pipe, boolean client) {
        super(name + "-Heartbeat");
        this.pipe = pipe;
        this.clientSide = client;
    }

    protected boolean keepBeating() {
        return this.alive;
    }

    public void stopBeating() {
        this.alive = false;
        this.interrupt();
    }

    protected void handleStart() throws InterruptedException, IOException {
        if (!this.alive) {
            throw new IllegalStateException("Cannot start already stopped heart");
        }
        if (this.clientSide) {
            Message m;
            if (this.conversation == null && (m = this.pipe.receive(10000L)) instanceof HeartbeatMessage) {
                this.beat = (HeartbeatMessage)m;
                this.conversation = this.beat.getConversation();
            }
            if (this.conversation == null || !this.pipe.joinConversation(this.conversation)) {
                throw new InternalError("Client failed to join heartbeat conversation " + this.conversation);
            }
            if (DEBUG) {
                System.out.println(this.getName() + " joined conversation: " + this.conversation);
            }
        } else {
            this.conversation = this.pipe.beginConversation();
            this.beat = Pipe.isLoggingEnabled() ? new HeartbeatMessage(this.conversation, 5000L, 30000L) : new HeartbeatMessage(this.conversation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        long t0 = SystemUtils.microTime();
        int lostBeatCount = 0;
        try {
            this.handleStart();
            while (this.keepBeating()) {
                HeartbeatThread heartbeatThread;
                long elapsedMillis;
                t0 = SystemUtils.microTime();
                if (this.clientSide) {
                    this.beat.updateHealthData();
                }
                this.pipe.send(this.beat);
                this.recordPingDiagnostics(t0);
                Message m = this.pipe.receive(this.beat.getTimeout(), this.conversation);
                if (m == null && (elapsedMillis = (SystemUtils.microTime() - t0) / 1000L) > this.beat.getTimeout() * 2L) {
                    long timeout = 30000L;
                    if (DEBUG) {
                        System.out.println(this.getName() + ": pipe read returns null elapsed=" + elapsedMillis + " millis while timeout=" + this.beat.getTimeout() + " Possible system sleep scenario, retry read.");
                    }
                    m = this.pipe.receive(timeout, this.conversation);
                }
                if (m == null) {
                    if (OSType.isMac() && lostBeatCount < 5) {
                        ++lostBeatCount;
                        if (DEBUG) {
                            System.out.println("Retry heartbeat... lostBeatCount: " + lostBeatCount);
                        }
                        heartbeatThread = this;
                        synchronized (heartbeatThread) {
                            this.wait(this.beat.getInterval());
                            continue;
                        }
                    }
                    this.alive = false;
                    this.recordNoAckDiagnostics(t0);
                    this.handleNoAck();
                    return;
                }
                if (DEBUG && lostBeatCount > 0) {
                    System.out.println("Received heartbeat after attempts: " + lostBeatCount);
                }
                lostBeatCount = 0;
                this.recordAckDiagnostics(t0);
                this.handleAck();
                this.beat = (HeartbeatMessage)m;
                heartbeatThread = this;
                synchronized (heartbeatThread) {
                    this.wait(this.beat.getInterval());
                }
            }
            return;
        }
        catch (Exception e) {
            this.handleException(e, t0);
            return;
        }
        finally {
            if (this.conversation != null) {
                this.pipe.endConversation(this.conversation);
            }
            this.handleStop();
        }
    }

    private long elapsedSecondsSince(long microT0) {
        return (SystemUtils.microTime() - microT0) / this.MICRO_COUNT;
    }

    protected void handleException(Exception e, long microT0) {
        long d = this.elapsedSecondsSince(microT0);
        String error = this.getName() + " heartbeat dead, exception. dT=" + d + " seconds.";
        if (DEBUG) {
            System.out.println(error);
            e.printStackTrace();
        }
    }

    protected void handleStop() {
    }

    protected void recordPingDiagnostics(long t0) {
        if (VERBOSE) {
            System.out.println(this.getName() + " sent heartbeat: " + this.beat);
        }
    }

    protected void recordAckDiagnostics(long t0) {
        if (VERBOSE) {
            long d = SystemUtils.microTime() - t0;
            System.out.println(this.getName() + " round-trip heartbeat took " + d + " microsecs.");
        }
    }

    protected void recordNoAckDiagnostics(long t0) {
        long d = this.elapsedSecondsSince(t0);
        if (DEBUG) {
            System.out.println(this.getName() + " heartbeat dead, waited " + d + " seconds.");
        }
    }

    protected void handleNoAck() {
    }

    protected void handleAck() {
    }
}

