/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.jnlp.JNLPClassLoaderUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;

public final class ApiDialog {
    private HashSet<String> _connect = new HashSet();
    private HashSet<String> _connectNo = new HashSet();
    private HashSet<String> _accept = new HashSet();
    private HashSet<String> _acceptNo = new HashSet();

    public boolean askConnect(String host) {
        String s;
        if (this._connect.contains(host)) {
            return true;
        }
        if (this._connectNo.contains(host)) {
            return false;
        }
        String title = ResourceManager.getString((String)"api.ask.host.title");
        DialogResult result = this.askUser(title, s = ResourceManager.getString((String)"api.ask.connect", (Object[])new Object[]{host}), null);
        if (result == DialogResult.OK || result == DialogResult.ALWAYS) {
            this._connect.add(host);
            try {
                String address = InetAddress.getByName(host).getHostAddress();
                this._connect.add(address);
            }
            catch (UnknownHostException e) {
                Trace.ignored((Throwable)e);
            }
            return true;
        }
        this._connectNo.add(host);
        return false;
    }

    public boolean askAccept(String host) {
        String s;
        if (this._accept.contains(host)) {
            return true;
        }
        if (this._acceptNo.contains(host)) {
            return false;
        }
        try {
            host = InetAddress.getByName(host).getHostAddress();
        }
        catch (UnknownHostException e) {
            Trace.ignored((Throwable)e);
        }
        if (this._accept.contains(host)) {
            return true;
        }
        if (this._acceptNo.contains(host)) {
            return false;
        }
        String title = ResourceManager.getString((String)"api.ask.host.title");
        DialogResult result = this.askUser(title, s = ResourceManager.getString((String)"api.ask.accept", (Object[])new Object[]{host}), null);
        if (result == DialogResult.OK || result == DialogResult.ALWAYS) {
            this._accept.add(host);
            return true;
        }
        this._acceptNo.add(host);
        return false;
    }

    DialogResult askUser(String title, String message, String always, String label, String contents, boolean alwaysChecked) {
        if (!Config.getBooleanProperty((String)"deployment.security.sandbox.jnlp.enhanced")) {
            return DialogResult.CANCEL;
        }
        AppInfo ainfo = JNLPClassLoaderUtil.getInstance().getLaunchDesc().getAppInfo();
        ainfo.setVendor(null);
        int result = ToolkitStore.getUI().showMessageDialog(null, ainfo, 7, title, null, message, label, contents, always, null);
        return ApiDialog.toDialogResult(result);
    }

    DialogResult askUser(String title, String message, String always) {
        return this.askUser(title, message, always, null, null, false);
    }

    private static DialogResult toDialogResult(int uiFacroryResult) {
        if (0 == uiFacroryResult) {
            return DialogResult.OK;
        }
        if (2 == uiFacroryResult) {
            return DialogResult.ALWAYS;
        }
        return DialogResult.CANCEL;
    }

    public static enum DialogResult {
        OK,
        ALWAYS,
        CANCEL;

    }
}

