/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.association.AssociationDesc;
import com.sun.deploy.xml.XMLAttribute;
import com.sun.deploy.xml.XMLAttributeBuilder;
import com.sun.deploy.xml.XMLNode;
import com.sun.deploy.xml.XMLNodeBuilder;
import com.sun.deploy.xml.XMLable;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.RContentDesc;
import com.sun.javaws.jnl.ShortcutDesc;
import java.net.URL;

public class InformationDesc
implements XMLable {
    private String _title;
    private String _vendor;
    private URL _home;
    private String[] _descriptions;
    private IconDesc[] _icons;
    private ShortcutDesc _shortcutHints;
    private AssociationDesc[] _associations;
    private RContentDesc[] _relatedContent;
    private boolean _supportOfflineOperation;
    public static final int DESC_DEFAULT = 0;
    public static final int DESC_SHORT = 1;
    public static final int DESC_ONELINE = 2;
    public static final int DESC_TOOLTIP = 3;
    public static final int NOF_DESC = 4;

    public InformationDesc(String title, String vendor, URL home, String[] descriptions, IconDesc[] icons, ShortcutDesc shortcutHints, RContentDesc[] relatedContent, AssociationDesc[] associations, boolean supportOfflineOperation) {
        this._title = title == null ? "" : title;
        this._vendor = vendor == null ? "" : vendor;
        this._home = home;
        if (descriptions == null) {
            descriptions = new String[4];
        }
        this._descriptions = descriptions;
        this._icons = this.cloneIcons(icons);
        this._shortcutHints = shortcutHints;
        this._associations = this.cloneAssociations(associations);
        this._relatedContent = this.cloneRelatedContent(relatedContent);
        this._supportOfflineOperation = supportOfflineOperation;
    }

    public String getTitle() {
        return this._title;
    }

    public String getVendor() {
        return this._vendor;
    }

    public URL getHome() {
        return this._home;
    }

    public boolean supportsOfflineOperation() {
        return this._supportOfflineOperation;
    }

    public IconDesc[] getIcons() {
        return this.cloneIcons(this._icons);
    }

    private IconDesc[] cloneIcons(IconDesc[] source) {
        if (source == null) {
            return null;
        }
        IconDesc[] icons = new IconDesc[source.length];
        for (int i = 0; i < source.length; ++i) {
            icons[i] = new IconDesc(source[i].getLocation(), source[i].getVersion(), source[i].getHeight(), source[i].getWidth(), source[i].getDepth(), source[i].getKind());
        }
        return icons;
    }

    public ShortcutDesc getShortcut() {
        if (this._shortcutHints == null) {
            return null;
        }
        return new ShortcutDesc(this._shortcutHints.getOnline(), this._shortcutHints.getInstall(), this._shortcutHints.getDesktop(), this._shortcutHints.getMenu(), this._shortcutHints.getSubmenu());
    }

    public AssociationDesc[] getAssociations() {
        return this.cloneAssociations(this._associations);
    }

    private AssociationDesc[] cloneAssociations(AssociationDesc[] source) {
        if (source == null) {
            return null;
        }
        AssociationDesc[] assoc = new AssociationDesc[source.length];
        for (int i = 0; i < source.length; ++i) {
            assoc[i] = new AssociationDesc(source[i].getExtensions(), source[i].getMimeType(), source[i].getMimeDescription(), source[i].getIconUrl());
        }
        return assoc;
    }

    public RContentDesc[] getRelatedContent() {
        return this.cloneRelatedContent(this._relatedContent);
    }

    private RContentDesc[] cloneRelatedContent(RContentDesc[] source) {
        if (source == null) {
            return null;
        }
        RContentDesc[] rc = new RContentDesc[source.length];
        for (int i = 0; i < source.length; ++i) {
            rc[i] = new RContentDesc(source[i].getHref(), source[i].getTitle(), source[i].getDescription(), source[i].getIcon());
        }
        return rc;
    }

    public boolean hintsInstall() {
        return false;
    }

    public void setShortcut(ShortcutDesc shortcut) {
        this._shortcutHints = shortcut;
    }

    public void setAssociation(AssociationDesc assoc) {
        this._associations = assoc == null ? null : new AssociationDesc[]{assoc};
    }

    public String getDescription(int kind) {
        return this._descriptions[kind];
    }

    public IconDesc getIconLocation(int size, int kind) {
        if (this._icons == null) {
            return null;
        }
        IconDesc bestID = null;
        long bestMatch = 0L;
        for (int i = 0; i < this._icons.length; ++i) {
            boolean typeOK;
            IconDesc id = this._icons[i];
            boolean bl = typeOK = kind == 5 || !id.getSuffix().equalsIgnoreCase(".ico");
            if (id.getKind() != kind || !typeOK) continue;
            if (id.getHeight() == size && id.getWidth() == size) {
                return id;
            }
            if (id.getHeight() == 0 && id.getWidth() == 0) {
                if (bestID != null) continue;
                bestID = id;
                continue;
            }
            int diff = id.getHeight() + id.getWidth() - 2 * size;
            long delta = Math.abs(diff);
            if (bestMatch == 0L || delta < bestMatch) {
                bestMatch = delta;
                bestID = id;
                continue;
            }
            if (delta != bestMatch || diff <= 0) continue;
            bestID = id;
        }
        return bestID;
    }

    public XMLNode asXML() {
        int i;
        XMLAttributeBuilder ab = new XMLAttributeBuilder();
        XMLNodeBuilder nb = new XMLNodeBuilder("information", ab.getAttributeList());
        nb.add("title", this._title);
        nb.add("vendor", this._vendor);
        nb.add(new XMLNode("homepage", new XMLAttribute("href", this._home != null ? this._home.toString() : null), null, null));
        nb.add(this.getDescriptionNode(0, ""));
        nb.add(this.getDescriptionNode(1, "short"));
        nb.add(this.getDescriptionNode(2, "one-line"));
        nb.add(this.getDescriptionNode(3, "tooltip"));
        if (this._icons != null) {
            for (i = 0; i < this._icons.length; ++i) {
                nb.add((XMLable)this._icons[i]);
            }
        }
        if (this._shortcutHints != null) {
            nb.add((XMLable)this._shortcutHints);
        }
        if (this._associations != null) {
            for (i = 0; i < this._associations.length; ++i) {
                nb.add((XMLable)this._associations[i]);
            }
        }
        if (this._relatedContent != null) {
            for (i = 0; i < this._relatedContent.length; ++i) {
                nb.add((XMLable)this._relatedContent[i]);
            }
        }
        if (this._supportOfflineOperation) {
            nb.add(new XMLNode("offline-allowed", null));
        }
        return nb.getNode();
    }

    private XMLNode getDescriptionNode(int kind, String kindStr) {
        String value = this._descriptions[kind];
        if (value == null) {
            return null;
        }
        XMLAttributeBuilder ab = new XMLAttributeBuilder();
        ab.add("kind", kindStr);
        return new XMLNode("description", ab.getAttributeList(), new XMLNode(value), null);
    }
}

