/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.util;

import com.sun.applet2.AppletParameters;
import com.sun.deploy.Environment;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.JfxRuntime;
import com.sun.deploy.config.OSType;
import com.sun.deploy.config.Platform;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.JVMParameters;
import com.sun.deploy.util.VersionID;
import java.io.File;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.plugin2.main.client.ClientJVMSelectionParameters;
import sun.plugin2.util.BrowserType;

public class PluginJVMUtil {
    static boolean DEBUG = Config.getDebug();
    private static final String JAVA_EXT_DIRS = "-Djava.ext.dirs=";
    private static final String TRUSTED_DIR = File.separator + "lib" + File.separator + "trusted";

    private static String getVmArgs(JREInfo info) {
        String vmOptions = Environment.getenv((String)"FORCED_CLIENTVM_ARGS");
        if (DEBUG && vmOptions != null) {
            System.out.println("JVMManager: using override from FORCED_CLIENTVM_ARGS" + vmOptions);
        }
        if (vmOptions == null) {
            vmOptions = Environment.getenv((String)"_JPI_VM_OPTIONS");
        }
        if (vmOptions != null) {
            return vmOptions;
        }
        return info.getVmArgs();
    }

    public static JVMParameters getDefaultVmArgs(JREInfo jreInfo) {
        JVMParameters params = new JVMParameters();
        params.parseTrustedOptions(PluginJVMUtil.getVmArgs(jreInfo));
        params.setDefault(true);
        return params;
    }

    public static JVMParameters extractAppletParamsToJVMParameters(AppletParameters params, String docbase, boolean isRelaunch, boolean includeExtendedASCIIValues) {
        JVMParameters jvmParams = new JVMParameters();
        jvmParams.addInternalArgument("-Djava.class.path=" + Config.getJREHome() + File.separator + "classes");
        String sessionState = (String)params.get((Object)"__applet_session_data");
        if (sessionState != null && isRelaunch) {
            jvmParams.addInternalArgument("-Djnlpx.session.data=" + sessionState);
        }
        jvmParams.setDefault(true);
        String untrustedJvmArgsE = (String)params.get((Object)"java_arguments");
        if (untrustedJvmArgsE != null) {
            jvmParams.setIncludeExtendedASCIIValues(includeExtendedASCIIValues);
            jvmParams.setHtmlJavaArgs(true);
            jvmParams.addEncodedArguments(untrustedJvmArgsE, false, false, !isRelaunch);
        } else {
            jvmParams.setHtmlJavaArgs(false);
        }
        if (OSType.isMac()) {
            PluginJVMUtil.scopeJVMInstanceByHost(PluginJVMUtil.getURLHost(docbase), jvmParams);
        }
        return jvmParams;
    }

    private static String getURLHost(String url) {
        if (url != null) {
            try {
                URI uri = new URI(url);
                return uri.getHost();
            }
            catch (Exception e) {
                Trace.ignored((Throwable)e);
            }
        }
        return null;
    }

    public static JVMParameters prepareJVMParameter(JVMParameters parameters, JREInfo info, JVMParameters defaultParams, ClientJVMSelectionParameters deployParams, boolean isRelaunch) {
        JVMParameters params = new JVMParameters();
        VersionID fxVerAsked = deployParams.getJfxRequirement();
        boolean useJfxToolkit = false;
        JfxRuntime fx = null;
        if (null != fxVerAsked) {
            if (DEBUG) {
                System.out.println("Need JavaFX version: " + fxVerAsked);
            }
            if (!info.getProductVersion().isGreaterThanOrEqual(ClientJVMSelectionParameters.JFX_JRE_MINIMUM_VER)) {
                if (DEBUG) {
                    System.out.println("JavaFX requires minimum JRE version: " + ClientJVMSelectionParameters.JFX_JRE_MINIMUM_VER);
                }
                return null;
            }
            fx = info.getJfxRuntime();
            if (fx == null) {
                System.out.println("Launching in a vanilla JVM to install JavaFX and relaunch.");
            } else {
                if (!deployParams.useJfxToolkit()) {
                    params.addInternalArgument("-Djnlp.tk=awt");
                } else {
                    useJfxToolkit = true;
                }
                params.addInternalArgument("-Djnlp.fx=" + fx.getProductVersion().toString());
            }
        }
        if (DEBUG) {
            System.out.println("    JVMManager.createJVMInstance passing along JVM parameters from deployment.properties");
        }
        params.addArguments(defaultParams);
        if (DEBUG) {
            System.out.println("    JVMManager.createJVMInstance passing along JVM parameters from this applet instance");
        }
        PluginJVMUtil.addClassPath(parameters, info);
        params.addArguments(parameters);
        params.setHtmlJavaArgs(parameters.isHtmlJavaArgs());
        PluginJVMUtil.maintainCurrentArchFlag(params, info);
        PluginJVMUtil.addJavaExtDirsOption(params);
        PluginJVMUtil.addXToolkitOption(params, info.getProductVersion());
        PluginJVMUtil.addUIElementOption(params);
        if (!useJfxToolkit) {
            params.addInternalArgument("-Dsun.awt.warmup=true");
        }
        return params;
    }

    private static void addClassPath(JVMParameters jvmParams, JREInfo info) {
        if (!info.isModularJRE()) {
            jvmParams.parseBootClassPath(JVMParameters.getPlugInDependentJars());
        }
    }

    private static void scopeJVMInstanceByHost(String host, JVMParameters jvmParams) {
        Object utf8ProcessName;
        String processName;
        if (host != null) {
            jvmParams.addInternalArgument("-Djava.applet.host=" + host);
            processName = ResourceManager.getString((String)"applet.host.app.title", (Object[])new Object[]{host});
        } else {
            processName = ResourceManager.getString((String)"applet.host.app.title.nohost");
        }
        String javaProcessName = "-Xdock:name=" + processName;
        Charset charset = Charset.forName("UTF-8");
        CharsetDecoder decoder = charset.newDecoder();
        CharsetEncoder encoder = charset.newEncoder();
        try {
            ByteBuffer bbuf = encoder.encode(CharBuffer.wrap(javaProcessName));
            CharBuffer cbuf = decoder.decode(bbuf);
            utf8ProcessName = cbuf.toString();
        }
        catch (CharacterCodingException e) {
            utf8ProcessName = "-Xdock:name=Java Applet - " + host;
        }
        jvmParams.addInternalArgument((String)utf8ProcessName);
        jvmParams.addInternalArgument("-Xdock:icon=" + Platform.get().getDefaultIconPath());
    }

    private static void maintainCurrentArchFlag(JVMParameters params, JREInfo info) {
        if (OSType.isMac() && !params.contains("-d32") && !params.contains("-d64")) {
            if ("x86_64".equals(info.getOSArch()) || "amd64".equals(info.getOSArch())) {
                params.addInternalArgument("-d64");
            } else {
                params.addInternalArgument("-d32");
            }
        }
    }

    private static void addXToolkitOption(JVMParameters parameters, VersionID version) {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith("sunos") && new VersionID("1.5*").match(version)) {
            parameters.addInternalArgument("-Dawt.toolkit=sun.awt.X11.XToolkit");
        }
    }

    private static void addUIElementOption(JVMParameters parameters) {
        if (OSType.isMac()) {
            parameters.addInternalArgument("-Dapple.awt.UIElement=true");
        }
    }

    private static void addJavaExtDirsOption(JVMParameters parameters) {
        String javaExtDirsProp = PluginJVMUtil.getJavaExtDirsProp(parameters);
        if (null != javaExtDirsProp) {
            parameters.addInternalArgument(javaExtDirsProp);
        }
    }

    private static String getJavaExtDirsProp(JVMParameters params) {
        String ret;
        String jssPath;
        File jssDir;
        boolean isMozilla;
        if (params.containsPrefix(JAVA_EXT_DIRS)) {
            return null;
        }
        StringBuilder sb = new StringBuilder(JAVA_EXT_DIRS);
        sb.append(Config.getJREHome() + File.separator + "lib" + File.separator + "ext");
        String defaultProp = sb.toString();
        boolean bl = isMozilla = BrowserType.getBrowserType() == 3;
        if (isMozilla && (jssDir = new File(jssPath = Platform.get().getBrowserHomePath() + File.separator + "jss")).exists()) {
            sb.append(File.pathSeparator);
            sb.append(jssPath);
        }
        String trustedPath = Config.getSystemHome() + TRUSTED_DIR;
        File trustedDir = new File(trustedPath);
        if (OSType.isWin() && trustedDir.exists()) {
            sb.append(File.pathSeparator);
            sb.append(trustedPath);
        }
        if ((ret = sb.toString()).equals(defaultProp)) {
            return null;
        }
        return ret;
    }
}

