/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.main.client;

import com.sun.deploy.config.Config;
import com.sun.deploy.ref.AppRef;
import com.sun.deploy.ref.CodeInstance;
import com.sun.deploy.ref.CodeRef;
import com.sun.deploy.security.SandboxSecurity;
import com.sun.deploy.security.SecureCookiePermission;
import com.sun.deploy.security.ruleset.BlockRule;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.java.browser.plugin2.liveconnect.v1.Bridge;
import com.sun.java.browser.plugin2.liveconnect.v1.ConversionDelegate;
import com.sun.java.browser.plugin2.liveconnect.v1.InvocationDelegate;
import com.sun.java.browser.plugin2.liveconnect.v1.Result;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;
import sun.net.www.ParseUtil;
import sun.plugin2.applet.Plugin2ClassLoader;
import sun.plugin2.applet.Plugin2Manager;
import sun.plugin2.liveconnect.ArgumentHelper;
import sun.plugin2.liveconnect.BrowserSideObject;
import sun.plugin2.liveconnect.JavaClass;
import sun.plugin2.liveconnect.JavaScriptProtectionDomain;
import sun.plugin2.liveconnect.RemoteJavaObject;
import sun.plugin2.main.client.MessagePassingJSObject;
import sun.plugin2.main.client.MessagePassingOneWayJSObject;
import sun.plugin2.message.JavaObjectOpMessage;
import sun.plugin2.message.JavaReplyMessage;
import sun.plugin2.message.JavaScriptReleaseObjectMessage;
import sun.plugin2.message.Pipe;

public class LiveConnectSupport {
    private static final boolean DEBUG = Config.getDebug();
    private static Pipe pipe;
    private static int jvmID;
    private static ReferenceQueue<Object> queue;
    private static volatile boolean shouldStop;
    private static Thread cleanupThread;
    private static Vector<BrowserSideObjectReference> bsoRefs;
    private static Map<Object, RemoteJavaObject> exportedObjectMap;
    private static Map<Integer, Object> objectIDMap;
    private static int nextObjectID;
    private static Map<Integer, PerAppletInfo> appletInfoMap;

    private LiveConnectSupport() {
    }

    public static void initialize(Pipe pipe, int jvmID) {
        LiveConnectSupport.pipe = pipe;
        LiveConnectSupport.jvmID = jvmID;
        cleanupThread = new BrowserSideObjectCleanupThread();
        cleanupThread.start();
    }

    public static void shutdown() {
        shouldStop = true;
        cleanupThread.interrupt();
    }

    public static synchronized void appletStarted(int appletID, Plugin2Manager manager) {
        appletInfoMap.put(appletID, new PerAppletInfo(appletID, manager));
    }

    public static synchronized void appletStopped(int appletID) {
        PerAppletInfo info = appletInfoMap.remove(appletID);
        if (info != null) {
            info.stop();
        }
    }

    public static Object exportObject(Object obj, int appletID, boolean skipUnboxing, boolean isApplet) {
        if (obj == null) {
            return obj;
        }
        if (ArgumentHelper.isPrimitiveOrString(obj) && !skipUnboxing) {
            return obj;
        }
        if (obj instanceof MessagePassingJSObject) {
            return ((MessagePassingJSObject)obj).getBrowserSideObject();
        }
        return LiveConnectSupport.exportRemoteObject(obj, appletID, isApplet);
    }

    public static Object importObject(Object obj, int appletID) {
        if (obj == null) {
            return obj;
        }
        if (ArgumentHelper.isPrimitiveOrString(obj)) {
            return obj;
        }
        if (obj instanceof BrowserSideObject) {
            BrowserSideObject browserObject = (BrowserSideObject)obj;
            MessagePassingJSObject jsObject = new MessagePassingJSObject(browserObject, appletID, pipe);
            LiveConnectSupport.track(jsObject);
            return jsObject;
        }
        if (obj instanceof RemoteJavaObject) {
            return LiveConnectSupport.importRemoteObject((RemoteJavaObject)obj);
        }
        throw new IllegalArgumentException("Unsupported argument type " + obj.getClass().getName());
    }

    public static Object importOneWayJSObject(Object obj, int appletID, Plugin2Manager manager) {
        if (obj == null) {
            return obj;
        }
        if (ArgumentHelper.isPrimitiveOrString(obj)) {
            return obj;
        }
        if (obj instanceof BrowserSideObject) {
            BrowserSideObject browserObject = (BrowserSideObject)obj;
            MessagePassingJSObject targetJSObject = new MessagePassingJSObject(browserObject, appletID, pipe, manager);
            MessagePassingOneWayJSObject jsObject = new MessagePassingOneWayJSObject(targetJSObject);
            LiveConnectSupport.track2(jsObject);
            return jsObject;
        }
        if (obj instanceof RemoteJavaObject) {
            return LiveConnectSupport.importRemoteObject((RemoteJavaObject)obj);
        }
        throw new IllegalArgumentException("Unsupported argument type " + obj.getClass().getName());
    }

    public static void doObjectOp(JavaObjectOpMessage msg) throws IOException {
        RemoteJavaObject obj = msg.getObject();
        PerAppletInfo info = LiveConnectSupport.getInfo(obj.getAppletID());
        if (info != null) {
            if (msg.getConversation() == null) {
                info.enqueue(msg);
            } else {
                info.doObjectOp(msg);
            }
        } else {
            pipe.send(new JavaReplyMessage(msg.getConversation(), msg.getResultID(), null, false, "Applet ID " + obj.getAppletID() + " is not registered in this JVM instance"));
        }
    }

    public static synchronized void releaseRemoteObject(RemoteJavaObject object) {
        Integer key = object.getObjectID();
        Object realObject = objectIDMap.remove(key);
        if (realObject != null) {
            exportedObjectMap.remove(realObject);
        }
    }

    private static void track(MessagePassingJSObject obj) {
        bsoRefs.add(new BrowserSideObjectReference(obj, queue, obj.getBrowserSideObject(), obj.getAppletID()));
    }

    private static void track2(MessagePassingOneWayJSObject obj) {
        bsoRefs.add(new BrowserSideObjectReference(obj, queue, obj.getBrowserSideObject(), obj.getAppletID()));
    }

    private static synchronized RemoteJavaObject exportRemoteObject(Object object, int appletID, boolean isApplet) {
        RemoteJavaObject remote = exportedObjectMap.get(object);
        if (remote != null && !LiveConnectSupport.isAppletRunning(remote.getAppletID())) {
            LiveConnectSupport.releaseRemoteObject(remote);
            remote = null;
        }
        if (remote == null) {
            int objectID = ++nextObjectID;
            remote = new RemoteJavaObject(jvmID, appletID, objectID, isApplet);
            exportedObjectMap.put(object, remote);
            objectIDMap.put(objectID, object);
        }
        return remote;
    }

    private static synchronized Object importRemoteObject(RemoteJavaObject object) {
        return objectIDMap.get(object.getObjectID());
    }

    private static synchronized void releaseRemoteObjects(int appletID) {
        ArrayList<RemoteJavaObject> objectsToRelease = new ArrayList<RemoteJavaObject>();
        for (RemoteJavaObject obj : exportedObjectMap.values()) {
            if (obj.getAppletID() != appletID) continue;
            objectsToRelease.add(obj);
        }
        Iterator iter = objectsToRelease.iterator();
        while (iter.hasNext()) {
            LiveConnectSupport.releaseRemoteObject((RemoteJavaObject)iter.next());
        }
    }

    private static synchronized PerAppletInfo getInfo(int appletID) {
        return appletInfoMap.get(appletID);
    }

    private static boolean isAppletRunning(int appletID) {
        return LiveConnectSupport.getInfo(appletID) != null;
    }

    public static synchronized Bridge getBridge(Object applet) {
        for (PerAppletInfo info : appletInfoMap.values()) {
            if (!info.hostsApplet(applet)) continue;
            return info.getBridge();
        }
        return null;
    }

    private static AccessControlContext createContext(URL codeBase) {
        try {
            ProtectionDomain[] domains = new ProtectionDomain[]{LiveConnectSupport.getJSProtectionDomain(codeBase)};
            return new AccessControlContext(domains);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static ProtectionDomain getJSProtectionDomain(URL url) throws MalformedURLException {
        Policy policy = AccessController.doPrivileged(new PrivilegedAction<Policy>(){

            @Override
            public Policy run() {
                return Policy.getPolicy();
            }
        });
        CodeSource cs = new CodeSource(null, (Certificate[])null);
        PermissionCollection pc = policy.getPermissions(cs);
        Plugin2ClassLoader.addDefaultPermissions(pc);
        if (url != null) {
            Permission p;
            Object path = null;
            try {
                p = url.openConnection().getPermission();
            }
            catch (IOException ioe) {
                p = null;
            }
            if (p instanceof FilePermission) {
                path = p.getName();
            } else if (p == null && url.getProtocol().equals("file")) {
                path = url.getFile().replace('/', File.separatorChar);
                path = ParseUtil.decode((String)path);
            } else if (p instanceof SocketPermission) {
                String host = url.getHost();
                URL theUrl = url;
                if (host == null || host.equals("")) {
                    try {
                        theUrl = new URL(url.getFile());
                        host = theUrl.getHost();
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                if (host != null && !host.equals("")) {
                    SandboxSecurity.addConnectPermission((PermissionCollection)pc, (URL)theUrl);
                    pc.add((Permission)new SecureCookiePermission(SecureCookiePermission.getURLOriginString((URL)url)));
                    Trace.println((String)("Grant liveconnect connect perm for " + url + " : " + pc), (TraceLevel)TraceLevel.SECURITY);
                }
            }
            if (path != null) {
                if (((String)path).endsWith(File.separator)) {
                    path = (String)path + "-";
                } else {
                    int endIndex = ((String)path).lastIndexOf(File.separatorChar);
                    if (endIndex != -1) {
                        path = ((String)path).substring(0, endIndex + 1) + "-";
                    }
                }
                pc.add(new FilePermission((String)path, "read"));
            }
        }
        return new JavaScriptProtectionDomain(pc);
    }

    private static String getOpName(int objectOpKind) {
        switch (objectOpKind) {
            case 1: {
                return "CALL_METHOD";
            }
            case 2: {
                return "GET_FIELD";
            }
            case 3: {
                return "SET_FIELD";
            }
            case 4: {
                return "HAS_FIELD";
            }
            case 5: {
                return "HAS_METHOD";
            }
            case 6: {
                return "HAS_FIELD_OR_METHOD";
            }
        }
        throw new IllegalArgumentException("Invalid operation kind " + objectOpKind);
    }

    static {
        queue = new ReferenceQueue();
        bsoRefs = new Vector();
        exportedObjectMap = new IdentityHashMap<Object, RemoteJavaObject>();
        objectIDMap = new HashMap<Integer, Object>();
        appletInfoMap = new HashMap<Integer, PerAppletInfo>();
    }

    private static class PerAppletInfo {
        private int appletID;
        private Plugin2Manager manager;
        private LiveConnectWorker worker;
        private BridgeImpl bridge;
        private boolean fetchedDocumentBase;
        private URL documentBase;
        private AccessControlContext context;
        private List<InvocationDelegate> invocationDelegates = Collections.synchronizedList(new ArrayList());
        private List<ConversionDelegate> conversionDelegates = Collections.synchronizedList(new ArrayList());
        private Map<Class<?>, JavaClass> classes = new HashMap();
        private Set<String> notJavaClasses = new HashSet<String>();
        DeploymentRuleSet docbaseDRS = null;
        DeploymentRuleSet mainAppletDRS = null;

        public PerAppletInfo(int appletID, Plugin2Manager manager) {
            this.appletID = appletID;
            this.manager = manager;
            this.bridge = new BridgeImpl(this);
            this.register(new DefaultInvocationDelegate());
            this.register(new DefaultConversionDelegate());
            this.worker = new LiveConnectWorker();
            manager.startWorkerThread("Applet " + appletID + " LiveConnect Worker Thread", this.worker);
        }

        public boolean hostsApplet(Object applet) {
            return this.manager != null && this.manager.getApplet2Adapter().getLiveConnectObject() == applet;
        }

        public Bridge getBridge() {
            return this.bridge;
        }

        public void register(InvocationDelegate delegate) {
            this.invocationDelegates.add(0, delegate);
        }

        public void unregister(InvocationDelegate delegate) {
            this.invocationDelegates.remove(delegate);
        }

        public void register(ConversionDelegate delegate) {
            this.conversionDelegates.add(0, delegate);
        }

        public void unregister(ConversionDelegate delegate) {
            this.conversionDelegates.remove(delegate);
        }

        public int conversionCost(final Object object, final Object toType) {
            final int[] resultBox = new int[1];
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    for (ConversionDelegate delegate : conversionDelegates) {
                        int cost = delegate.conversionCost(object, toType);
                        if (cost < 0) continue;
                        resultBox[0] = cost;
                        return null;
                    }
                    resultBox[0] = -1;
                    return null;
                }
            }, this.getContext());
            return resultBox[0];
        }

        public Object convert(final Object object, final Object toType) throws Exception {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    Object[] resultBox = new Object[1];
                    for (ConversionDelegate delegate : conversionDelegates) {
                        if (!delegate.convert(object, toType, resultBox)) continue;
                        return resultBox[0];
                    }
                    throw PerAppletInfo.inconvertible(object, toType);
                }
            }, this.getContext());
        }

        public void enqueue(JavaObjectOpMessage msg) {
            this.worker.enqueue(msg);
        }

        public void stop() {
            this.bridge.stop();
            this.worker.stop();
            LiveConnectSupport.releaseRemoteObjects(this.appletID);
        }

        public void doObjectOp(final JavaObjectOpMessage msg) throws IOException {
            JavaReplyMessage reply = null;
            if (DEBUG) {
                System.out.println("LiveConnectSupport: " + LiveConnectSupport.getOpName(msg.getOperationKind()) + " \"" + msg.getMemberName() + "\"");
            }
            if (!this.isLiveconnectCallAllowed(msg)) {
                RemoteJavaObject obj = msg.getObject();
                reply = new JavaReplyMessage(msg.getConversation(), msg.getResultID(), null, false, "Liveconnect call for Applet ID " + obj.getAppletID() + " is not allowed in this JVM instance");
                pipe.send(reply);
                return;
            }
            try {
                this.waitForAppletStartOrError();
                if (this.manager.hasErrorOccurred()) {
                    if (this.manager.getErrorMessage() != null) {
                        throw new RuntimeException(this.manager.getErrorMessage());
                    }
                    if (this.manager.getErrorException() != null) {
                        throw (IOException)new IOException().initCause(this.manager.getErrorException());
                    }
                }
                final Object target = LiveConnectSupport.importObject(msg.getObject(), this.appletID);
                final Object[] args = msg.getArguments();
                if (args != null) {
                    for (int i = 0; i < args.length; ++i) {
                        args[i] = LiveConnectSupport.importObject(args[i], this.appletID);
                    }
                }
                Result result = null;
                final boolean isApplet = msg.getObject().isApplet();
                boolean resultIsVoid = false;
                switch (msg.getOperationKind()) {
                    case 1: {
                        result = AccessController.doPrivileged(new PrivilegedExceptionAction<Result>(){

                            @Override
                            public Result run() throws Exception {
                                InvocationDelegate delegate;
                                Result[] resultBox = new Result[1];
                                Iterator iterator = invocationDelegates.iterator();
                                while (iterator.hasNext() && !(delegate = (InvocationDelegate)iterator.next()).invoke(msg.getMemberName(), target, args, false, isApplet, resultBox)) {
                                }
                                return resultBox[0];
                            }
                        }, this.getContext());
                        if (result.value() != Void.TYPE) break;
                        resultIsVoid = true;
                        result = null;
                        break;
                    }
                    case 2: {
                        result = AccessController.doPrivileged(new PrivilegedExceptionAction<Result>(){

                            @Override
                            public Result run() throws Exception {
                                InvocationDelegate delegate;
                                Result[] resultBox = new Result[1];
                                Iterator iterator = invocationDelegates.iterator();
                                while (iterator.hasNext() && !(delegate = (InvocationDelegate)iterator.next()).getField(msg.getMemberName(), target, false, isApplet, resultBox)) {
                                }
                                return resultBox[0];
                            }
                        }, this.getContext());
                        break;
                    }
                    case 3: {
                        AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                            @Override
                            public Void run() throws Exception {
                                InvocationDelegate delegate;
                                Iterator iterator = invocationDelegates.iterator();
                                while (iterator.hasNext() && !(delegate = (InvocationDelegate)iterator.next()).setField(msg.getMemberName(), target, args[0], false, isApplet)) {
                                }
                                return null;
                            }
                        }, this.getContext());
                        resultIsVoid = true;
                        break;
                    }
                    case 4: {
                        result = AccessController.doPrivileged(new PrivilegedExceptionAction<Result>(){

                            @Override
                            public Result run() throws Exception {
                                boolean[] resultBox;
                                block2: {
                                    InvocationDelegate delegate;
                                    String lowerName;
                                    resultBox = new boolean[1];
                                    boolean handled = false;
                                    if (isApplet && ((lowerName = msg.getMemberName().toLowerCase()).equals("width") || lowerName.equals("height"))) {
                                        resultBox[0] = false;
                                        handled = true;
                                    }
                                    if (handled) break block2;
                                    Iterator iterator = invocationDelegates.iterator();
                                    while (iterator.hasNext() && !(delegate = (InvocationDelegate)iterator.next()).hasField(msg.getMemberName(), target, false, isApplet, resultBox)) {
                                    }
                                }
                                return resultBox[0] ? new Result(Boolean.TRUE, false) : new Result(Boolean.FALSE, false);
                            }
                        }, this.getContext());
                        break;
                    }
                    case 5: {
                        result = AccessController.doPrivileged(new PrivilegedExceptionAction<Result>(){

                            @Override
                            public Result run() throws Exception {
                                InvocationDelegate delegate;
                                boolean[] resultBox = new boolean[1];
                                Iterator iterator = invocationDelegates.iterator();
                                while (iterator.hasNext() && !(delegate = (InvocationDelegate)iterator.next()).hasMethod(msg.getMemberName(), target, false, isApplet, resultBox)) {
                                }
                                return resultBox[0] ? new Result(Boolean.TRUE, false) : new Result(Boolean.FALSE, false);
                            }
                        }, this.getContext());
                        break;
                    }
                    case 6: {
                        result = AccessController.doPrivileged(new PrivilegedExceptionAction<Result>(){

                            @Override
                            public Result run() throws Exception {
                                InvocationDelegate delegate;
                                boolean[] resultBox = new boolean[1];
                                Iterator iterator = invocationDelegates.iterator();
                                while (iterator.hasNext() && !(delegate = (InvocationDelegate)iterator.next()).hasFieldOrMethod(msg.getMemberName(), target, false, isApplet, resultBox)) {
                                }
                                return resultBox[0] ? new Result(Boolean.TRUE, false) : new Result(Boolean.FALSE, false);
                            }
                        }, this.getContext());
                        break;
                    }
                    default: {
                        throw new RuntimeException("Internal error: unknown Java object operation " + msg.getOperationKind());
                    }
                }
                Object val = null;
                boolean skipUnboxing = false;
                if (result != null) {
                    val = result.value();
                    skipUnboxing = result.skipUnboxing();
                }
                reply = new JavaReplyMessage(msg.getConversation(), msg.getResultID(), LiveConnectSupport.exportObject(val, this.appletID, skipUnboxing, false), resultIsVoid, null);
                if (DEBUG) {
                    System.out.println("LiveConnectSupport: " + LiveConnectSupport.getOpName(msg.getOperationKind()) + " \"" + msg.getMemberName() + "\": returning result " + val);
                }
            }
            catch (Throwable e) {
                String exceptionMessage = "Throwable";
                if (e instanceof PrivilegedActionException) {
                    exceptionMessage = "PrivilegedActionException";
                }
                if (e instanceof InvocationTargetException) {
                    exceptionMessage = "InvocationTargetException";
                }
                if (DEBUG) {
                    System.out.println("Exception occurred during " + LiveConnectSupport.getOpName(msg.getOperationKind()) + " " + msg.getMemberName() + " : " + exceptionMessage);
                }
                reply = new JavaReplyMessage(msg.getConversation(), msg.getResultID(), null, false, exceptionMessage);
            }
            pipe.send(reply);
        }

        private DeploymentRuleSet getDeploymentRuleSet() {
            final Plugin2Manager mgr = this.manager;
            if (mgr != null) {
                try {
                    return AccessController.doPrivileged(new PrivilegedAction<DeploymentRuleSet>(){

                        @Override
                        public DeploymentRuleSet run() {
                            if (mainAppletDRS == null) {
                                mainAppletDRS = mgr.getMainDeploymentRuleSet();
                            }
                            if (docbaseDRS == null) {
                                AppRef appRef = new AppRef(AppRef.Type.DOCBASE, null, this.getDocumentBase(), null, (URL)null);
                                docbaseDRS = DeploymentRuleSet.findDRS((CodeInstance)new CodeInstance(appRef, new CodeRef(null, null, false, false)));
                            }
                            if (mainAppletDRS.isRuleRun()) {
                                if (docbaseDRS.isLiveConnectAllowedUnchecked()) {
                                    return docbaseDRS;
                                }
                                return new BlockRule(null, null);
                            }
                            return docbaseDRS;
                        }
                    });
                }
                catch (Exception e) {
                    Trace.ignored((Throwable)e);
                    return new BlockRule(null, e);
                }
            }
            return DeploymentRuleSet.getDefault();
        }

        private boolean isLiveconnectCallAllowed(JavaObjectOpMessage msg) {
            DeploymentRuleSet drs = this.getDeploymentRuleSet();
            if (drs.isRuleBlock()) {
                Trace.println((String)"LiveConnect (JavaScript) blocked due to Deployment Rule Set.", (TraceLevel)TraceLevel.SECURITY);
                return false;
            }
            boolean liveconnectAllowed = false;
            Plugin2Manager mgr = this.manager;
            if (mgr != null) {
                liveconnectAllowed = true;
                int kind = msg.getOperationKind();
                if (!msg.getObject().isApplet() || kind == 1 || kind == 2 || kind == 3) {
                    try {
                        mgr.checkUntrustedAccess(drs);
                    }
                    catch (SecurityException se) {
                        liveconnectAllowed = false;
                    }
                }
            }
            return liveconnectAllowed;
        }

        private AccessControlContext getContext() {
            if (this.context == null) {
                this.context = LiveConnectSupport.createContext(this.getDocumentBase());
            }
            return this.context;
        }

        private URL getDocumentBase() {
            if (!this.fetchedDocumentBase) {
                this.documentBase = this.manager.getDocumentBase();
                this.fetchedDocumentBase = true;
            }
            return this.documentBase;
        }

        private InvocationDelegate getDelegate(Object o, boolean isStatic) {
            if (isStatic) {
                return this.getJavaClass((Class)o);
            }
            return this.getJavaClass(o.getClass());
        }

        private synchronized JavaClass getJavaClass(Class<?> c) {
            JavaClass clazz = this.classes.get(c);
            if (clazz == null) {
                clazz = new JavaClass(c, this.getBridge());
                this.classes.put(c, clazz);
            }
            return clazz;
        }

        private void waitForAppletStartOrError() throws IOException {
            if (this.manager.isForDummyApplet()) {
                return;
            }
            if (this.manager.getApplet2Adapter().isInstantiated() || this.manager.hasErrorOccurred()) {
                this.manager.waitUntilAppletStartDone();
                return;
            }
            throw new IOException("LiveConnect operation without existing applet");
        }

        private static IllegalArgumentException inconvertible(Object object, Object toType) {
            return new IllegalArgumentException("Object " + object + " can not be converted to " + toType);
        }

        private static IllegalArgumentException inconvertible(Class<?> objectClass, Class<?> targetClass) {
            return PerAppletInfo.inconvertible(objectClass, targetClass, null);
        }

        private static IllegalArgumentException inconvertible(Class<?> objectClass, Class<?> targetClass, Exception cause) {
            IllegalArgumentException exc = new IllegalArgumentException("Class " + objectClass.getName() + " can not be converted to " + targetClass.getName());
            if (cause != null) {
                exc.initCause(cause);
            }
            return exc;
        }

        private class LiveConnectWorker
        implements Runnable {
            private volatile boolean shouldStop;
            private Object lock = new Object();
            private LinkedList<JavaObjectOpMessage> workQueue = new LinkedList();

            private LiveConnectWorker() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void enqueue(JavaObjectOpMessage msg) {
                Object object = this.lock;
                synchronized (object) {
                    this.workQueue.add(msg);
                    this.lock.notifyAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stop() {
                this.shouldStop = true;
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notifyAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Plugin2Manager.setCurrentManagerThreadLocal(PerAppletInfo.this.manager);
                try {
                    while (!this.shouldStop) {
                        Object object = this.lock;
                        synchronized (object) {
                            while (!this.shouldStop && this.workQueue.isEmpty()) {
                                try {
                                    this.lock.wait();
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        while (!this.shouldStop && !this.workQueue.isEmpty()) {
                            JavaObjectOpMessage msg = null;
                            Object object2 = this.lock;
                            synchronized (object2) {
                                msg = this.workQueue.removeFirst();
                            }
                            PerAppletInfo.this.doObjectOp(msg);
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        class DefaultConversionDelegate
        implements ConversionDelegate {
            private Class<?> jsObjectClass = JSObject.class;
            private static final int TOSTRING_CONVERSION_PENALTY = 50;
            private static final int JSOBJECT_CONVERSION_PENALTY = 2500;

            DefaultConversionDelegate() {
            }

            @Override
            public int conversionCost(Object arg, Object toType) {
                if (!(toType instanceof Class)) {
                    return -1;
                }
                Class<?> expectedClass = (Class<?>)toType;
                if (arg == null) {
                    if (expectedClass.isPrimitive()) {
                        return -1;
                    }
                    return 0;
                }
                Class<?> argClass = arg.getClass();
                if (argClass == expectedClass || expectedClass == this.jsObjectClass && expectedClass.isAssignableFrom(argClass)) {
                    return 0;
                }
                if (expectedClass.isAssignableFrom(argClass)) {
                    return this.conversionDistance(argClass, expectedClass);
                }
                if (this.jsObjectClass.isAssignableFrom(argClass) && this.canConvert((JSObject)arg, expectedClass)) {
                    return 2500;
                }
                if (this.jsObjectClass.isAssignableFrom(argClass) || this.jsObjectClass.isAssignableFrom(expectedClass)) {
                    return -1;
                }
                if (expectedClass == String.class) {
                    return 50;
                }
                if (expectedClass.isPrimitive()) {
                    expectedClass = this.getBoxingClass(expectedClass);
                }
                if (Number.class.isAssignableFrom(expectedClass) || expectedClass == Character.class || expectedClass == Boolean.class) {
                    if (expectedClass == argClass) {
                        return 0;
                    }
                    if (argClass == String.class || Number.class.isAssignableFrom(argClass) || argClass == Character.class || argClass == Boolean.class) {
                        return 1;
                    }
                }
                return -1;
            }

            @Override
            public boolean convert(Object obj, Object toType, Object[] result) throws Exception {
                if (obj == null) {
                    return true;
                }
                if (!(toType instanceof Class)) {
                    throw PerAppletInfo.inconvertible(obj, toType);
                }
                Class targetClass = (Class)toType;
                Class<?> objClass = obj.getClass();
                if (targetClass.isAssignableFrom(objClass)) {
                    result[0] = obj;
                    return true;
                }
                if (targetClass == String.class) {
                    if (obj instanceof Number) {
                        NumberFormat nf = NumberFormat.getNumberInstance();
                        try {
                            result[0] = nf.parse(obj.toString()).toString();
                            return true;
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                    result[0] = obj.toString();
                    return true;
                }
                if (this.jsObjectClass.isAssignableFrom(objClass) && targetClass.isArray()) {
                    try {
                        JSObject jsObj = (JSObject)obj;
                        Class<?> componentType = targetClass.getComponentType();
                        int length = ((Number)jsObj.getMember("length")).intValue();
                        Object res = Array.newInstance(componentType, length);
                        Object[] tmp = new Object[1];
                        for (int i = 0; i < length; ++i) {
                            Object element = null;
                            try {
                                element = jsObj.getSlot(i);
                            }
                            catch (JSException jSException) {
                                // empty catch block
                            }
                            if (element == null) continue;
                            this.convert(element, componentType, tmp);
                            Array.set(res, i, tmp[0]);
                        }
                        result[0] = res;
                        return true;
                    }
                    catch (Exception e) {
                        throw PerAppletInfo.inconvertible(objClass, targetClass, e);
                    }
                }
                if (this.jsObjectClass.isAssignableFrom(objClass) || this.jsObjectClass.isAssignableFrom(targetClass)) {
                    throw PerAppletInfo.inconvertible(objClass, targetClass);
                }
                if (targetClass.isPrimitive() || Number.class.isAssignableFrom(targetClass) || targetClass == Character.class || targetClass == Boolean.class) {
                    boolean isNumber = obj instanceof Number;
                    if (!(isNumber || obj instanceof String || obj instanceof Character || obj instanceof Boolean)) {
                        throw PerAppletInfo.inconvertible(objClass, targetClass);
                    }
                    if (targetClass == Boolean.TYPE || targetClass == Boolean.class) {
                        if (objClass == Boolean.class) {
                            result[0] = obj;
                            return true;
                        }
                        if (isNumber) {
                            double d = ((Number)obj).doubleValue();
                            result[0] = Double.isNaN(d) || d == 0.0 ? Boolean.FALSE : Boolean.TRUE;
                            return true;
                        }
                        result[0] = ((String)obj).length() == 0 ? Boolean.FALSE : Boolean.TRUE;
                        return true;
                    }
                    if (targetClass == Byte.TYPE || targetClass == Byte.class) {
                        if (objClass == Byte.class) {
                            result[0] = obj;
                            return true;
                        }
                        result[0] = isNumber ? Byte.valueOf(((Number)obj).byteValue()) : Byte.valueOf((String)obj);
                        return true;
                    }
                    if (targetClass == Short.TYPE || targetClass == Short.class) {
                        if (objClass == Short.class || objClass == Byte.class) {
                            result[0] = obj;
                            return true;
                        }
                        result[0] = isNumber ? Short.valueOf(((Number)obj).shortValue()) : Short.valueOf((String)obj);
                        return true;
                    }
                    if (targetClass == Integer.TYPE || targetClass == Integer.class) {
                        if (objClass == Integer.class || objClass == Character.class || objClass == Short.class || objClass == Byte.class) {
                            result[0] = obj;
                            return true;
                        }
                        result[0] = isNumber ? Integer.valueOf(((Number)obj).intValue()) : Integer.valueOf((String)obj);
                        return true;
                    }
                    if (targetClass == Long.TYPE || targetClass == Long.class) {
                        if (objClass == Long.class || objClass == Integer.class || objClass == Character.class || objClass == Short.class || objClass == Byte.class) {
                            result[0] = obj;
                            return true;
                        }
                        result[0] = isNumber ? Long.valueOf(((Number)obj).longValue()) : Long.valueOf((String)obj);
                        return true;
                    }
                    if (targetClass == Float.TYPE || targetClass == Float.class) {
                        if (objClass == Float.class || objClass == Long.class || objClass == Integer.class || objClass == Character.class || objClass == Short.class || objClass == Byte.class) {
                            result[0] = obj;
                            return true;
                        }
                        result[0] = isNumber ? Float.valueOf(((Number)obj).floatValue()) : Float.valueOf((String)obj);
                        return true;
                    }
                    if (targetClass == Double.TYPE || targetClass == Double.class) {
                        if (objClass == Double.class || objClass == Float.class || objClass == Long.class || objClass == Integer.class || objClass == Character.class || objClass == Short.class || objClass == Byte.class) {
                            result[0] = obj;
                            return true;
                        }
                        result[0] = isNumber ? Double.valueOf(((Number)obj).doubleValue()) : Double.valueOf((String)obj);
                        return true;
                    }
                    if (targetClass == Character.TYPE || targetClass == Character.class) {
                        result[0] = isNumber ? Character.valueOf((char)((Number)obj).shortValue()) : Character.valueOf((char)Short.decode((String)obj).shortValue());
                        return true;
                    }
                }
                throw PerAppletInfo.inconvertible(objClass, targetClass);
            }

            private boolean canConvert(JSObject obj, Class<?> targetClass) {
                if (targetClass == String.class) {
                    return true;
                }
                if (targetClass.isArray()) {
                    try {
                        obj.getMember("length");
                        return true;
                    }
                    catch (JSException jSException) {
                        // empty catch block
                    }
                }
                return false;
            }

            private int conversionDistance(Class<?> argumentClass, Class<?> expectedClass) {
                if (expectedClass.isInterface() || expectedClass.isArray()) {
                    return 1;
                }
                int distance = 0;
                while (argumentClass != null && argumentClass != expectedClass) {
                    ++distance;
                    argumentClass = argumentClass.getSuperclass();
                }
                if (argumentClass != expectedClass) {
                    return 1;
                }
                return distance;
            }

            private Class<?> getBoxingClass(Class<?> primitiveClass) {
                if (primitiveClass == Boolean.TYPE) {
                    return Boolean.class;
                }
                if (primitiveClass == Byte.TYPE) {
                    return Byte.class;
                }
                if (primitiveClass == Short.TYPE) {
                    return Short.class;
                }
                if (primitiveClass == Character.TYPE) {
                    return Character.class;
                }
                if (primitiveClass == Integer.TYPE) {
                    return Integer.class;
                }
                if (primitiveClass == Long.TYPE) {
                    return Long.class;
                }
                if (primitiveClass == Float.TYPE) {
                    return Float.class;
                }
                if (primitiveClass == Double.TYPE) {
                    return Double.class;
                }
                throw new IllegalArgumentException("Not a primitive type class");
            }
        }

        class DefaultInvocationDelegate
        implements InvocationDelegate {
            DefaultInvocationDelegate() {
            }

            @Override
            public boolean invoke(String methodName, Object receiver, Object[] arguments, boolean isStatic, boolean objectIsApplet, Result[] result) throws Exception {
                InvocationDelegate delegate = PerAppletInfo.this.getDelegate(receiver, isStatic);
                return delegate.invoke(methodName, isStatic ? null : receiver, arguments, false, objectIsApplet, result);
            }

            @Override
            public boolean getField(String fieldName, Object receiver, boolean isStatic, boolean objectIsApplet, Result[] result) throws Exception {
                InvocationDelegate delegate = PerAppletInfo.this.getDelegate(receiver, isStatic);
                return delegate.getField(fieldName, isStatic ? null : receiver, false, objectIsApplet, result);
            }

            @Override
            public boolean setField(String fieldName, Object receiver, Object value, boolean isStatic, boolean objectIsApplet) throws Exception {
                InvocationDelegate delegate = PerAppletInfo.this.getDelegate(receiver, isStatic);
                return delegate.setField(fieldName, isStatic ? null : receiver, value, false, objectIsApplet);
            }

            @Override
            public boolean hasField(String fieldName, Object receiver, boolean isStatic, boolean objectIsApplet, boolean[] result) {
                InvocationDelegate delegate = PerAppletInfo.this.getDelegate(receiver, isStatic);
                return delegate.hasField(fieldName, isStatic ? null : receiver, false, objectIsApplet, result);
            }

            @Override
            public boolean hasMethod(String methodName, Object receiver, boolean isStatic, boolean objectIsApplet, boolean[] result) {
                InvocationDelegate delegate = PerAppletInfo.this.getDelegate(receiver, isStatic);
                return delegate.hasMethod(methodName, isStatic ? null : receiver, false, objectIsApplet, result);
            }

            @Override
            public boolean hasFieldOrMethod(String name, Object receiver, boolean isStatic, boolean objectIsApplet, boolean[] result) {
                InvocationDelegate delegate = PerAppletInfo.this.getDelegate(receiver, isStatic);
                return delegate.hasFieldOrMethod(name, isStatic ? null : receiver, false, objectIsApplet, result);
            }

            @Override
            public Object findClass(String name) {
                try {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    return Class.forName(name, false, cl);
                }
                catch (ClassFormatError e) {
                    return null;
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
                catch (RuntimeException e) {
                    throw e;
                }
            }

            @Override
            public Object newInstance(Object clazz, Object[] arguments) throws Exception {
                JavaClass delegate = PerAppletInfo.this.getJavaClass((Class)clazz);
                return delegate.newInstance(null, arguments);
            }
        }
    }

    private static class BridgeImpl
    implements Bridge {
        private volatile PerAppletInfo info;

        private BridgeImpl(PerAppletInfo info) {
            this.info = info;
        }

        @Override
        public void register(InvocationDelegate delegate) {
            this.getInfo().register(delegate);
        }

        @Override
        public void unregister(InvocationDelegate delegate) {
            this.getInfo().unregister(delegate);
        }

        @Override
        public void register(ConversionDelegate delegate) {
            this.getInfo().register(delegate);
        }

        @Override
        public void unregister(ConversionDelegate delegate) {
            this.getInfo().unregister(delegate);
        }

        @Override
        public int conversionCost(Object object, Object toType) {
            return this.getInfo().conversionCost(object, toType);
        }

        @Override
        public Object convert(Object object, Object toType) throws Exception {
            return this.getInfo().convert(object, toType);
        }

        public void stop() {
            this.info = null;
        }

        private PerAppletInfo getInfo() {
            PerAppletInfo p = this.info;
            if (p == null) {
                throw new IllegalStateException("Applet has already terminated");
            }
            return p;
        }
    }

    private static class BrowserSideObjectReference
    extends PhantomReference<Object> {
        private final BrowserSideObject bso;
        private final int appletId;

        public BrowserSideObjectReference(Object referent, ReferenceQueue<? super Object> q, BrowserSideObject bso, int appletId) {
            super(referent, q);
            this.bso = bso;
            this.appletId = appletId;
        }

        public BrowserSideObject getObject() {
            return this.bso;
        }

        public int getAppletId() {
            return this.appletId;
        }
    }

    private static class BrowserSideObjectCleanupThread
    extends Thread {
        public BrowserSideObjectCleanupThread() {
            super("Browser Side Object Cleanup Thread");
        }

        @Override
        public void run() {
            while (!shouldStop) {
                try {
                    if (DEBUG) {
                        Trace.println((String)"Waiting to GC browser side object ...", (TraceLevel)TraceLevel.LIVECONNECT);
                    }
                    BrowserSideObjectReference obj = (BrowserSideObjectReference)queue.remove();
                    if (DEBUG) {
                        Trace.println((String)("About to GC browser side object " + obj.getObject().getNativeObjectReference()), (TraceLevel)TraceLevel.LIVECONNECT);
                    }
                    bsoRefs.remove(obj);
                    pipe.send(new JavaScriptReleaseObjectMessage(null, obj.getObject(), obj.getAppletId()));
                }
                catch (IOException e) {
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

