/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.jvm;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.JVMParameters;
import java.io.InputStream;
import sun.plugin2.applet.Plugin2Manager;
import sun.plugin2.jvm.CircularByteBuffer;
import sun.plugin2.jvm.JVMLauncher;
import sun.plugin2.message.Conversation;
import sun.plugin2.message.LaunchJVMAppletMessage;
import sun.plugin2.message.Pipe;

public class RemoteJVMLauncher
extends JVMLauncher
implements Runnable {
    static final boolean DEBUG = false;
    private static final long INTERVAL = 1000L;
    private final Pipe pipe;
    private final Conversation conversation;
    private LaunchJVMAppletMessage message;
    private boolean done;
    private CircularByteBuffer.Streamer inStreamer;
    private CircularByteBuffer.Streamer errStreamer;
    private CallBack callBack;

    public RemoteJVMLauncher(Pipe pipe, LaunchJVMAppletMessage message, JVMParameters params, Plugin2Manager manager) {
        super(message.getLaunchTime(), message.getJavaHome(), params, true);
        this.pipe = pipe;
        this.conversation = message.getConversation();
        this.message = message;
    }

    @Override
    public void start() {
        Trace.println((String)("RemoteJVMLauncher.start(), pipe=" + this.pipe.toString() + " message: " + this.message), (TraceLevel)TraceLevel.BASIC);
        this.runThread();
        String[] additionalArgs = this.message.getAdditionalArgs();
        for (int i = 0; i < additionalArgs.length; ++i) {
            this.addParameter(additionalArgs[i]);
        }
        super.start();
    }

    public void setCallBack(CallBack cb) {
        this.callBack = cb;
    }

    protected void runThread() {
        Thread t = new Thread((Runnable)this, this.toString());
        t.setDaemon(true);
        t.start();
    }

    @Override
    public void afterStart() {
        this.initInErrStreamers();
    }

    private synchronized void initInErrStreamers() {
        if (this.inStreamer != null) {
            return;
        }
        if (this.getInputStream() != null) {
            Trace.println((String)"RemoteJVMLauncher.afterStart(): initializing streamers", (TraceLevel)TraceLevel.BASIC);
            this.inStreamer = RemoteJVMLauncher.startStreamToBuffer(this.getInputStream(), "RemoteJVMLauncher-inputStream");
            this.errStreamer = RemoteJVMLauncher.startStreamToBuffer(this.getErrorStream(), "RemoteJVMLauncher-errorStream");
        }
    }

    @Override
    public void run() {
        Trace.println((String)(Thread.currentThread() + " running..."), (TraceLevel)TraceLevel.BASIC);
        if (!this.pipe.joinConversation(this.conversation)) {
            throw new RuntimeException("Failed to join LaunchJVM conversation on " + this.pipe);
        }
        try {
            this.message.setProcessStarted(true);
            boolean jvmStartedNotified = false;
            while (!this.done && !this.exited()) {
                this.initInErrStreamers();
                if (this.inStreamer != null && this.errStreamer != null) {
                    this.message.setProcessInputBytes(this.inStreamer.readAvailable());
                    this.message.setProcessErrorBytes(this.errStreamer.readAvailable());
                    if (this.callBack != null && !jvmStartedNotified) {
                        jvmStartedNotified = true;
                        this.callBack.jvmStarted();
                    }
                } else {
                    String msg = "Waiting for process spawning...";
                    this.message.setProcessInputBytes(msg.getBytes());
                    this.message.setProcessErrorBytes(null);
                }
                this.pipe.send(this.message);
                LaunchJVMAppletMessage m = (LaunchJVMAppletMessage)this.pipe.receive(1000L, this.conversation);
                if (m == null) continue;
                this.message = m;
                if (this.message == null || !this.message.isDoKill()) continue;
                this.destroy();
                this.done = true;
            }
            this.message.setProcessExitCode(0);
        }
        catch (Exception e) {
            Trace.ignored((Throwable)e);
            this.message.setProcessInputBytes(e.getMessage().getBytes());
            this.message.setProcessErrorBytes(e.getMessage().getBytes());
            this.message.setProcessExitCode(-1);
        }
        finally {
            this.message.setProcessExited(true);
            Trace.println((String)(Thread.currentThread() + " completing: done=" + this.done + " exited=" + this.exited()), (TraceLevel)TraceLevel.BASIC);
            Trace.println((String)("Sending final message " + this.message.toClientString()), (TraceLevel)TraceLevel.BASIC);
            try {
                this.pipe.send(this.message);
            }
            catch (Exception e) {
                Trace.println((String)"Exception sending final message", (TraceLevel)TraceLevel.BASIC);
                Trace.ignored((Throwable)e);
            }
        }
    }

    static CircularByteBuffer.Streamer startStreamToBuffer(InputStream in, String name) {
        CircularByteBuffer.Streamer streamer = new CircularByteBuffer.Streamer(in);
        Thread t = new Thread((Runnable)streamer, name);
        t.setDaemon(true);
        t.start();
        return streamer;
    }

    public String toString() {
        Object ext = "";
        if (this.message != null) {
            ext = (String)ext + this.message.getAppletID();
        }
        return "RemoteJVMLauncher-" + (String)ext;
    }

    public static interface CallBack {
        public void jvmStarted();
    }
}

