/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.ipc;

import com.sun.deploy.config.OSType;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import sun.plugin2.ipc.Event;
import sun.plugin2.ipc.NamedPipe;

public abstract class IPCFactory {
    public static final int KB = 1024;
    public static final int PIPE_BUF_SZ = 4096;
    private static IPCFactory instance;
    private static Constructor<?> cons;

    protected IPCFactory() {
    }

    public static IPCFactory getFactory() {
        if (instance == null) {
            try {
                String factoryClassName;
                if (OSType.isWin()) {
                    factoryClassName = "sun.plugin2.ipc.windows.WindowsIPCFactory";
                } else if (OSType.isMac() || OSType.isUnix()) {
                    factoryClassName = "sun.plugin2.ipc.unix.UnixIPCFactory";
                } else {
                    throw new RuntimeException("Unknown OS type");
                }
                cons = Class.forName(factoryClassName).getConstructor(new Class[0]);
                instance = (IPCFactory)cons.newInstance(new Object[0]);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
        return instance;
    }

    public abstract Event createEvent(Map<String, String> var1);

    public abstract NamedPipe createNamedPipe(Map<String, String> var1);

    public static String mapToString(Map<String, String> map) {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (String key : map.keySet()) {
            if (first) {
                first = false;
            } else {
                buf.append(",");
            }
            buf.append(key);
            buf.append("=");
            buf.append(map.get(key));
        }
        return buf.toString();
    }

    public static Map<String, String> stringToMap(String inputString) {
        String[] strs;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String str : strs = inputString.split(",")) {
            int firstEquals = str.indexOf("=");
            map.put(str.substring(0, firstEquals), str.substring(firstEquals + 1, str.length()));
        }
        return map;
    }
}

