/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.applet;

import com.sun.applet2.AppletParameters;
import com.sun.deploy.trace.Trace;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import sun.plugin2.applet.Plugin2Manager;

public class ManagerCache {
    private int cacheSize = Integer.getInteger("javaplugin.lifecycle.cachesize", 4);
    private List<Entry> entries = new LinkedList<Entry>();
    private final Timer memoryPressureTimer = new Timer("MemoryPressure-Watchdog", true);
    private TimerTask currentTask = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Plugin2Manager get(String documentBase, AppletParameters appletParameters) {
        if (appletParameters.get((Object)"legacy_lifecycle") == null) {
            return null;
        }
        String key = this.getCacheKey(documentBase, appletParameters);
        ManagerCache managerCache = this;
        synchronized (managerCache) {
            Iterator<Entry> iter = this.entries.iterator();
            while (iter.hasNext()) {
                Entry entry = iter.next();
                if (!entry.getKey().equals(key)) continue;
                iter.remove();
                Trace.msgPrintln((String)"lifecycle.applet.found");
                return entry.getManager();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Plugin2Manager manager) {
        String key = manager.getLegacyLifeCycleCacheKey();
        ArrayList<Entry> removedEntries = new ArrayList<Entry>();
        Entry entry = new Entry(key, manager);
        ManagerCache managerCache = this;
        synchronized (managerCache) {
            Trace.msgPrintln((String)"lifecycle.applet.support");
            this.entries.add(0, entry);
            while (this.entries.size() > this.cacheSize) {
                Entry tmp = this.entries.remove(this.entries.size() - 1);
                removedEntries.add(tmp);
            }
        }
        if (removedEntries.size() > 0) {
            Trace.msgPrintln((String)"lifecycle.applet.cachefull");
            ManagerCache.destroy(removedEntries);
        }
        this.startWatchdog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        ManagerCache managerCache = this;
        synchronized (managerCache) {
            return this.entries.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayList<Entry> removedEntries = new ArrayList<Entry>();
        ManagerCache managerCache = this;
        synchronized (managerCache) {
            removedEntries.addAll(this.entries);
            this.entries.clear();
        }
        ManagerCache.destroy(removedEntries);
        this.stopWatchdog();
    }

    public String getCacheKey(String documentBase, AppletParameters appletParameters) {
        StringBuilder key = new StringBuilder();
        if (documentBase != null) {
            key.append("<NAME=_documentBase VALUE=");
            key.append(documentBase);
            key.append(">");
        }
        for (Object k : appletParameters.keySet()) {
            String v = (String)appletParameters.get(k);
            if (k == null || v == null) continue;
            key.append("<NAME=");
            key.append(k);
            key.append(" VALUE=");
            key.append(v);
            key.append(">");
        }
        return key.toString();
    }

    private static void destroy(List<Entry> removedEntries) {
        Iterator<Entry> iter = removedEntries.iterator();
        while (iter.hasNext()) {
            iter.next().getManager().destroy();
        }
    }

    private synchronized void startWatchdog() {
        if (this.currentTask == null) {
            this.currentTask = new WatchdogTask();
            long period = ManagerCache.getTimerPeriod(ManagerCache.getMemoryPressure());
            this.memoryPressureTimer.schedule(this.currentTask, period, period);
        }
    }

    private synchronized void stopWatchdog() {
        if (this.currentTask != null) {
            this.currentTask.cancel();
            this.currentTask = null;
        }
    }

    private static float getMemoryPressure() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        if (maxMemory == Long.MAX_VALUE) {
            return 0.0f;
        }
        long totalMemory = runtime.totalMemory();
        long usedMemory = totalMemory - runtime.freeMemory();
        float pressure = (float)((double)usedMemory / (double)maxMemory);
        if (pressure < 0.0f) {
            pressure = 0.0f;
        }
        if (pressure > 1.0f) {
            pressure = 1.0f;
        }
        return pressure;
    }

    private static long getTimerPeriod(float pressure) {
        if (pressure < 0.5f) {
            return 30000L;
        }
        if (pressure < 0.75f) {
            return 15000L;
        }
        return 5000L;
    }

    class WatchdogTask
    extends TimerTask {
        private long period = ManagerCache.access$100(ManagerCache.access$000());

        WatchdogTask() {
        }

        @Override
        public void run() {
            float pressure = ManagerCache.getMemoryPressure();
            if (pressure > 0.9f) {
                ManagerCache.this.clear();
            }
            if (ManagerCache.getTimerPeriod(ManagerCache.getMemoryPressure()) != this.period) {
                ManagerCache.this.stopWatchdog();
                ManagerCache.this.startWatchdog();
            }
        }
    }

    class Entry {
        private String key;
        private Plugin2Manager manager;

        Entry(String key, Plugin2Manager manager) {
            this.key = key;
            this.manager = manager;
        }

        public String getKey() {
            return this.key;
        }

        public Plugin2Manager getManager() {
            return this.manager;
        }
    }
}

