/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.applet;

import com.sun.deploy.appcontext.AppContext;
import com.sun.deploy.config.Config;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.impl.awt.AWTAppContext;
import java.net.URLPermission;
import java.security.Permission;
import java.util.HashSet;
import sun.awt.AWTSecurityManager;
import sun.plugin2.applet.SecurityManagerHelper;
import sun.plugin2.uitoolkit.impl.awt.AWTDragHelper;

public class AWTAppletSecurityManager
extends AWTSecurityManager {
    private final AppContext mainAppContext;
    private final SecurityManager awtSM = new AWTSecurityManager();
    private final HashSet<String> restrictedPackages = new HashSet();

    public AWTAppletSecurityManager() {
        SecurityManagerHelper.resetHelper(this.restrictedPackages);
        this.mainAppContext = ToolkitStore.get().getAppContext();
    }

    public void checkConnect(String host, int port) {
        SecurityManagerHelper.checkConnectHelper(this.awtSM, host, port, null, false, this.getClassContext());
    }

    public void checkConnect(String host, int port, Object context) {
        SecurityManagerHelper.checkConnectHelper(this.awtSM, host, port, context, true, this.getClassContext());
    }

    public void checkPermission(Permission perm) {
        if (Config.isJavaVersionAtLeast18() && perm instanceof URLPermission) {
            SecurityManagerHelper.checkURLPermissionHelper(this.awtSM, perm, null, false, this.getClassContext());
            return;
        }
        super.checkPermission(perm);
        SecurityManagerHelper.checkPermissionHelper(perm);
    }

    public void checkPermission(Permission perm, Object context) {
        if (Config.isJavaVersionAtLeast18() && perm instanceof URLPermission) {
            SecurityManagerHelper.checkURLPermissionHelper(this.awtSM, perm, context, true, this.getClassContext());
            return;
        }
        super.checkPermission(perm, context);
    }

    public void checkAccess(Thread t) {
        SecurityManagerHelper.checkAccessHelper(t, this.awtSM, this.getCurrentClassLoader(), this.getClassContext());
    }

    public void checkAccess(ThreadGroup g) {
        SecurityManagerHelper.checkAccessHelper(g, this.awtSM, this.getCurrentClassLoader(), this.getClassContext());
    }

    public void checkPackageAccess(String pkgname) {
        SecurityManagerHelper.checkPackageAccessHelper(this.awtSM, pkgname, this.restrictedPackages);
    }

    public void checkPrintJobAccess() {
        SecurityManagerHelper.checkPrintJobAccessHelper(this.awtSM);
    }

    public void checkSecurityAccess(String action) {
        SecurityManagerHelper.checkSecurityAccessHelper(this.awtSM, action);
    }

    public sun.awt.AppContext getAppContext() {
        AppContext ac = SecurityManagerHelper.getAppContextHelper(this.getCurrentClassLoader(), this.getClassContext());
        if (ac instanceof AWTAppContext) {
            return ((AWTAppContext)ac).getAWTAppContext();
        }
        return null;
    }

    public ThreadGroup getThreadGroup() {
        return SecurityManagerHelper.getThreadGroupHelper(this.awtSM, this.getCurrentClassLoader(), this.getClassContext());
    }

    public boolean checkTopLevelWindow(Object window) {
        if (window == null) {
            throw new NullPointerException("window can't be null");
        }
        if (window instanceof AWTDragHelper.DraggedAppletJFrame || window instanceof AWTDragHelper.DraggedAppletFrame) {
            return false;
        }
        return super.checkTopLevelWindow(window);
    }

    private ClassLoader getCurrentClassLoader() {
        ClassLoader loader = this.currentClassLoader();
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        return loader;
    }
}

