/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.ui;

import com.sun.deploy.uitoolkit.ui.ConsoleController;
import com.sun.deploy.uitoolkit.ui.ConsoleHelper;
import com.sun.deploy.uitoolkit.ui.ConsoleWindow;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LoggerConsole
implements ConsoleWindow {
    private static final Logger LOGGER = Logger.getLogger("DeployConsole");
    private final ConsoleController controller;
    private volatile boolean visible = true;

    public static LoggerConsole create(ConsoleController consoleController) {
        return new LoggerConsole(consoleController);
    }

    public LoggerConsole(ConsoleController consoleController) {
        this.controller = consoleController;
    }

    @Override
    public void clear() {
        LOGGER.log(Level.INFO, "CLEAR");
        ConsoleHelper.displayVersion(this.controller, this);
        this.append("\n");
        ConsoleHelper.displayHelp(this.controller, this);
    }

    @Override
    public void append(String string) {
        LOGGER.log(Level.FINE, string);
    }

    @Override
    public void setVisible(boolean bl) {
        LOGGER.log(Level.INFO, bl ? "Visible" : "Invisible");
        this.visible = bl;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void dispose() {
        LOGGER.log(Level.INFO, "Disposed");
    }

    @Override
    public void setTitle(String string) {
        LOGGER.log(Level.CONFIG, "Console Title : {0}", string);
    }

    @Override
    public String getRecentLog() {
        return "";
    }
}

