/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security.ruleset;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.ref.AppRef;
import com.sun.deploy.ref.CodeInstance;
import com.sun.deploy.ref.CodeRef;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BlockedException;
import com.sun.deploy.security.TrustDecider;
import com.sun.deploy.security.ValidationState;
import com.sun.deploy.security.ruleset.BlockRule;
import com.sun.deploy.security.ruleset.DRSHelper;
import com.sun.deploy.security.ruleset.DefaultRule;
import com.sun.deploy.security.ruleset.ExceptionRule;
import com.sun.deploy.security.ruleset.Rule;
import com.sun.deploy.security.ruleset.RuleAction;
import com.sun.deploy.security.ruleset.RuleId;
import com.sun.deploy.security.ruleset.RuleParseException;
import com.sun.deploy.security.ruleset.RunRule;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.JarUtil;
import com.sun.deploy.util.SessionProperties;
import com.sun.deploy.util.SessionState;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public abstract class DeploymentRuleSet {
    public static final String XML_FILENAME = "ruleset.xml";
    private static DRSHelper drsHelper;
    private static DeploymentRuleSet defaultRule;
    private static DeploymentRuleSet exceptionRule;
    private static boolean isInitialized;
    private static Exception initializationException;
    protected static final String FILENAME = "drs.properties";
    private static SessionProperties sessionProps;
    private static HashMap<CodeInstance, DeploymentRuleSet> drsMap;

    public abstract boolean isCaSignedNever();

    public abstract boolean isSelfSignedNever();

    public abstract boolean isSSVModeNever();

    public abstract boolean isRunLocalAppletsNever();

    public abstract boolean isRunUntrustedNever();

    public abstract boolean isRunUntrustedMultiClick();

    public abstract boolean isSSVModeMultiClick();

    public abstract boolean isRevocationCheckBestEffort();

    public abstract boolean isExpiredBlocked();

    public abstract boolean isPermissionsManifestRequired();

    public abstract boolean isAskGrantShowSet();

    public abstract boolean isAskGrantSelfSignedSet();

    public abstract boolean isRuleRun();

    public abstract boolean isRuleBlock();

    public abstract String getVersionString();

    public abstract boolean isVersionForced();

    public abstract String getMessage();

    public abstract Exception getException();

    public abstract boolean isLiveConnectAllowedUnchecked();

    public abstract boolean allowInsecureProperties();

    public abstract boolean allowNativeSandbox();

    public abstract boolean isUnrelatedVmSharingAllowed();

    public abstract String getCustomerString();

    public static DeploymentRuleSet getDefault() {
        if (defaultRule == null) {
            defaultRule = new DefaultRule(null, null);
        }
        return defaultRule;
    }

    public static DeploymentRuleSet getDefault(String string, String string2) {
        if (string == null && string2 == null) {
            return DeploymentRuleSet.getDefault();
        }
        return new DefaultRule(string, string2);
    }

    private static DeploymentRuleSet getExceptionRule() {
        if (exceptionRule == null) {
            exceptionRule = new ExceptionRule(null, null);
        }
        return exceptionRule;
    }

    public static DeploymentRuleSet getExceptionRule(String string, String string2) {
        if (string == null && string2 == null) {
            return DeploymentRuleSet.getExceptionRule();
        }
        return new ExceptionRule(string, string2);
    }

    private static DeploymentRuleSet getDefaultOrException(AppRef appRef, CodeRef codeRef, String string, String string2) {
        try {
            if (RuleId.isException(appRef, codeRef) || Environment.isGlobalException()) {
                Trace.println("Exception List entry exists for: " + String.valueOf(appRef.getLocation()) + "\nno DRS rule applies, returning Exception Rule", TraceLevel.RULESET);
                return DeploymentRuleSet.getExceptionRule(string, string2);
            }
            DeploymentRuleSet deploymentRuleSet = DeploymentRuleSet.getDefault(string, string2);
            Trace.println("no exception applies, returning Rule: " + deploymentRuleSet, TraceLevel.RULESET);
            return deploymentRuleSet;
        }
        catch (BlockedException blockedException) {
            return new BlockRule(blockedException.getMessage(), blockedException, true, string2);
        }
    }

    public static DeploymentRuleSet findDRS(CodeInstance codeInstance) {
        DeploymentRuleSet deploymentRuleSet = drsMap.get(codeInstance);
        if (deploymentRuleSet == null) {
            deploymentRuleSet = DeploymentRuleSet.getDRS(codeInstance);
            drsMap.put(codeInstance, deploymentRuleSet);
        }
        return deploymentRuleSet;
    }

    private static DeploymentRuleSet getDRS(CodeInstance codeInstance) {
        Rule rule;
        AppRef appRef = codeInstance.getAppRef();
        CodeRef codeRef = codeInstance.getCodeRef();
        Trace.println("finding Deployment Rule Set for appRef=" + appRef + ", codeRef = " + codeRef, TraceLevel.RULESET);
        DeploymentRuleSet.initialize();
        if (initializationException != null) {
            Trace.println("Exception parsing deployment rule set " + initializationException, TraceLevel.RULESET);
            Trace.ignored(initializationException);
            String string = ResourceManager.getString("deployment.blocked.ruleset.exception");
            if (initializationException instanceof BlockedException) {
                string = initializationException.getMessage();
            }
            return new BlockRule(string, initializationException, false, null);
        }
        String string = null;
        String string2 = null;
        if (drsHelper != null && (rule = drsHelper.findRule(appRef, codeRef)) != null) {
            Trace.println("found matching id, using rule: " + rule, TraceLevel.RULESET);
            RuleAction ruleAction = rule.getAction();
            if (ruleAction.isRun()) {
                RuleId ruleId = rule.getId();
                return new RunRule(ruleAction.getVersionString(), ruleAction.isVersionForced(), ruleAction.getBlockedMessage(), ruleId.getCertHash(), ruleId.getCertAlgorithm(), ruleId.getLocation(), rule.getCustomerString());
            }
            if (ruleAction.isBlock()) {
                return new BlockRule(ruleAction.getBlockedMessage(), null, false, rule.getCustomerString());
            }
            if (ruleAction.isDefault()) {
                string = ruleAction.getBlockedMessage();
                string2 = rule.getCustomerString();
            }
        }
        return DeploymentRuleSet.getDefaultOrException(appRef, codeRef, string, string2);
    }

    public static synchronized void initialize() {
        if (!isInitialized) {
            drsHelper = null;
            final File file = Config.getDRSFile();
            if (file != null && file.exists()) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            DeploymentRuleSet.validateDRS(file);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    initializationException = privilegedActionException.getException();
                }
                catch (Exception exception) {
                    initializationException = exception;
                }
            }
            isInitialized = true;
        }
    }

    public static boolean isRuleSetFileExists() {
        File file = Config.getDRSFile();
        return file != null && file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateDRS(File file) throws IOException {
        block5: {
            DeploymentRuleSet.verifyRuleSetFile(file);
            JarFile jarFile = null;
            try {
                jarFile = JarUtil.createJarFile(file, false);
                JarEntry jarEntry = jarFile.getJarEntry(XML_FILENAME);
                if (jarEntry != null) {
                    drsHelper = new DRSHelper(jarFile.getInputStream(jarEntry));
                    break block5;
                }
                String string = "DeploymentRuleSet.jar is missing ruleset.xml file.";
                throw new RuleParseException(string, null, RuleParseException.REASON_EXCEPTION, 0);
            }
            finally {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
        }
    }

    public static boolean installRuleSetFile(File file) {
        File file2 = Config.getDRSFile();
        try {
            Cache.copyFile(file, file2);
            return true;
        }
        catch (Throwable throwable) {
            Trace.println("could not copy Deployment Rule Set file from " + file + " to " + file2, TraceLevel.RULESET);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyRuleSetFile(File file) {
        String string = null;
        Exception exception = null;
        if (file.toString().equals(sessionProps.getProperty("drs.verified"))) {
            Trace.println("The file: " + file + " was verified before relaunch.", TraceLevel.RULESET);
            return;
        }
        JarFile jarFile = null;
        try {
            Object object;
            CodeSigner[] codeSignerArray;
            jarFile = JarUtil.createJarFile(file, true);
            JarEntry jarEntry = jarFile.getJarEntry(XML_FILENAME);
            if (jarEntry == null) {
                String string2 = ResourceManager.getString("deployment.invalid.ruleset");
                throw new BlockedException(string2, null);
            }
            try {
                codeSignerArray = jarFile.getInputStream(jarEntry);
                object = new byte[1024];
                int n = ((byte[])object).length;
                while (n != -1) {
                    n = codeSignerArray.read((byte[])object, 0, ((byte[])object).length);
                }
                codeSignerArray.close();
            }
            catch (IOException iOException) {
                Trace.ignored(iOException);
            }
            codeSignerArray = jarEntry.getCodeSigners();
            if (codeSignerArray == null || codeSignerArray.length == 0) {
                Trace.println("Failed to validate jar \"" + file.getAbsolutePath() + "\", the jar may be signed with a weak algorithm that is now disabled, for example MD2 or MD5. Please turn on \"-Djava.security.debug=jar\" to get more detailed trace or go to http://java.com/jcpsecurity to find more information.", TraceLevel.SECURITY);
            }
            object = file.toURI().toURL();
            CodeSource codeSource = new CodeSource((URL)object, codeSignerArray);
            boolean bl = false;
            ValidationState validationState = TrustDecider.getJarValidationState(codeSource, null, null);
            if (validationState.trustDecision == 0L) {
                string = "deployment.cannot.validate";
            } else if (!validationState.rootCAValid) {
                string = "deployment.cannot.validate.selfsigned";
            } else if (validationState.certValidity != 0 || !validationState.timeValid) {
                string = "deployment.cannot.validate.expired";
                exception = validationState.certExpiredException != null ? validationState.certExpiredException : validationState.certNotYetValidException;
            }
        }
        catch (IOException iOException) {
            string = "deployment.cannot.validate.exception";
            exception = iOException;
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (string != null) {
            throw new BlockedException(ResourceManager.getString(string), exception);
        }
        Trace.println("verification succeeded for signed Deployment Rule Set file " + file, TraceLevel.RULESET);
        sessionProps.setProperty("drs.verified", file.toString());
    }

    public String toString() {
        return "DeploymentRuleSet: generic";
    }

    public boolean skipThisCertArray(X509Certificate[] x509CertificateArray) {
        return false;
    }

    public boolean skipMetaInfDirectory() {
        return false;
    }

    static {
        defaultRule = null;
        exceptionRule = null;
        isInitialized = false;
        initializationException = null;
        sessionProps = new SessionProperties(FILENAME);
        SessionState.register(sessionProps);
        drsMap = new HashMap();
    }
}

