/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ui;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.ui.JavaTrayIcon;
import com.sun.deploy.ui.JavaTrayIconController;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.SafeThreadFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;

class WindowsJavaTrayIcon
extends JavaTrayIcon {
    private static final int IDM_SHOW_CONSOLE = 3001;
    private static final int IDM_HIDE_CONSOLE = 3002;
    private static final int IDM_ABOUT_PLUGIN = 3003;
    private static final int IDM_EXIT = 3004;
    private static final int IDI_JAVACONSOLE = 3005;
    private static final int IDM_DISABLE = 3006;
    private static final int IDM_SHOW_CONTROLPANEL = 3007;
    private static final int IDM_GOTO_JAVA = 3008;
    private static final int MF_STRING = 0;
    private static final int MF_SEPARATOR = 2048;
    private static final int NIM_ADD = 0;
    private static final int NIM_MODIFY = 1;
    private static final int NIM_DELETE = 2;
    private static final int NIF_MESSAGE = 1;
    private static final int NIF_ICON = 2;
    private static final int NIF_TIP = 4;
    private static final int NIF_INFO = 16;
    private static final int NIN_BALLOONUSERCLICK = 1029;
    private static final int SW_HIDE = 0;
    private static final int WM_DESTROY = 2;
    private static final int WM_COMMAND = 273;
    private static final int WM_LBUTTONDBLCLK = 515;
    private static final int WM_RBUTTONUP = 517;
    private static final String JAVA_VERSION;
    private static final String JAVA_HOME_LINK = "http://www.java.com";
    private static final String REG_USER_JRE_PATH;
    private static final String REG_USER_FIRSTRUN_KEY = "BalloonShown";
    private long hWnd;
    private long hIcon;
    private long hMenu;
    private boolean deletedIcon;

    WindowsJavaTrayIcon(JavaTrayIconController javaTrayIconController) {
        super(javaTrayIconController);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void installImpl() {
        Object object;
        Object object2 = object = new Object();
        synchronized (object2) {
            SafeThreadFactory.createThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String string = "JavaConsole " + JAVA_VERSION + " " + WindowsJavaTrayIcon.getCurrentProcessId();
                    if (WindowsJavaTrayIcon.registerClass(string)) {
                        WindowsJavaTrayIcon.this.hWnd = WindowsJavaTrayIcon.createWindow(string);
                    }
                    if (WindowsJavaTrayIcon.this.hWnd != 0L) {
                        WindowsJavaTrayIcon.showWindow(WindowsJavaTrayIcon.this.hWnd, 0);
                        WindowsJavaTrayIcon.this.setUserData(WindowsJavaTrayIcon.this.hWnd);
                    }
                    Object object2 = object;
                    synchronized (object2) {
                        object.notifyAll();
                    }
                    WindowsJavaTrayIcon.mainLoop();
                }
            }, "Windows Tray Icon Thread").start();
            try {
                object.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.initIcon();
        this.createMenu();
        if (!WindowsJavaTrayIcon.hasBalloonTooltipShown()) {
            WindowsJavaTrayIcon.setBalloonTooltipShown(true);
            this.showBalloonTooltip();
        }
        Runtime.getRuntime().addShutdownHook(SafeThreadFactory.createThread(new Runnable(){

            @Override
            public void run() {
                WindowsJavaTrayIcon.this.deleteIcon();
            }
        }));
    }

    @Override
    protected void notifyConsoleClosedImpl() {
        this.changeMenuToOpenConsole();
    }

    private void initIcon() {
        this.hIcon = WindowsJavaTrayIcon.loadTrayIcon();
        this.addIcon();
    }

    private void createMenu() {
        this.hMenu = WindowsJavaTrayIcon.createPopupMenu();
        WindowsJavaTrayIcon.appendMenu(this.hMenu, 0, 3003L, ResourceManager.getString("systray.about.java"));
        WindowsJavaTrayIcon.appendMenu(this.hMenu, 0, 3008L, ResourceManager.getString("systray.goto.java"));
        WindowsJavaTrayIcon.appendMenu(this.hMenu, 2048, 0L, null);
        WindowsJavaTrayIcon.appendMenu(this.hMenu, 0, 3007L, ResourceManager.getString("systray.open.controlpanel"));
        if (Config.getStringProperty("deployment.console.startup.mode").equalsIgnoreCase("SHOW")) {
            WindowsJavaTrayIcon.appendMenu(this.hMenu, 0, 3002L, ResourceManager.getString("systray.hide.console", JAVA_VERSION));
        } else {
            WindowsJavaTrayIcon.appendMenu(this.hMenu, 0, 3001L, ResourceManager.getString("systray.open.console", JAVA_VERSION));
        }
        WindowsJavaTrayIcon.appendMenu(this.hMenu, 2048, 0L, null);
        WindowsJavaTrayIcon.appendMenu(this.hMenu, 0, 3006L, ResourceManager.getString("systray.disable"));
        WindowsJavaTrayIcon.setMenuDefaultItem(this.hMenu, 0, true);
    }

    private long wndProc(long l, int n, long l2, long l3) {
        block0 : switch (n) {
            case 3005: {
                int n2 = (int)l3;
                switch (n2) {
                    case 517: {
                        WindowsJavaTrayIcon.showPopupMenu(l, this.hMenu);
                        return 0L;
                    }
                    case 515: {
                        ToolkitStore.getUI().showAboutJavaDialog();
                        return 0L;
                    }
                    case 1029: {
                        if (!WindowsJavaTrayIcon.isBalloonClickInBounds()) break block0;
                        Platform.get().showDocument(JAVA_HOME_LINK);
                        break block0;
                    }
                }
                break;
            }
            case 273: {
                switch (this.LOWORD(l2)) {
                    case 3001: {
                        this.controller.showJavaConsole(true);
                        WindowsJavaTrayIcon.modifyMenu(this.hMenu, 3001, 3002L, ResourceManager.getString("systray.hide.console", JAVA_VERSION));
                        return 0L;
                    }
                    case 3008: {
                        Platform.get().showDocument(JAVA_HOME_LINK);
                        return 0L;
                    }
                    case 3002: {
                        this.controller.showJavaConsole(false);
                        this.changeMenuToOpenConsole();
                        return 0L;
                    }
                    case 3003: {
                        ToolkitStore.getUI().showAboutJavaDialog();
                        return 0L;
                    }
                    case 3006: {
                        this.deleteIcon();
                        return 0L;
                    }
                    case 3007: {
                        Platform.get().openControlPanel(null);
                        return 0L;
                    }
                }
                break;
            }
            case 2: {
                WindowsJavaTrayIcon.postQuitMessage(0);
                return 0L;
            }
        }
        return WindowsJavaTrayIcon.defWindowProc(l, n, l2, l3);
    }

    private void changeMenuToOpenConsole() {
        WindowsJavaTrayIcon.modifyMenu(this.hMenu, 3002, 3001L, ResourceManager.getString("systray.open.console", JAVA_VERSION));
    }

    private void addIcon() {
        WindowsJavaTrayIcon.notifyShell(0L, this.hWnd, 0, 7, 3005, this.hIcon, ResourceManager.getString("systray.tooltip"), null, null, 0);
    }

    private void showBalloonTooltip() {
        WindowsJavaTrayIcon.notifyShell(1L, this.hWnd, 0, 23, 3005, this.hIcon, ResourceManager.getString("systray.tooltip"), ResourceManager.getString("systray.balloon.title"), ResourceManager.getString("systray.balloon.tooltip"), 15000);
    }

    private synchronized void deleteIcon() {
        if (!this.deletedIcon) {
            this.deletedIcon = true;
            WindowsJavaTrayIcon.notifyShell(2L, this.hWnd, 0, 3, 3005, this.hIcon, null, null, null, 0);
            WindowsJavaTrayIcon.destroyIcon(this.hIcon);
            this.hIcon = 0L;
        }
    }

    private static boolean hasBalloonTooltipShown() {
        return WindowsJavaTrayIcon.hasBalloonTooltipShown0(REG_USER_JRE_PATH, REG_USER_FIRSTRUN_KEY);
    }

    private static void setBalloonTooltipShown(boolean bl) {
        WindowsJavaTrayIcon.setBalloonTooltipShown0(REG_USER_JRE_PATH, REG_USER_FIRSTRUN_KEY, bl);
    }

    private static native long getCurrentProcessId();

    private static native boolean registerClass(String var0);

    private static native long createWindow(String var0);

    private static native void showWindow(long var0, int var2);

    private native void setUserData(long var1);

    private static native void mainLoop();

    private static native boolean hasBalloonTooltipShown0(String var0, String var1);

    private static native void setBalloonTooltipShown0(String var0, String var1, boolean var2);

    private static native long createNativeIcon(int[] var0, byte[] var1, int var2, int var3, int var4);

    private static native long loadTrayIcon();

    private static native void destroyIcon(long var0);

    private static native long createPopupMenu();

    private static native void appendMenu(long var0, int var2, long var3, String var5);

    private static native void modifyMenu(long var0, int var2, long var3, String var5);

    private static native boolean setMenuDefaultItem(long var0, int var2, boolean var3);

    private static native void showPopupMenu(long var0, long var2);

    private static native boolean isBalloonClickInBounds();

    private short LOWORD(long l) {
        return (short)(l & 0xFFFFL);
    }

    private static native void notifyShell(long var0, long var2, int var4, int var5, int var6, long var7, String var9, String var10, String var11, int var12);

    private static native void postQuitMessage(int var0);

    private static native long defWindowProc(long var0, int var2, long var3, long var5);

    static {
        Platform.get();
        JAVA_VERSION = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.version");
            }
        });
        REG_USER_JRE_PATH = "SOFTWARE\\JavaSoft\\JRE\\" + JAVA_VERSION;
    }
}

