/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.trace;

import com.sun.deploy.Environment;
import com.sun.deploy.config.BuiltInProperties;
import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.trace.TraceListener;
import com.sun.deploy.trace.TraceMessage;
import com.sun.deploy.trace.TraceStream;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.awt.Component;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class Trace {
    private static boolean automation = false;
    private static final List<TraceMessage> queue = new ArrayList<TraceMessage>();
    private static final Set<TraceListener> traceListeners = new HashSet<TraceListener>();
    private static final Set<TraceLevel> enabledTraceLevels = Collections.synchronizedSet(new HashSet());
    private static final TeeStream traceStdout = new TeeStream(new TraceStream());
    private static final TeeStream traceStderr = new TeeStream(new TraceStream());
    private static PrintStream realStdout = null;
    private static PrintStream realStderr = null;
    private static final TraceMsgQueueChecker queueChecker = new TraceMsgQueueChecker();

    private Trace() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensureMessageQueueProcessingStarted() {
        TraceMsgQueueChecker traceMsgQueueChecker = queueChecker;
        synchronized (traceMsgQueueChecker) {
            queueChecker.notifyAll();
        }
    }

    public static synchronized void redirectStdioStderr() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (null == realStdout && realStdout != traceStdout) {
                    realStdout = System.out;
                }
                if (null == realStderr && realStderr != traceStderr) {
                    realStderr = System.err;
                }
                if (!Config.getBooleanProperty("deployment.trace.redirect.stdio")) {
                    traceStdout.setTee(realStdout);
                    traceStderr.setTee(realStderr);
                }
                System.setOut(traceStdout);
                System.setErr(traceStderr);
                return null;
            }
        });
    }

    public static synchronized void restoreStdioStdErr() {
        if (null != realStdout && System.out == traceStdout) {
            System.setOut(realStdout);
        }
        if (null != realStderr && System.err == traceStderr) {
            System.setErr(realStderr);
        }
        realStdout = null;
        realStderr = null;
    }

    public static synchronized PrintStream getRealStdout() {
        if (null != realStdout && System.out == traceStdout) {
            return realStdout;
        }
        return System.out;
    }

    public static synchronized PrintStream getRealStderr() {
        if (null != realStderr && System.err == traceStderr) {
            return realStderr;
        }
        return System.err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flush() {
        while (true) {
            List<TraceMessage> list = queue;
            synchronized (list) {
                if (queue.isEmpty()) {
                    break;
                }
                queue.notifyAll();
                try {
                    queue.wait(200L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }
        Trace.fireFlushEvent();
    }

    public static boolean isEnabled() {
        return enabledTraceLevels.size() > 1;
    }

    public static void setInitialTraceLevel() {
        Trace.setInitialTraceLevel(false);
    }

    public static void setInitialTraceLevel(boolean bl) {
        String string = Config.getStringProperty("deployment.trace.level");
        if (bl && string != null) {
            string = string.startsWith("tck-") ? string.replaceAll("tck-", "") : null;
        }
        Trace.setInitialTraceLevel(string);
    }

    public static void setInitialTraceLevel(String string) {
        if (string != null && !string.equals("")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equalsIgnoreCase("all")) {
                    Trace.setEnabled(TraceLevel.BASIC, true);
                    Trace.setEnabled(TraceLevel.CACHE, true);
                    Trace.setEnabled(TraceLevel.NETWORK, true);
                    Trace.setEnabled(TraceLevel.TEMP, true);
                    Trace.setEnabled(TraceLevel.SECURITY, true);
                    Trace.setEnabled(TraceLevel.LIVECONNECT, true);
                    Trace.setEnabled(TraceLevel.UI, true);
                    Trace.setEnabled(TraceLevel.PRELOADER, true);
                    Trace.setEnabled(TraceLevel.RULESET, true);
                    break;
                }
                if (string2.equalsIgnoreCase("basic")) {
                    Trace.setEnabled(TraceLevel.BASIC, true);
                    continue;
                }
                if (string2.equalsIgnoreCase("cache")) {
                    Trace.setEnabled(TraceLevel.CACHE, true);
                    continue;
                }
                if (string2.equalsIgnoreCase("net")) {
                    Trace.setEnabled(TraceLevel.NETWORK, true);
                    continue;
                }
                if (string2.equalsIgnoreCase("temp")) {
                    Trace.setEnabled(TraceLevel.TEMP, true);
                    continue;
                }
                if (string2.equalsIgnoreCase("security")) {
                    Trace.setEnabled(TraceLevel.SECURITY, true);
                    continue;
                }
                if (string2.equalsIgnoreCase("liveconnect")) {
                    Trace.setEnabled(TraceLevel.LIVECONNECT, true);
                    continue;
                }
                if (string2.equalsIgnoreCase("ui")) {
                    Trace.setEnabled(TraceLevel.UI, true);
                    continue;
                }
                if (string2.equalsIgnoreCase("preloader")) {
                    Trace.setEnabled(TraceLevel.PRELOADER, true);
                    continue;
                }
                if (!string2.equalsIgnoreCase("ruleset")) continue;
                Trace.setEnabled(TraceLevel.RULESET, true);
            }
        }
    }

    public static boolean isEnabled(TraceLevel traceLevel) {
        return enabledTraceLevels.contains(traceLevel);
    }

    public static void setEnabled(TraceLevel traceLevel, boolean bl) {
        if (bl) {
            enabledTraceLevels.add(traceLevel);
        } else {
            enabledTraceLevels.remove(traceLevel);
        }
    }

    public static boolean isAutomationEnabled() {
        return automation;
    }

    public static void enableAutomation(boolean bl) {
        automation = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enQueue(TraceMessage traceMessage) {
        List<TraceMessage> list = queue;
        synchronized (list) {
            queue.add(traceMessage);
            queue.notifyAll();
        }
    }

    public static void print(String string, TraceLevel traceLevel) {
        if (enabledTraceLevels.contains(traceLevel)) {
            TraceMessage traceMessage = new TraceMessage(traceLevel, string);
            Trace.enQueue(traceMessage);
        }
    }

    public static void println(String string, TraceLevel traceLevel) {
        if (enabledTraceLevels.contains(traceLevel)) {
            TraceMessage traceMessage = new TraceMessage(traceLevel, string, true);
            Trace.enQueue(traceMessage);
        }
    }

    public static void println(String string) {
        Trace.println(string, TraceLevel.DEFAULT);
    }

    public static void print(String string) {
        Trace.print(string, TraceLevel.DEFAULT);
    }

    public static void msgPrintln(String string, Object[] objectArray, TraceLevel traceLevel) {
        if (enabledTraceLevels.contains(traceLevel)) {
            TraceMessage traceMessage = new TraceMessage(traceLevel, ResourceManager.getString(string, objectArray), true);
            Trace.enQueue(traceMessage);
        }
    }

    public static void msgPrintln(String string, Object[] objectArray) {
        Trace.msgPrintln(string, objectArray, TraceLevel.DEFAULT);
    }

    public static void msgPrintln(String string) {
        Trace.msgPrintln(string, null, TraceLevel.BASIC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTraceListener(TraceListener traceListener) {
        Set<TraceListener> set = traceListeners;
        synchronized (set) {
            traceListeners.add(traceListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTraceListener(TraceListener traceListener) {
        Set<TraceListener> set = traceListeners;
        synchronized (set) {
            traceListeners.remove(traceListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearTraceListeners() {
        Set<TraceListener> set = traceListeners;
        synchronized (set) {
            traceListeners.clear();
        }
    }

    public static void resetTraceLevel() {
        enabledTraceLevels.clear();
        enabledTraceLevels.add(TraceLevel.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void firePrintlnEvent(TraceMessage traceMessage) {
        TraceListener[] traceListenerArray = traceListeners;
        synchronized (traceListeners) {
            TraceListener[] traceListenerArray2 = traceListeners.toArray(new TraceListener[traceListeners.size()]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (TraceListener traceListener : traceListenerArray2) {
                try {
                    traceListener.print(traceMessage.getMessage());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireFlushEvent() {
        TraceListener[] traceListenerArray = traceListeners;
        synchronized (traceListeners) {
            TraceListener[] traceListenerArray2 = traceListeners.toArray(new TraceListener[traceListeners.size()]);
            // ** MonitorExit[var1] (shouldn't be in output)
            for (TraceListener traceListener : traceListenerArray2) {
                try {
                    traceListener.flush();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return;
        }
    }

    public static void ignoredException(Exception exception) {
        Trace.ignored(exception);
    }

    public static void ignored(Throwable throwable) {
        if (enabledTraceLevels.size() > 1) {
            throwable.printStackTrace();
        }
    }

    public static void ignored(Throwable throwable, boolean bl) {
        Throwable throwable2 = throwable;
        if (bl && throwable.getCause() != null) {
            throwable2 = throwable.getCause();
        }
        Trace.ignored(throwable2);
    }

    public static void printException(Throwable throwable) {
        Trace.printException(null, throwable);
    }

    public static void printException(Component component, Throwable throwable) {
        Trace.printException(component, throwable, null, null);
    }

    public static void printException(Throwable throwable, String string, String string2) {
        Trace.printException(null, throwable, string, string2);
    }

    public static void printException(Component component, Throwable throwable, String string, String string2) {
        Trace.printException(component, throwable, string, string2, true);
    }

    public static void printException(Component component, Throwable throwable, String string, String string2, boolean bl) {
        Trace.printException(component, throwable, null, string, string2, bl);
    }

    public static void printException(Component component, Throwable throwable, AppInfo appInfo, String string, String string2, boolean bl) {
        Trace.println("Ignored exception: " + throwable);
        if (bl && !Trace.isAutomationEnabled()) {
            if (string == null) {
                string = ResourceManager.getString("dialogfactory.general_error");
            }
            ToolkitStore.getUI().showExceptionDialog(component, appInfo, throwable, string2, string, null, null);
        }
    }

    public static void netPrintln(String string) {
        Trace.println(string, TraceLevel.NETWORK);
    }

    public static void msgNetPrintln(String string) {
        Trace.msgPrintln(string, null, TraceLevel.NETWORK);
    }

    public static void msgNetPrintln(String string, Object[] objectArray) {
        Trace.msgPrintln(string, objectArray, TraceLevel.NETWORK);
    }

    public static void netPrintException(Throwable throwable) {
        Trace.printException(null, throwable, ResourceManager.getString("dialogfactory.net_error"), null, false);
    }

    public static void netPrintException(Throwable throwable, String string, String string2) {
        Trace.printException(null, throwable, string, string2, false);
    }

    public static void securityPrintln(String string) {
        Trace.println(string, TraceLevel.SECURITY);
    }

    public static void msgSecurityPrintln(String string) {
        Trace.msgPrintln(string, null, TraceLevel.SECURITY);
    }

    public static void msgSecurityPrintln(String string, Object[] objectArray) {
        Trace.msgPrintln(string, objectArray, TraceLevel.SECURITY);
    }

    public static void securityPrintException(Throwable throwable) {
        Trace.printException(null, throwable, ResourceManager.getString("dialogfactory.security_error"), null, true);
    }

    public static void securityPrintException(Throwable throwable, String string, String string2) {
        Trace.printException(null, throwable, string, string2, true);
    }

    public static void liveConnectPrintln(String string) {
        Trace.println(string, TraceLevel.LIVECONNECT);
    }

    public static void msgLiveConnectPrintln(String string) {
        Trace.msgPrintln(string, null, TraceLevel.LIVECONNECT);
    }

    public static void msgLiveConnectPrintln(String string, Object[] objectArray) {
        Trace.msgPrintln(string, objectArray, TraceLevel.LIVECONNECT);
    }

    public static void liveConnectPrintException(Throwable throwable) {
        Trace.printException(null, throwable, null, null, false);
    }

    public static File createTempFile(final String string, final String string2, File file) {
        try {
            if (file != null) {
                if (!file.isDirectory()) {
                    file.mkdirs();
                }
                File[] fileArray = file.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        String string3 = file.getName();
                        return string3.startsWith(string) && string3.endsWith(string2);
                    }
                });
                int n = Config.getIntProperty("deployment.max.output.files");
                if (n > 0 && fileArray.length >= n) {
                    int n2 = fileArray.length;
                    Arrays.sort(fileArray, new Comparator<Object>(){

                        @Override
                        public int compare(Object object, Object object2) {
                            Date date = new Date(((File)object).lastModified());
                            Date date2 = new Date(((File)object2).lastModified());
                            return date.compareTo(date2);
                        }
                    });
                    for (int i = 0; i < n2 - n + 1; ++i) {
                        fileArray[i].delete();
                    }
                }
            }
            return File.createTempFile(string, string2, file);
        }
        catch (Exception exception) {
            Trace.ignored(exception);
            return null;
        }
    }

    public static String getIntro() {
        DateFormat dateFormat = new SimpleDateFormat("EEE, d MMM yyyy");
        Date date = new Date(BuiltInProperties.getExpirationTime());
        dateFormat = DateFormat.getInstance();
        StringBuffer stringBuffer = new StringBuffer();
        String string = Environment.isJavaWebStart() ? "product.javaws.name" : "product.javapi.name";
        stringBuffer.append(ResourceManager.getString(string, BuiltInProperties.getProperty("DEPLOY_VERSION")));
        stringBuffer.append("\n");
        stringBuffer.append(ResourceManager.getString("console.using_jre_version", System.getProperty("java.runtime.version") + " " + System.getProperty("java.vm.name")));
        stringBuffer.append("\n");
        stringBuffer.append(ResourceManager.getString("console.expires", dateFormat.format(date)));
        stringBuffer.append("\n");
        stringBuffer.append(ResourceManager.getString("console.user_home") + " = " + System.getProperty("user.home"));
        return stringBuffer.toString();
    }

    static {
        Trace.resetTraceLevel();
        Thread thread = new Thread((Runnable)queueChecker, "traceMsgQueueThread");
        thread.setDaemon(true);
        thread.start();
    }

    private static class TeeStream
    extends PrintStream {
        private PrintStream tee = null;

        public TeeStream(OutputStream outputStream) {
            super(outputStream);
        }

        public void setTee(PrintStream printStream) {
            this.tee = printStream;
        }

        @Override
        public void flush() {
            super.flush();
            if (this.tee != null) {
                this.tee.flush();
            }
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
            super.write(byArray, n, n2);
            if (this.tee != null) {
                this.tee.write(byArray, n, n2);
            }
        }

        @Override
        public void write(int n) {
            super.write(n);
            if (this.tee != null) {
                this.tee.write(n);
            }
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            super.write(byArray);
            if (this.tee != null) {
                this.tee.write(byArray);
            }
        }
    }

    private static class TraceMsgQueueChecker
    implements Runnable {
        private TraceMsgQueueChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            try {
                object = this;
                synchronized (object) {
                    this.wait(2000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            while (true) {
                object = null;
                List list = queue;
                synchronized (list) {
                    if (queue.isEmpty()) {
                        try {
                            queue.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.interrupted();
                        }
                        continue;
                    }
                    try {
                        object = (TraceMessage)queue.remove(0);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    queue.notifyAll();
                }
                if (object == null) continue;
                Trace.firePrintlnEvent((TraceMessage)object);
            }
        }
    }
}

