/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.nativesandbox;

import com.sun.deploy.config.Platform;
import java.io.IOException;
import java.io.OutputStream;

public class NativeSandboxOutputStream
extends OutputStream {
    private String fileName = null;
    private boolean overwrite = false;

    public NativeSandboxOutputStream(String string, boolean bl) {
        this.fileName = string;
        this.overwrite = bl;
    }

    @Override
    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n & 0xFF)};
        this.write(byArray);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || byArray.length - n2 < 0 || n > byArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n == 0 && byArray.length == n2) {
            if (this.overwrite) {
                this.overwrite = false;
                Platform.get().getNativeSandboxBroker().writeFile(this.fileName, byArray, -1L, false);
            } else {
                Platform.get().getNativeSandboxBroker().writeFile(this.fileName, byArray, -1L, true);
            }
        } else {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            if (this.overwrite) {
                this.overwrite = false;
                Platform.get().getNativeSandboxBroker().writeFile(this.fileName, byArray2, -1L, false);
            } else {
                Platform.get().getNativeSandboxBroker().writeFile(this.fileName, byArray2, -1L, true);
            }
        }
    }
}

