/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Properties;

public class BuiltInProperties {
    public static final String JRE_BASELINE_CHECKS_ENABLED_KEY = "JRE_BASELINE_CHECKS_ENABLED";
    public static final String DEPLOY_COPYRIGHT_YEAR_KEY = "DEPLOY_COPYRIGHT_YEAR";
    public static final String JRE_EXPIRATION_DATE_KEY = "JRE_EXPIRATION_DATE";
    public static final String BASELINE_VERSION_131_KEY = "BASELINE_VERSION_131";
    public static final String BASELINE_VERSION_142_KEY = "BASELINE_VERSION_142";
    public static final String BASELINE_VERSION_150_KEY = "BASELINE_VERSION_150";
    public static final String BASELINE_VERSION_160_KEY = "BASELINE_VERSION_160";
    public static final String BASELINE_VERSION_170_KEY = "BASELINE_VERSION_170";
    public static final String BASELINE_VERSION_180_KEY = "BASELINE_VERSION_180";
    public static final String BASELINE_VERSION_190_KEY = "BASELINE_VERSION_190";
    public static final String CURRENT_VERSION_KEY = "CURRENT_VERSION";
    public static final String DEPLOY_VERSION_KEY = "DEPLOY_VERSION";
    public static final String MSVCR_DLL_NAME_KEY = "MSVCR_DLL_NAME";
    public static final String MSVCP_DLL_NAME_KEY = "MSVCP_DLL_NAME";
    private final String PROP_BASE_NAME = "builtin.properties";
    private final long expirationTime;
    private Properties props = null;
    private static BuiltInProperties instance = null;

    public static synchronized BuiltInProperties getInstance() {
        if (instance == null) {
            instance = new BuiltInProperties();
        }
        return instance;
    }

    private BuiltInProperties() {
        this.loadProperties();
        long l = 0L;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy", Locale.US);
            l = simpleDateFormat.parse(this.props.getProperty(JRE_EXPIRATION_DATE_KEY)).getTime();
        }
        catch (Exception exception) {
            Trace.ignored(exception);
        }
        this.expirationTime = l;
    }

    private void loadProperties() {
        this.props = new Properties();
        try {
            InputStream inputStream = BuiltInProperties.class.getResourceAsStream("builtin.properties");
            if (inputStream != null) {
                this.props.load(inputStream);
            } else {
                Trace.print("Unable to load builtin.properties", TraceLevel.SECURITY);
            }
        }
        catch (IOException iOException) {
            Trace.ignored(iOException);
        }
    }

    public static String getProperty(String string) {
        return BuiltInProperties.getInstance().props.getProperty(string);
    }

    public static long getExpirationTime() {
        return BuiltInProperties.getInstance().expirationTime;
    }

    public static boolean isJreBaselineCheckEnabled() {
        return Boolean.valueOf(BuiltInProperties.getInstance().props.getProperty(JRE_BASELINE_CHECKS_ENABLED_KEY));
    }
}

