/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.Config;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Base64;

public class Base64Wrapper {
    public static byte[] decodeFromString(String string) throws IOException {
        if (Config.isJavaVersionAtLeast18()) {
            return Base64.getMimeDecoder().decode(string);
        }
        return SunMiscBase64Wrapper.decodeBuffer(string);
    }

    public static String encodeToString(byte[] byArray) {
        if (Config.isJavaVersionAtLeast18()) {
            return Base64.getMimeEncoder().encodeToString(byArray);
        }
        return SunMiscBase64Wrapper.encode(byArray);
    }

    public static String encodeToStringWithoutLineBreaks(byte[] byArray) {
        if (Config.isJavaVersionAtLeast18()) {
            return Base64.getEncoder().encodeToString(byArray);
        }
        return SunMiscBase64Wrapper.encodeToStringWithoutLineBreaks(byArray);
    }

    public static void encodeToBuffer(byte[] byArray, PrintStream printStream) throws IOException {
        if (Config.isJavaVersionAtLeast18()) {
            printStream.println(Base64Wrapper.encodeToString(byArray));
        } else {
            SunMiscBase64Wrapper.encodeBuffer(byArray, printStream);
        }
    }

    private static class SunMiscBase64Wrapper {
        private static final Class<?> decoderClass;
        private static final Class<?> encoderClass;
        private static final Constructor<?> decoderCon;
        private static final Constructor<?> encoderCon;
        private static final Method decodeBuffer;
        private static final Method encode;
        private static final Method encodeBuffer;
        private static final char[] pem_array;

        private SunMiscBase64Wrapper() {
        }

        public static byte[] decodeBuffer(String string) {
            try {
                Object obj = decoderCon.newInstance(new Object[0]);
                return (byte[])decodeBuffer.invoke(obj, string);
            }
            catch (InvocationTargetException invocationTargetException) {
                SunMiscBase64Wrapper.rethrowCause(invocationTargetException);
                return null;
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new InternalError(reflectiveOperationException);
            }
        }

        public static String encode(byte[] byArray) {
            try {
                Object obj = encoderCon.newInstance(new Object[0]);
                return (String)encode.invoke(obj, new Object[]{byArray});
            }
            catch (InvocationTargetException invocationTargetException) {
                SunMiscBase64Wrapper.rethrowCause(invocationTargetException);
                return null;
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new InternalError(reflectiveOperationException);
            }
        }

        public static void encodeBuffer(byte[] byArray, PrintStream printStream) {
            try {
                Object obj = encoderCon.newInstance(new Object[0]);
                encodeBuffer.invoke(obj, byArray, printStream);
                return;
            }
            catch (InvocationTargetException invocationTargetException) {
                SunMiscBase64Wrapper.rethrowCause(invocationTargetException);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new InternalError(reflectiveOperationException);
            }
        }

        public static String encodeToStringWithoutLineBreaks(byte[] byArray) {
            return SunMiscBase64Wrapper.base64Encode(byArray);
        }

        private static void rethrowCause(InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new AssertionError((Object)invocationTargetException);
        }

        private static String base64Encode(byte[] byArray) {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = byArray.length;
            for (int i = 0; i < n2; i += n) {
                n = Math.min(n2 - i, 3);
                try {
                    SunMiscBase64Wrapper.encodeAtom(byteArrayOutputStream, byArray, i, n);
                    continue;
                }
                catch (IOException iOException) {
                    System.err.println("caught error encoding argument list: " + iOException);
                    return null;
                }
            }
            return byteArrayOutputStream.toString();
        }

        private static void encodeAtom(OutputStream outputStream, byte[] byArray, int n, int n2) throws IOException {
            if (n2 == 1) {
                byte by = byArray[n];
                int n3 = 0;
                boolean bl = false;
                outputStream.write(pem_array[by >>> 2 & 0x3F]);
                outputStream.write(pem_array[(by << 4 & 0x30) + (n3 >>> 4 & 0xF)]);
                outputStream.write(61);
                outputStream.write(61);
            } else if (n2 == 2) {
                byte by = byArray[n];
                byte by2 = byArray[n + 1];
                int n4 = 0;
                outputStream.write(pem_array[by >>> 2 & 0x3F]);
                outputStream.write(pem_array[(by << 4 & 0x30) + (by2 >>> 4 & 0xF)]);
                outputStream.write(pem_array[(by2 << 2 & 0x3C) + (n4 >>> 6 & 3)]);
                outputStream.write(61);
            } else {
                byte by = byArray[n];
                byte by3 = byArray[n + 1];
                byte by4 = byArray[n + 2];
                outputStream.write(pem_array[by >>> 2 & 0x3F]);
                outputStream.write(pem_array[(by << 4 & 0x30) + (by3 >>> 4 & 0xF)]);
                outputStream.write(pem_array[(by3 << 2 & 0x3C) + (by4 >>> 6 & 3)]);
                outputStream.write(pem_array[by4 & 0x3F]);
            }
        }

        static {
            try {
                decoderClass = Class.forName("sun.misc.BASE64Decoder");
                decodeBuffer = decoderClass.getMethod("decodeBuffer", String.class);
                encoderClass = Class.forName("sun.misc.BASE64Encoder");
                encode = encoderClass.getMethod("encode", byte[].class);
                encodeBuffer = encoderClass.getMethod("encodeBuffer", byte[].class, OutputStream.class);
                decoderCon = decoderClass.getConstructor(new Class[0]);
                encoderCon = encoderClass.getConstructor(new Class[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new InternalError(reflectiveOperationException);
            }
            pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        }
    }
}

