/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.UIToolkit;
import com.sun.deploy.uitoolkit.WindowFactory;
import com.sun.deploy.uitoolkit.impl.awt.UIToolkitImpl;
import com.sun.deploy.uitoolkit.ui.UIFactory;
import com.sun.deploy.util.FXLoader;

public class ToolkitStore {
    public static final String JNLP_TK = "jnlp.tk";
    public static final String JNLP_FX = "jnlp.fx";
    public static final String JNLP_TK_AWT = "awt";
    public static final String JNLP_TK_FX = "jfx";
    private static volatile UIToolkit toolkitImpl = null;
    private static final DefaultToolkitFactory defaultToolkitFactory = new DefaultToolkitFactory();
    private static ToolkitFactory toolkitFactory = defaultToolkitFactory;
    private static ToolkitType toolkitType = ToolkitType.AWT_TOOLKIT;
    private static boolean forceToolkitMatchForTests = false;

    private static boolean isInitialized() {
        return null != toolkitImpl;
    }

    private static void ensureJfxAvailability() throws ClassNotFoundException {
        FXLoader.loadFX();
    }

    private static void ensureAWTAvailability() throws Exception {
        try {
            Class.forName("sun.awt.SunToolkit", false, ToolkitStore.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Exception("AWT is not available !!");
        }
    }

    private static synchronized UIToolkit init() throws Exception {
        String string = System.getProperty(JNLP_TK);
        if (string != null) {
            if ((string = string.trim()).equalsIgnoreCase(JNLP_TK_FX)) {
                ToolkitStore.setToolkitType(ToolkitType.FX_TOOLKIT);
                try {
                    ToolkitStore.ensureJfxAvailability();
                    ToolkitStore.setToolkitType(ToolkitType.FX_TOOLKIT);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Trace.ignored(classNotFoundException);
                    ToolkitStore.setToolkitType(ToolkitType.AWT_TOOLKIT);
                }
            } else {
                ToolkitStore.setToolkitType(ToolkitType.AWT_TOOLKIT);
            }
        } else {
            String string2 = System.getProperty(JNLP_FX);
            if (string2 != null) {
                try {
                    ToolkitStore.ensureJfxAvailability();
                    ToolkitStore.setToolkitType(ToolkitType.FX_TOOLKIT);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Trace.ignored(classNotFoundException);
                    ToolkitStore.setToolkitType(ToolkitType.AWT_TOOLKIT);
                }
            }
        }
        if (toolkitType == ToolkitType.AWT_TOOLKIT) {
            ToolkitStore.ensureAWTAvailability();
        }
        toolkitFactory.setToolkitType(toolkitType);
        toolkitImpl = toolkitFactory.create();
        if (toolkitImpl != null) {
            toolkitType = toolkitFactory.getToolkitType();
            toolkitImpl.init();
        }
        return toolkitImpl;
    }

    public static void setToolkitFactory(ToolkitFactory toolkitFactory) {
        if (!ToolkitStore.toolkitFactory.equals(toolkitFactory)) {
            boolean bl = false;
            if (ToolkitStore.isInitialized()) {
                Trace.println("Attempt to set toolkit factory after already initialized.", TraceLevel.UI);
                try {
                    ToolkitStore.dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                bl = true;
            }
            ToolkitStore.toolkitFactory = toolkitFactory == null ? defaultToolkitFactory : toolkitFactory;
            ToolkitStore.toolkitFactory.setToolkitType(toolkitType);
            if (bl) {
                ToolkitStore.get();
            }
        }
    }

    public static void setToolkitType(ToolkitType toolkitType) {
        if (ToolkitStore.toolkitType == toolkitType) {
            return;
        }
        if (ToolkitStore.isInitialized()) {
            Trace.println("Warning: ToolkitStore.setToolkitType() called after initialized, may not be effective", TraceLevel.UI);
        }
        toolkitFactory.setToolkitType(toolkitType);
        ToolkitStore.toolkitType = toolkitFactory.getToolkitType();
    }

    public static boolean isAWTToolkitRunning() {
        return toolkitType == ToolkitType.AWT_TOOLKIT;
    }

    public static synchronized void dispose() throws Exception {
        forceToolkitMatchForTests = false;
        if (!ToolkitStore.isInitialized()) {
            return;
        }
        toolkitImpl.dispose();
        toolkitImpl = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UIToolkit get() {
        if (ToolkitStore.isInitialized()) return toolkitImpl;
        Class<ToolkitStore> clazz = ToolkitStore.class;
        synchronized (ToolkitStore.class) {
            if (ToolkitStore.isInitialized()) return toolkitImpl;
            try {
                ToolkitStore.init();
            }
            catch (Exception exception) {
                Trace.ignored(exception);
            }
            return toolkitImpl;
        }
    }

    public static UIFactory getUI() {
        return ToolkitStore.get().getUIFactory();
    }

    public static WindowFactory getWindowFactory() {
        return ToolkitStore.get().getWindowFactory();
    }

    public static boolean isToolkitType(ToolkitType toolkitType) {
        return ToolkitStore.toolkitType == toolkitType;
    }

    public static synchronized boolean setPreferredToolkit(ToolkitType toolkitType) {
        if (forceToolkitMatchForTests) {
            return true;
        }
        if (!ToolkitStore.isInitialized()) {
            ToolkitStore.setToolkitType(toolkitType);
            ToolkitStore.get();
        }
        return ToolkitStore.isToolkitType(toolkitType);
    }

    private static class DefaultToolkitFactory
    extends ToolkitFactory {
        private UIToolkit toolkit = null;

        private DefaultToolkitFactory() {
        }

        @Override
        public void setToolkitType(ToolkitType toolkitType) {
            if (toolkitType != this.selectedType && this.toolkit != null) {
                Trace.println("WARNING: Changing toolkit type after initialization is not supported!", TraceLevel.UI);
            } else {
                super.setToolkitType(toolkitType);
            }
        }

        @Override
        public synchronized UIToolkit create() {
            if (this.toolkit == null) {
                switch (this.selectedType) {
                    case AWT_TOOLKIT: {
                        this.toolkit = new UIToolkitImpl();
                        break;
                    }
                    case FX_TOOLKIT: {
                        Trace.println("Error: cannot create FX toolkit outside of jdk.plugin", TraceLevel.UI);
                    }
                }
            }
            return this.toolkit;
        }
    }

    public static abstract class ToolkitFactory {
        protected ToolkitType selectedType;

        public void setToolkitType(ToolkitType toolkitType) {
            this.selectedType = toolkitType;
        }

        public ToolkitType getToolkitType() {
            return this.selectedType;
        }

        public abstract UIToolkit create();
    }

    public static enum ToolkitType {
        AWT_TOOLKIT,
        FX_TOOLKIT;

    }
}

