/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public final class CertificateHostnameVerifier
implements HostnameVerifier {
    private static final HashSet<Object[]> hashSet = new HashSet();

    @Override
    public boolean verify(String string, SSLSession sSLSession) {
        X509Certificate x509Certificate;
        Object object;
        String string2 = ResourceManager.getString("https.dialog.unknown.host");
        try {
            int n;
            object = sSLSession.getPeerCertificates();
            if (!(object[0] instanceof X509Certificate)) {
                throw new SSLPeerUnverifiedException("");
            }
            x509Certificate = (X509Certificate)object[0];
            String string3 = x509Certificate.getSubjectDN().getName();
            if (string3 != null && (n = string3.toUpperCase().indexOf("CN=")) != -1) {
                int n2 = string3.indexOf(",", n);
                string2 = n2 != -1 ? string3.substring(n + 3, n2) : string3.substring(n + 3);
            }
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            return false;
        }
        object = CertUtils.getServername(x509Certificate);
        if (CertUtils.checkWildcardDomainList(string, (ArrayList<String>)object)) {
            return true;
        }
        for (Object[] objectArray : hashSet) {
            if (!objectArray[0].toString().equalsIgnoreCase(string) || !objectArray[1].toString().equalsIgnoreCase(string2)) continue;
            return true;
        }
        return this.showHostnameMismatchDialog(string, string2);
    }

    private boolean showHostnameMismatchDialog(String string, String string2) {
        int n;
        String string3 = ResourceManager.getString("https.dialog.caption");
        String string4 = ResourceManager.getString("https.dialog.masthead");
        AppInfo appInfo = new AppInfo(0, string, string2, null, null, null, null, false, false, null, null);
        String string5 = ResourceManager.getString("security.dialog.signed.buttonContinue");
        String string6 = ResourceManager.getString("security.dialog.signed.buttonCancel");
        String[] stringArray = new String[]{ResourceManager.getString("security.dialog.hostname.mismatch.sub", string, string2)};
        if (!Trace.isAutomationEnabled()) {
            n = Config.getBooleanProperty("deployment.security.jsse.hostmismatch.warning") ? ToolkitStore.getUI().showSecurityDialog(appInfo, string3, string4, string2, null, false, false, string5, string6, stringArray, null, false, null, -1, -1, false) : 0;
        } else {
            Trace.msgSecurityPrintln("hostnameverifier.automation.ignoremismatch");
            n = 0;
        }
        if (n == 0) {
            Object[] objectArray = new Object[]{string, string2};
            hashSet.add(objectArray);
        }
        return n == 0;
    }

    public static void reset() {
        hashSet.clear();
    }
}

