/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.ipc;

import com.sun.deploy.config.OSType;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import sun.plugin2.ipc.Event;
import sun.plugin2.ipc.NamedPipe;

public abstract class IPCFactory {
    public static final int KB = 1024;
    public static final int PIPE_BUF_SZ = 4096;
    private static IPCFactory instance;
    private static Constructor<?> cons;

    protected IPCFactory() {
    }

    public static IPCFactory getFactory() {
        if (instance == null) {
            try {
                String string;
                if (OSType.isWin()) {
                    string = "sun.plugin2.ipc.windows.WindowsIPCFactory";
                } else if (OSType.isMac() || OSType.isUnix()) {
                    string = "sun.plugin2.ipc.unix.UnixIPCFactory";
                } else {
                    throw new RuntimeException("Unknown OS type");
                }
                cons = Class.forName(string).getConstructor(new Class[0]);
                instance = (IPCFactory)cons.newInstance(new Object[0]);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new RuntimeException(exception);
            }
        }
        return instance;
    }

    public abstract Event createEvent(Map<String, String> var1);

    public abstract NamedPipe createNamedPipe(Map<String, String> var1);

    public static String mapToString(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string : map.keySet()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append(string);
            stringBuilder.append("=");
            stringBuilder.append(map.get(string));
        }
        return stringBuilder.toString();
    }

    public static Map<String, String> stringToMap(String string) {
        String[] stringArray;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : stringArray = string.split(",")) {
            int n = string2.indexOf("=");
            hashMap.put(string2.substring(0, n), string2.substring(n + 1, string2.length()));
        }
        return hashMap;
    }
}

