/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.dom.html;

import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.DocumentCSS;
import org.w3c.dom.css.ElementCSSInlineStyle;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.stylesheets.DocumentStyle;
import org.w3c.dom.stylesheets.StyleSheetList;
import org.w3c.dom.views.AbstractView;
import org.w3c.dom.views.DocumentView;
import sun.plugin.dom.DOMObject;
import sun.plugin.dom.DOMObjectFactory;
import sun.plugin.dom.DOMObjectHelper;
import sun.plugin.dom.core.Document;
import sun.plugin.dom.css.ViewCSS;
import sun.plugin.dom.exception.PluginNotSupportedException;
import sun.plugin.dom.html.HTMLElement;

public class HTMLDocument
extends Document
implements org.w3c.dom.html.HTMLDocument,
DocumentView,
DocumentStyle,
DocumentCSS {
    private static final String TAG_HTML = "HTML";

    public HTMLDocument(DOMObject dOMObject, org.w3c.dom.html.HTMLDocument hTMLDocument) {
        super(dOMObject, hTMLDocument);
    }

    @Override
    public String getTitle() {
        return this.getAttribute("title");
    }

    @Override
    public void setTitle(String string) {
        this.setAttribute("title", string);
    }

    @Override
    public String getReferrer() {
        return this.getAttribute("referrer");
    }

    @Override
    public String getDomain() {
        return this.getAttribute("domain");
    }

    @Override
    public String getURL() {
        return this.getAttribute("URL");
    }

    @Override
    public org.w3c.dom.html.HTMLElement getBody() {
        Object object = this.obj.getMember("body");
        if (object == null) {
            return null;
        }
        return DOMObjectFactory.createHTMLElement((DOMObject)object, this);
    }

    @Override
    public void setBody(org.w3c.dom.html.HTMLElement hTMLElement) {
        DOMObject dOMObject = ((HTMLElement)hTMLElement).getDOMObject();
        this.obj.setMember("body", dOMObject);
    }

    @Override
    public HTMLCollection getImages() {
        return DOMObjectFactory.createHTMLCollection(this.obj.getMember("images"), this);
    }

    @Override
    public HTMLCollection getApplets() {
        return DOMObjectFactory.createHTMLCollection(this.obj.getMember("applets"), this);
    }

    @Override
    public HTMLCollection getLinks() {
        return DOMObjectFactory.createHTMLCollection(this.obj.getMember("links"), this);
    }

    @Override
    public HTMLCollection getForms() {
        return DOMObjectFactory.createHTMLCollection(this.obj.getMember("forms"), this);
    }

    @Override
    public HTMLCollection getAnchors() {
        return DOMObjectFactory.createHTMLCollection(this.obj.getMember("anchors"), this);
    }

    @Override
    public String getCookie() {
        return this.getAttribute("cookie");
    }

    @Override
    public void setCookie(String string) {
        this.setAttribute("cookie", string);
    }

    @Override
    public void open() {
        throw new PluginNotSupportedException("HTMLDocument.open() is not supported");
    }

    @Override
    public void close() {
        throw new PluginNotSupportedException("HTMLDocument.close() is not supported");
    }

    @Override
    public void write(String string) {
        throw new PluginNotSupportedException("HTMLDocument.write() is not supported");
    }

    @Override
    public void writeln(String string) {
        throw new PluginNotSupportedException("HTMLDocument.writeln() is not supported");
    }

    @Override
    public NodeList getElementsByName(String string) {
        return DOMObjectFactory.createNodeList(this.obj.call("getElementsByName", new Object[]{string}), this);
    }

    @Override
    public NodeList getElementsByTagName(String string) {
        return DOMObjectFactory.createNodeList(this.obj.call("getElementsByTagName", new Object[]{string}), this);
    }

    @Override
    public Element getDocumentElement() {
        Object object = this.obj.getMember("documentElement");
        if (object == null) {
            return null;
        }
        return DOMObjectFactory.createHTMLElement((DOMObject)object, this);
    }

    @Override
    public Element createElement(String string) throws DOMException {
        Object object = this.obj.call("createElement", new Object[]{string});
        if (object == null) {
            return null;
        }
        return DOMObjectFactory.createHTMLElement((DOMObject)object, this);
    }

    @Override
    public Element createElementNS(String string, String string2) throws DOMException {
        Object object = this.obj.call("createElementNS", new Object[]{string, string2});
        if (object == null) {
            return null;
        }
        return DOMObjectFactory.createHTMLElement((DOMObject)object, this);
    }

    @Override
    public Element getElementById(String string) {
        Object object = this.obj.call("getElementById", new Object[]{string});
        if (object == null) {
            return null;
        }
        return DOMObjectFactory.createHTMLElement((DOMObject)object, this);
    }

    private String getAttribute(String string) {
        return DOMObjectHelper.getStringMember(this.obj, string);
    }

    private void setAttribute(String string, String string2) {
        DOMObjectHelper.setStringMember(this.obj, string, string2);
    }

    @Override
    public AbstractView getDefaultView() {
        return new ViewCSS(this);
    }

    @Override
    public StyleSheetList getStyleSheets() {
        return DOMObjectFactory.createStyleSheetList(this.obj.getMember("styleSheets"), this);
    }

    @Override
    public CSSStyleDeclaration getOverrideStyle(Element element, String string) {
        if (element instanceof ElementCSSInlineStyle) {
            ElementCSSInlineStyle elementCSSInlineStyle = (ElementCSSInlineStyle)((Object)element);
            return elementCSSInlineStyle.getStyle();
        }
        return null;
    }

    @Override
    public NodeList getChildNodes() {
        return this.getElementsByTagName(TAG_HTML);
    }
}

