/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.com;

import com.sun.deploy.resources.ResourceManager;
import java.lang.reflect.InvocationTargetException;
import netscape.javascript.JSObject;
import sun.plugin.com.DispatchImpl;

public class ParameterListCorrelator {
    private static final int BOOL_CODE = 0;
    private static final int BYTE_CODE = 1;
    private static final int SHORT_CODE = 2;
    private static final int INT_CODE = 3;
    private static final int LONG_CODE = 4;
    private static final int FLOAT_CODE = 5;
    private static final int DOUBLE_CODE = 6;
    private static final int CHAR_CODE = 7;
    private static final int NOT_PRIMITIVE_CODE = 8;
    private Class<?>[] expectedClasses;
    private Object[] givenParameters;
    private boolean analysisIsDone;
    private boolean parametersCorrelateToClasses;
    private int numberOfConversionsNeeded;

    ParameterListCorrelator(Class<?>[] classArray, Object[] objectArray) {
        this.expectedClasses = classArray;
        if (this.expectedClasses == null) {
            this.expectedClasses = new Class[0];
        }
        this.givenParameters = objectArray;
        if (this.givenParameters == null) {
            this.givenParameters = new Object[0];
        }
        this.analysisIsDone = false;
        this.numberOfConversionsNeeded = 0;
        this.parametersCorrelateToClasses = false;
    }

    boolean parametersCorrelateToClasses() {
        this.analyze();
        return this.parametersCorrelateToClasses;
    }

    int numberOfConversionsNeeded() throws InvocationTargetException {
        this.analyze();
        if (!this.parametersCorrelateToClasses) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(ResourceManager.getString((String)"com.method.argsTypeInvalid"));
            throw new InvocationTargetException(illegalArgumentException);
        }
        return this.numberOfConversionsNeeded;
    }

    private void analyze() {
        if (!this.analysisIsDone) {
            this.parametersCorrelateToClasses = true;
            if (this.expectedClasses.length != this.givenParameters.length) {
                this.reportParametersDoNotCorrelate();
            }
            for (int i = 0; !this.analysisIsDone && i < this.givenParameters.length; ++i) {
                this.analyzeParameter(this.expectedClasses[i], this.givenParameters[i]);
            }
            this.analysisIsDone = true;
        }
    }

    private void analyzeParameter(Class<?> clazz, Object object) {
        if (object != null) {
            this.analyzeParameter(clazz, object.getClass());
        }
    }

    private void analyzeParameter(Class<?> clazz, Class<?> clazz2) {
        if (clazz2 == null) {
            return;
        }
        if (clazz.equals(clazz2)) {
            return;
        }
        if (clazz.isAssignableFrom(clazz2)) {
            ++this.numberOfConversionsNeeded;
        } else if (clazz == String.class) {
            ++this.numberOfConversionsNeeded;
        } else if ((clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) || clazz == Character.class || clazz == Boolean.class) && clazz2 == String.class) {
            ++this.numberOfConversionsNeeded;
        } else if (clazz.isArray()) {
            if (!clazz2.isArray()) {
                this.reportParametersDoNotCorrelate();
            } else {
                Class<?> clazz3 = clazz.getComponentType();
                Class<?> clazz4 = clazz2.getComponentType();
                if (!clazz4.equals(Object.class)) {
                    this.analyzeParameter(clazz3, clazz4);
                }
            }
        } else if (clazz.equals(JSObject.class)) {
            ++this.numberOfConversionsNeeded;
        } else if (clazz.equals(DispatchImpl.class)) {
            ++this.numberOfConversionsNeeded;
        } else if (!this.typesAreEquivalentPrimitives(clazz, clazz2)) {
            this.reportParametersDoNotCorrelate();
        }
    }

    private boolean typesAreEquivalentPrimitives(Class<?> clazz, Class<?> clazz2) {
        int n = ParameterListCorrelator.typeCodeFromTypeName(clazz.getName());
        if (n != 8) {
            int n2 = ParameterListCorrelator.typeCodeFromTypeName(clazz2.getName());
            if (n2 == 8) {
                return false;
            }
            if (n != n2) {
                ++this.numberOfConversionsNeeded;
            }
            return true;
        }
        return false;
    }

    private static int typeCodeFromTypeName(String string) {
        if (string.equals("boolean") || string.equals("java.lang.Boolean")) {
            return 0;
        }
        if (string.equals("byte") || string.equals("java.lang.Byte")) {
            return 1;
        }
        if (string.equals("short") || string.equals("java.lang.Short")) {
            return 2;
        }
        if (string.equals("int") || string.equals("java.lang.Integer")) {
            return 3;
        }
        if (string.equals("long") || string.equals("java.lang.Long")) {
            return 4;
        }
        if (string.equals("float") || string.equals("java.lang.Float")) {
            return 5;
        }
        if (string.equals("double") || string.equals("java.lang.Double")) {
            return 6;
        }
        if (string.equals("char") || string.equals("java.lang.Character")) {
            return 7;
        }
        return 8;
    }

    private void reportParametersDoNotCorrelate() {
        this.parametersCorrelateToClasses = false;
        this.analysisIsDone = true;
    }
}

