/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.Config;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.CodeSource;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class DeployJavaUtilJarAccess {
    private static final String PKG_PREFIX = "jdk.internal.misc";
    private static final String LEGACY_PKG_PREFIX = "sun.misc";
    private final Object javaUtilJarAccess;
    private final Method jarFileHasClassPathAttributeMethod;
    private final Method getCodeSourcesMethod;
    private final Method getCodeSourceMethod;
    private final Method entryNamesMethod;
    private final Method entries2Method;
    private final Method setEagerValidationMethod;
    private final Method getManifestDigestsMethod;
    private final Method getRealNameMethod;
    private static DeployJavaUtilJarAccess instance;

    private DeployJavaUtilJarAccess() throws ReflectiveOperationException {
        Class<?> c = this.getJDKClass("JavaUtilJarAccess");
        Method m = this.getJDKClass("SharedSecrets").getDeclaredMethod("javaUtilJarAccess", new Class[0]);
        this.javaUtilJarAccess = m.invoke(null, new Object[0]);
        this.jarFileHasClassPathAttributeMethod = c.getDeclaredMethod("jarFileHasClassPathAttribute", JarFile.class);
        this.getCodeSourcesMethod = c.getDeclaredMethod("getCodeSources", JarFile.class, URL.class);
        this.getCodeSourceMethod = c.getDeclaredMethod("getCodeSource", JarFile.class, URL.class, String.class);
        this.entryNamesMethod = c.getDeclaredMethod("entryNames", JarFile.class, CodeSource[].class);
        this.entries2Method = c.getDeclaredMethod("entries2", JarFile.class);
        this.setEagerValidationMethod = c.getDeclaredMethod("setEagerValidation", JarFile.class, Boolean.TYPE);
        this.getManifestDigestsMethod = c.getDeclaredMethod("getManifestDigests", JarFile.class);
        this.getRealNameMethod = Config.isJavaVersionAtLeast9() ? c.getDeclaredMethod("getRealName", JarFile.class, JarEntry.class) : null;
    }

    private Class<?> getJDKClass(String name) throws ClassNotFoundException {
        try {
            return Class.forName("jdk.internal.misc." + name);
        }
        catch (ClassNotFoundException x) {
            try {
                return Class.forName("sun.misc." + name);
            }
            catch (ClassNotFoundException ex) {
                x.addSuppressed(ex);
                throw x;
            }
        }
    }

    public static synchronized DeployJavaUtilJarAccess instance() {
        try {
            if (instance == null) {
                instance = new DeployJavaUtilJarAccess();
            }
            return instance;
        }
        catch (ReflectiveOperationException x) {
            throw new InternalError(x);
        }
    }

    public boolean jarFileHasClassPathAttribute(JarFile jar) throws IOException {
        try {
            return (Boolean)this.jarFileHasClassPathAttributeMethod.invoke(this.javaUtilJarAccess, jar);
        }
        catch (InvocationTargetException x) {
            if (x.getTargetException() instanceof IOException) {
                throw (IOException)x.getTargetException();
            }
            DeployJavaUtilJarAccess.rethrowCause(x);
            return false;
        }
        catch (ReflectiveOperationException x) {
            throw new InternalError(x);
        }
    }

    public CodeSource[] getCodeSources(JarFile jar, URL url) {
        try {
            return (CodeSource[])this.getCodeSourcesMethod.invoke(this.javaUtilJarAccess, jar, url);
        }
        catch (InvocationTargetException x) {
            DeployJavaUtilJarAccess.rethrowCause(x);
            return null;
        }
        catch (ReflectiveOperationException x) {
            throw new InternalError(x);
        }
    }

    public CodeSource getCodeSource(JarFile jar, URL url, String name) {
        try {
            return (CodeSource)this.getCodeSourceMethod.invoke(this.javaUtilJarAccess, jar, url, name);
        }
        catch (InvocationTargetException x) {
            DeployJavaUtilJarAccess.rethrowCause(x);
            return null;
        }
        catch (ReflectiveOperationException x) {
            throw new InternalError(x);
        }
    }

    public Enumeration<String> entryNames(JarFile jar, CodeSource[] cs) {
        try {
            return (Enumeration)this.entryNamesMethod.invoke(this.javaUtilJarAccess, jar, cs);
        }
        catch (InvocationTargetException x) {
            DeployJavaUtilJarAccess.rethrowCause(x);
            return null;
        }
        catch (ReflectiveOperationException x) {
            throw new InternalError(x);
        }
    }

    public Enumeration<JarEntry> entries2(JarFile jar) {
        try {
            return (Enumeration)this.entries2Method.invoke(this.javaUtilJarAccess, jar);
        }
        catch (InvocationTargetException x) {
            DeployJavaUtilJarAccess.rethrowCause(x);
            return null;
        }
        catch (ReflectiveOperationException x) {
            throw new InternalError(x);
        }
    }

    public void setEagerValidation(JarFile jar, boolean eager) {
        try {
            this.setEagerValidationMethod.invoke(this.javaUtilJarAccess, jar, eager);
        }
        catch (InvocationTargetException x) {
            DeployJavaUtilJarAccess.rethrowCause(x);
        }
        catch (ReflectiveOperationException x) {
            throw new InternalError(x);
        }
    }

    public String getRealName(JarFile jf, JarEntry je) {
        if (this.getRealNameMethod == null) {
            throw new InternalError("Should be called in Java 9 and up");
        }
        try {
            return (String)this.getRealNameMethod.invoke(this.javaUtilJarAccess, jf, je);
        }
        catch (InvocationTargetException x) {
            DeployJavaUtilJarAccess.rethrowCause(x);
            return null;
        }
        catch (ReflectiveOperationException x) {
            throw new InternalError(x);
        }
    }

    public List<Object> getManifestDigests(JarFile jar) {
        try {
            return (List)this.getManifestDigestsMethod.invoke(this.javaUtilJarAccess, jar);
        }
        catch (InvocationTargetException x) {
            DeployJavaUtilJarAccess.rethrowCause(x);
            return null;
        }
        catch (ReflectiveOperationException x) {
            throw new InternalError(x);
        }
    }

    private static void rethrowCause(InvocationTargetException t) {
        Throwable cause = t.getTargetException();
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        throw new AssertionError((Object)t);
    }
}

