/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Platform;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CredentialInfo;
import com.sun.deploy.services.Service;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;

public class BrowserKeystore {
    private static Object cryptoManager = null;
    private static boolean initializeJSS = false;

    public static void registerSecurityProviders() {
        Provider provider;
        Class<?> providerClass2;
        Service service = ServiceManager.getService();
        if (service.isIExplorer()) {
            try {
                providerClass2 = Class.forName("com.sun.deploy.security.MSCryptoProvider", true, ClassLoader.getSystemClassLoader());
                if (providerClass2 != null) {
                    provider = (Provider)providerClass2.newInstance();
                    Security.insertProviderAt(provider, Security.getProviders().length + 1);
                }
            }
            catch (Throwable providerClass2) {
                // empty catch block
            }
        }
        if (service.isNetscape()) {
            if (BrowserKeystore.isJSSCryptoConfigured()) {
                Trace.msgSecurityPrintln("browserkeystore.jss.config");
                try {
                    providerClass2 = Class.forName("com.sun.deploy.security.MozillaJSSProvider", true, ClassLoader.getSystemClassLoader());
                    if (providerClass2 != null) {
                        provider = (Provider)providerClass2.newInstance();
                        Security.insertProviderAt(provider, Security.getProviders().length + 1);
                    }
                }
                catch (Throwable e) {
                    Trace.msgSecurityPrintln("browserkeystore.jss.notconfig");
                }
            } else {
                Trace.msgSecurityPrintln("browserkeystore.jss.notconfig");
            }
        }
    }

    static synchronized Object getJSSCryptoManager() {
        if (cryptoManager == null && !initializeJSS) {
            initializeJSS = true;
            String mozillaUserProfileDir = null;
            mozillaUserProfileDir = Platform.get().isBrowserFireFox() ? Platform.get().getFireFoxUserProfileDirectory() : Platform.get().getMozillaUserProfileDirectory();
            Trace.msgSecurityPrintln("browserkeystore.mozilla.dir", new Object[]{mozillaUserProfileDir});
            if (mozillaUserProfileDir != null) {
                try {
                    Class<?> jssInitializationValues = Class.forName("org.mozilla.jss.CryptoManager$InitializationValues", true, ClassLoader.getSystemClassLoader());
                    Constructor<?> constructorInitializationValues = jssInitializationValues.getConstructor(String.class);
                    Object initializationValues = constructorInitializationValues.newInstance(mozillaUserProfileDir);
                    Field fieldInstallJSSProvider = jssInitializationValues.getField("installJSSProvider");
                    fieldInstallJSSProvider.setBoolean(initializationValues, false);
                    Class<?> jssCryptoManager = Class.forName("org.mozilla.jss.CryptoManager", true, ClassLoader.getSystemClassLoader());
                    Method inimeth = jssCryptoManager.getMethod("initialize", jssInitializationValues);
                    Object retobj = inimeth.invoke(null, initializationValues);
                    Method ginstmeth = jssCryptoManager.getMethod("getInstance", new Class[0]);
                    Object cm = ginstmeth.invoke(null, (Object[])null);
                    Class<?> jssPasswordCallback = Class.forName("org.mozilla.jss.util.PasswordCallback", true, ClassLoader.getSystemClassLoader());
                    Method setPasswordCallbackMethod = jssCryptoManager.getMethod("setPasswordCallback", jssPasswordCallback);
                    JSSPasswordCallbackInvocationHandler handler = new JSSPasswordCallbackInvocationHandler();
                    Class<?> proxyClass = Proxy.getProxyClass(ClassLoader.getSystemClassLoader(), jssPasswordCallback);
                    Object passwordCallback = proxyClass.getConstructor(InvocationHandler.class).newInstance(handler);
                    setPasswordCallbackMethod.invoke(cm, passwordCallback);
                    cryptoManager = cm;
                    Trace.msgSecurityPrintln("browserkeystore.jss.yes");
                }
                catch (ClassNotFoundException cnfe) {
                    Trace.msgSecurityPrintln("browserkeystore.jss.no");
                    return null;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    Trace.msgSecurityPrintln("browserkeystore.jss.no");
                    return null;
                }
            }
        }
        return cryptoManager;
    }

    public static boolean isJSSCryptoConfigured() {
        return BrowserKeystore.getJSSCryptoManager() != null;
    }

    private static class JSSPasswordCallbackInvocationHandler
    implements InvocationHandler {
        private HashMap<String, Integer> passwordAttempts = new HashMap();

        private JSSPasswordCallbackInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (args != null && args[0] != null) {
                Object passwordCallbackInfo = args[0];
                Class<?> clazzPasswordCallbackInfo = passwordCallbackInfo.getClass();
                Method getNameMethod = clazzPasswordCallbackInfo.getMethod("getName", new Class[0]);
                String tokenName = (String)getNameMethod.invoke(passwordCallbackInfo, (Object[])null);
                String methodName = method.getName();
                Integer attempts = this.passwordAttempts.get(tokenName);
                if (attempts == null || attempts < 2) {
                    if (attempts == null) {
                        this.passwordAttempts.put(tokenName, 1);
                    } else {
                        this.passwordAttempts.put(tokenName, attempts + 1);
                    }
                    char[] pwArray = this.getPasswordDialog(tokenName);
                    Class<?> clazzPassword = Class.forName("org.mozilla.jss.util.Password", true, ClassLoader.getSystemClassLoader());
                    Class[] argClass = new Class[]{char[].class};
                    Constructor<?> passwordConstructor = clazzPassword.getConstructor(argClass);
                    if (pwArray != null) {
                        Object[] arglist = new Object[]{pwArray};
                        return passwordConstructor.newInstance(arglist);
                    }
                }
            }
            Class<?> jssPasswordCallbackGiveUpException = Class.forName("org.mozilla.jss.util.PasswordCallback$GiveUpException", true, ClassLoader.getSystemClassLoader());
            throw (Throwable)jssPasswordCallbackGiveUpException.newInstance();
        }

        private char[] getPasswordDialog(String tokenName) {
            String dialogMsg = ResourceManager.getString("browserkeystore.password.dialog.text", tokenName);
            CredentialInfo passwordInfo = ToolkitStore.getUI().showPasswordDialog(null, ResourceManager.getString("password.dialog.title"), dialogMsg, false, false, null, false, null);
            if (passwordInfo == null) {
                return null;
            }
            return passwordInfo.getPassword();
        }
    }
}

