/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.registration;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.JCPConfig;
import com.sun.deploy.config.Platform;
import com.sun.deploy.config.SecuritySettings;
import com.sun.deploy.registration.InstallCommands;
import com.sun.deploy.registration.InstallHints;
import com.sun.deploy.security.DeploySigningCertStore;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.Property;
import java.io.File;
import java.io.FileOutputStream;

public class RegisterDeploy {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        InstallCommands retIC;
        InstallCommands retIC2;
        int ret;
        InstallHints ih;
        if (args.length == 2 && args[0].equals("-setSecurityLevel")) {
            try {
                int regFxLevel = Integer.parseInt(args[1]);
                if (regFxLevel > 0 && regFxLevel <= 2) {
                    int SecuritySettingsLevel = 2 - regFxLevel;
                    ih = new InstallHints(1);
                    ih.setCustomSecurityLevel(SecuritySettingsLevel);
                    RegisterDeploy.register(ih);
                }
            }
            catch (NumberFormatException nfe) {
                Trace.ignoredException(nfe);
            }
            finally {
                System.exit(0);
            }
        }
        if (args.length == 1 && args[0].equals("-getSecurityLevel")) {
            Config.setInstance(new JCPConfig());
            ret = SecuritySettings.getSecurityLevelInt();
            System.exit(ret);
        }
        if (args.length == 1 && args[0].equals("-getUserWebJavaStatus")) {
            Config.setInstance(new JCPConfig());
            ret = -1;
            InstallHints ih2 = new InstallHints(2);
            ih2.enableUserWebJavaStatusQuery();
            retIC2 = RegisterDeploy.register(ih2);
            ret = retIC2.getUserWebJavaStatus();
            System.exit(ret);
        }
        if (args.length == 2 && args[0].equals("-setUserWebJavaStatus")) {
            boolean enabled = Integer.parseInt(args[1]) == 1;
            InstallHints ih3 = new InstallHints(1);
            ih3.setWebJavaEnabled(enabled);
            retIC2 = RegisterDeploy.register(ih3);
            if (retIC2.getInstallStatus() == 0) {
                System.exit(0);
            }
            System.exit(1);
        }
        if (args.length == 2 && args[0].equals("-getUserPreviousDecisionsExist")) {
            ret = -1;
            try {
                int daysOld = Integer.parseInt(args[1]);
                ih = new InstallHints(2);
                ih.enableUserPreviousDecisionsExistQuery(daysOld);
                retIC = RegisterDeploy.register(ih);
                ret = retIC.getUserPreviousDecisionsExist();
            }
            catch (NumberFormatException nfe) {
                Trace.ignoredException(nfe);
            }
            finally {
                System.exit(ret);
            }
        }
        if (args.length == 2 && args[0].equals("-clearUserPreviousDecisions")) {
            ret = -1;
            try {
                int daysOld = Integer.parseInt(args[1]);
                ih = new InstallHints(2);
                ih.clearUserPreviousDecisionsQuery(daysOld);
                retIC = RegisterDeploy.register(ih);
                ret = retIC.getClearUserPreviousDecisionsResult();
            }
            catch (NumberFormatException nfe) {
                Trace.ignoredException(nfe);
            }
            finally {
                System.exit(ret);
            }
        }
        if (args.length == 1 && args[0].equals("-resetUserPreviousDecisionsDate")) {
            ret = -1;
            InstallHints ih4 = new InstallHints(2);
            ih4.resetUserPrevousDecisionsDate();
            retIC2 = RegisterDeploy.register(ih4);
            if (retIC2.getInstallStatus() != 1) {
                ret = 0;
            }
            System.exit(ret);
        }
        if ((args.length == 2 || args.length == 3) && args[0].equals("-systemConfig")) {
            String key = args[1];
            int ret2 = -1;
            String value = args.length == 3 ? args[2] : null;
            InstallHints ih5 = new InstallHints(2);
            ih5.setSystemDeploymentProperty(new Property(key, value));
            InstallCommands retIC3 = RegisterDeploy.register(ih5);
            if (retIC3.getInstallStatus() != 1) {
                ret2 = 0;
            }
            System.exit(ret2);
        }
        if ((args.length == 2 || args.length == 3) && args[0].equals("-userConfig")) {
            String prop = args[1];
            try {
                String value = args.length == 3 ? args[2] : null;
                JCPConfig cfg = new JCPConfig();
                Config.setInstance(cfg);
                Config.setStringProperty(prop, value);
                cfg.storeConfig();
            }
            finally {
                System.exit(0);
            }
        }
    }

    private RegisterDeploy() {
    }

    public static final InstallCommands register(InstallHints hints) {
        InstallCommands retIC = null;
        if (hints == null) {
            return retIC;
        }
        if (hints.getInstallType() == 2) {
            return RegisterDeploy.registerQuery(hints);
        }
        if (hints.getInstallType() == 1) {
            retIC = RegisterDeploy.registerConfig(hints);
        }
        return retIC;
    }

    private static final InstallCommands registerQuery(InstallHints hints) {
        Property systemDeploymentProperty;
        int ret;
        int daysOld;
        InstallCommands retIC = new InstallCommands();
        if (hints.getUserWebJavaStatusQuery()) {
            if (Platform.get().getWebJavaSwitch().queryWebJavaState() == Platform.WebJavaSwitch.WebJavaState.ENABLED) {
                retIC.setUserWebJavaStatus(11);
            } else {
                retIC.setUserWebJavaStatus(0);
            }
        }
        if (hints.getUserPreviousDecisionsExistQuery() != -1) {
            daysOld = hints.getUserPreviousDecisionsExistQuery();
            ret = RegisterDeploy.getUserPreviousDecisionsExist(daysOld);
            retIC.setUserPreviousDecisionsExist(ret);
        }
        if (hints.getClearUserPreviousDecisionsQuery() != -1) {
            daysOld = hints.getClearUserPreviousDecisionsQuery();
            ret = RegisterDeploy.clearUserPreviousDecisions(daysOld);
            retIC.setClearUserPreviousDecisionsResult(ret);
        }
        if (hints.getResetUserPrevousDecisionsDateQuery() && !RegisterDeploy.resetUserPrevousDecisionsDate()) {
            retIC.setInstallStatus(1);
        }
        if ((systemDeploymentProperty = hints.getSystemDeploymentProperty()) != null && !RegisterDeploy.setSystemDeploymentProperty(systemDeploymentProperty)) {
            retIC.setInstallStatus(1);
        }
        return retIC;
    }

    private static final InstallCommands registerConfig(InstallHints hints) {
        InstallCommands retIC = new InstallCommands();
        if (hints.getWebJavaEnabled() != -1 && !RegisterDeploy.setWebJavaEnabled(hints.getWebJavaEnabled() == 1)) {
            retIC.setInstallStatus(1);
        }
        if (hints.getCustomSecurityLevel() != -1 && !RegisterDeploy.setSystemSecurityLevel(hints.getCustomSecurityLevel())) {
            retIC.setInstallStatus(1);
        }
        return retIC;
    }

    private static final int getUserPreviousDecisionsExist(int daysOld) {
        if (DeploySigningCertStore.checkStoredCertificates(1, daysOld, false, false)) {
            return 11;
        }
        if (DeploySigningCertStore.checkStoredCertificates(4, daysOld, false, false)) {
            return 11;
        }
        return 0;
    }

    private static final int clearUserPreviousDecisions(int daysOld) {
        boolean userRet = DeploySigningCertStore.checkStoredCertificates(1, daysOld, true, false);
        boolean sandboxRet = DeploySigningCertStore.checkStoredCertificates(4, daysOld, true, false);
        return userRet || sandboxRet ? 11 : 0;
    }

    private static final boolean resetUserPrevousDecisionsDate() {
        boolean userRet = DeploySigningCertStore.checkStoredCertificates(1, 0, false, true);
        boolean sandboxRet = DeploySigningCertStore.checkStoredCertificates(4, 0, false, true);
        return userRet || sandboxRet;
    }

    private static boolean setSystemDeploymentProperty(Property property) {
        if (!RegisterDeploy.hasSystemConfigAccess()) {
            System.out.println("user has no access to system settings");
            return false;
        }
        return SecuritySettings.setSystemDeploymentProperty(property.getKey(), property.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final boolean hasSystemConfigAccess() {
        boolean createdTempFile = false;
        File f = null;
        try {
            File systemHomeDir = new File(Config.getSystemHome());
            systemHomeDir.mkdirs();
            f = new File(Config.getSystemHome() + File.separator + Config.getPropertiesFilename());
            createdTempFile = f.createNewFile();
            if (!f.canWrite()) {
                boolean bl = false;
                return bl;
            }
            new FileOutputStream(f, true).close();
        }
        catch (Throwable t) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (f != null && createdTempFile) {
                f.delete();
            }
        }
        return true;
    }

    private static final boolean setSystemSecurityLevel(int level) {
        if (level < 0 || level >= SecuritySettings.SECURITY_LEVELS.length) {
            System.out.println("unsupported security level: " + level);
            System.out.println("support level is 0   (high), 1 (very high)");
            return false;
        }
        if (!RegisterDeploy.hasSystemConfigAccess()) {
            System.out.println("user has no access to system settings");
            return false;
        }
        SecuritySettings.setInstallerRecommendedSecurityLevel(level);
        return true;
    }

    private static final boolean setWebJavaEnabled(boolean enabled) {
        if (!RegisterDeploy.hasSystemConfigAccess()) {
            System.out.println("user has no access to system settings");
            return false;
        }
        Platform.get().getWebJavaSwitch().setWebJavaEnabled(enabled);
        return true;
    }
}

