/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ref;

import com.sun.deploy.config.ClientConfig;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.SecuritySettings;
import com.sun.deploy.ref.DeployJRE;
import java.util.ArrayList;

public class DeployConfig {
    public static boolean setDeployProperty(String key, String value, boolean system) {
        try {
            if (system) {
                return SecuritySettings.setSystemDeploymentProperty(key, value);
            }
            if (Config.getInstance() == null) {
                Config.setInstance(new ClientConfig());
            }
            Config.setStringProperty(key, value);
            Config.get().storeIfNeeded();
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static String getDeployProperty(String key) {
        if (Config.getInstance() == null) {
            Config.setInstance(new ClientConfig());
        }
        return Config.getStringProperty(key);
    }

    public static DeployJRE[] getDeployJREs() {
        Config config;
        if (Config.getInstance() == null) {
            Config.setInstance(new ClientConfig());
        }
        if ((config = Config.getInstance()) instanceof ClientConfig) {
            ((ClientConfig)config).refreshUnchangedProps();
        }
        JREInfo[] jreInfo = JREInfo.getAll();
        ArrayList<DeployJRE> jres = new ArrayList<DeployJRE>();
        for (JREInfo info : jreInfo) {
            DeployJRE jre = new DeployJRE(info);
            if (jres.contains(jre)) continue;
            jres.add(jre);
        }
        return jres.toArray(new DeployJRE[0]);
    }

    public static boolean setDeployJREVmArgs(String path, String vmArgs) {
        JREInfo[] all;
        if (Config.getInstance() == null) {
            Config.setInstance(new ClientConfig());
        }
        for (JREInfo info : all = JREInfo.getAll()) {
            if (path == null || !path.equals(info.getPath())) continue;
            try {
                info.setVmArgs(vmArgs);
                ((ClientConfig)Config.get()).storeConfig();
                return true;
            }
            catch (Throwable t) {
                return false;
            }
        }
        return false;
    }

    public static boolean setDeployJREEnabled(String path, boolean enabled) {
        JREInfo[] all;
        if (Config.getInstance() == null) {
            Config.setInstance(new ClientConfig());
        }
        for (JREInfo info : all = JREInfo.getAll()) {
            if (path == null || !path.equals(info.getPath())) continue;
            try {
                info.setEnabled(enabled);
                ((ClientConfig)Config.get()).storeConfig();
                return true;
            }
            catch (Throwable t) {
                return false;
            }
        }
        return false;
    }
}

