/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy;

import com.sun.deploy.net.proxy.BrowserProxyInfo;
import com.sun.deploy.net.proxy.ProxyConfigException;
import com.sun.deploy.net.proxy.ProxyHandler;
import com.sun.deploy.net.proxy.ProxyInfo;
import com.sun.deploy.trace.Trace;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

final class ManualProxyHandler
implements ProxyHandler {
    private BrowserProxyInfo bpi = null;
    private List<Pattern> proxyOverridePatterns = null;

    ManualProxyHandler() {
    }

    @Override
    public boolean isSupported(int proxyType) {
        return proxyType == 1;
    }

    @Override
    public boolean isProxyCacheSupported() {
        return true;
    }

    @Override
    public void init(BrowserProxyInfo info) throws ProxyConfigException {
        Trace.msgNetPrintln("net.proxy.loading.manual");
        if (!this.isSupported(info.getType())) {
            throw new ProxyConfigException("Unable to support proxy type: " + info.getType());
        }
        this.bpi = info;
        this.proxyOverridePatterns = new ArrayList<Pattern>();
        String[] list = this.bpi.getOverrides();
        if (list != null) {
            Trace.msgNetPrintln("net.proxy.pattern.convert");
            for (int i = 0; list != null && i < list.length; ++i) {
                String item = list[i];
                try {
                    if (item.equals("<local>")) {
                        this.proxyOverridePatterns.add(Pattern.compile("[^.]+"));
                        Trace.netPrintln("    <local> --> [^.]+");
                        continue;
                    }
                    Pattern pattern = this.canonicalizePattern(item);
                    this.proxyOverridePatterns.add(pattern);
                    Trace.netPrintln("    " + item + " --> " + pattern.pattern());
                    continue;
                }
                catch (PatternSyntaxException e) {
                    e.printStackTrace();
                    Trace.msgNetPrintln("net.proxy.bypass.convert.error");
                }
            }
        }
        Trace.msgNetPrintln("net.proxy.loading.done");
    }

    @Override
    public ProxyInfo[] getProxyInfo(URL u) {
        String protocol = u.getProtocol();
        String host = u.getHost();
        if (this.isProxyOverriden(host.toUpperCase())) {
            return new ProxyInfo[]{new ProxyInfo(null)};
        }
        String proxyHost = null;
        int proxyPort = -1;
        if (protocol.equals("http")) {
            proxyHost = this.bpi.getHttpHost();
            proxyPort = this.bpi.getHttpPort();
        } else if (protocol.equals("https")) {
            proxyHost = this.bpi.getHttpsHost();
            proxyPort = this.bpi.getHttpsPort();
        } else if (protocol.equals("ftp")) {
            proxyHost = this.bpi.getFtpHost();
            proxyPort = this.bpi.getFtpPort();
        } else if (protocol.equals("gopher")) {
            proxyHost = this.bpi.getGopherHost();
            proxyPort = this.bpi.getGopherPort();
        }
        return new ProxyInfo[]{new ProxyInfo(proxyHost, proxyPort, this.bpi.getSocksHost(), this.bpi.getSocksPort())};
    }

    private Pattern canonicalizePattern(String pattern) throws PatternSyntaxException {
        if (pattern == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c == '*') {
                buffer.append(".*");
                continue;
            }
            buffer.append(Character.toUpperCase(c));
        }
        return Pattern.compile(buffer.toString());
    }

    private boolean isProxyOverriden(String host) {
        for (Pattern pattern : this.proxyOverridePatterns) {
            Matcher matcher = pattern.matcher(host);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }
}

