/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net;

import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLPermission;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;
import sun.net.www.protocol.http.HttpURLConnection;

public class CrossDomainXML {
    static final String ALT_XDOMAIN_FILES = "jnlp.altCrossDomainXMLFiles";
    public static final int CHECK_RESOLVE = -1;
    public static final int CHECK_SET_HOST = -2;
    public static final int CHECK_SUBPATH = -3;
    public static final int CHECK_CONNECT = -4;
    private static final AccessControlContext noPermissionACC = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, null)});
    private static final AccessControlContext onlyConnectACC;
    private static final ReentrantLock lock;
    private static final int NO_ACCESS = 0;
    private static final int URL_CONNECTIONS = 1;
    private static final int SOCKET_CONNECTIONS = 2;
    private static final Map<String, Integer> domains;
    private static final Map<String, List<URL>> allowedURLs;
    private static List<URL> alternateURLs;
    private static String POLICY_FILE_PATH;
    private static final String DTD_DOWNLOAD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static final String DTD_VALIDATION = "http://xml.org/sax/features/validation";
    private static final String EXTERNAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String EXTERNAL_PARAMETERS = "http://xml.org/sax/features/external-parameter-entities";

    private CrossDomainXML() {
    }

    private static boolean isProcessed(String host, int port) {
        return domains.containsKey(CrossDomainXML.getDomainID(host, port));
    }

    private static boolean hasURLLevelAccess(String host, int port) {
        Integer accessLevel = domains.get(CrossDomainXML.getDomainID(host, port));
        return accessLevel != null && accessLevel != 0;
    }

    private static boolean hasSocketLevelAccess(String host, int port) {
        Integer accessLevel = domains.get(CrossDomainXML.getDomainID(host, port));
        return accessLevel != null && accessLevel == 2;
    }

    private static void allowNoAccess(String host, int port) {
        CrossDomainXML.addAccess(host, port, 0);
    }

    private static void allowURLLevelAccess(String host, int port) {
        CrossDomainXML.addAccess(host, port, 1);
    }

    private static void allowSocketLevelAccess(String host, int port) {
        CrossDomainXML.addAccess(host, port, 2);
    }

    private static String getDomainID(String host, int port) {
        if (!((String)(host = ((String)host).toLowerCase())).startsWith("[") && ((String)host).indexOf(58) != -1) {
            host = "[" + (String)host + "]";
        }
        return (String)host + ":" + port;
    }

    private static void addAccess(String host, int port, Integer accessLevel) {
        String ipDomainID;
        InetAddress ip;
        String domainID;
        block4: {
            domainID = CrossDomainXML.getDomainID(host, port);
            CrossDomainXML.doAddAccess(domainID, accessLevel);
            ip = null;
            try {
                ip = InetAddress.getByName(host);
            }
            catch (AccessControlException accessControlException) {
            }
            catch (Throwable t) {
                Trace.ignored(t);
                if (!(t instanceof ThreadDeath)) break block4;
                throw (ThreadDeath)t;
            }
        }
        if (ip != null && !domainID.equals(ipDomainID = CrossDomainXML.getDomainID(ip.getHostAddress(), port))) {
            CrossDomainXML.doAddAccess(ipDomainID, accessLevel);
        }
    }

    private static void doAddAccess(String domainID, Integer accessLevel) {
        Integer oldAccessLevel = domains.get(domainID);
        if (oldAccessLevel == null || oldAccessLevel < accessLevel) {
            domains.put(domainID, accessLevel);
        }
    }

    private static URL getMasterPolicyFileURL(String protocol, String host, int port) throws MalformedURLException {
        return new URL(protocol, host, port, POLICY_FILE_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean check(Class<?>[] context, URL url, String host, int port, boolean socketLevelAccessRequired) {
        try {
            lock.lock();
            try {
                if (CrossDomainXML.quickFullCheck(context, url, host, port, socketLevelAccessRequired)) {
                    boolean bl = true;
                    return bl;
                }
                boolean changed = false;
                ArrayList<URL> urls = new ArrayList<URL>();
                String protocol = url != null ? url.getProtocol() : "http";
                if (!CrossDomainXML.isProcessed(host, port)) {
                    urls.add(CrossDomainXML.getMasterPolicyFileURL(protocol, host, port));
                }
                List<URL> altURLs = CrossDomainXML.getAlternatePolicyFilesURLs();
                for (URL cur : altURLs) {
                    int curPort = cur.getPort();
                    if (curPort == -1) {
                        curPort = cur.getDefaultPort();
                    }
                    if (!protocol.equalsIgnoreCase(cur.getProtocol()) || !host.equalsIgnoreCase(cur.getHost()) || port != curPort) continue;
                    urls.add(cur);
                }
                for (URL cur : urls) {
                    if (!CrossDomainXML.check(cur)) {
                        CrossDomainXML.allowNoAccess(host, port);
                        continue;
                    }
                    if (cur.getPath().equals("/crossdomain.xml")) {
                        CrossDomainXML.allowSocketLevelAccess(host, port);
                    } else {
                        CrossDomainXML.allowURLLevelAccess(host, port);
                    }
                    String domainID = CrossDomainXML.getDomainID(host, port);
                    List<URL> list = allowedURLs.get(domainID);
                    if (list == null) {
                        list = new ArrayList<URL>();
                        list.add(cur);
                        allowedURLs.put(domainID, list);
                    } else {
                        list.add(cur);
                    }
                    changed = true;
                }
                if (!changed) return false;
                if (!CrossDomainXML.quickFullCheck(context, url, host, port, socketLevelAccessRequired)) return false;
                boolean bl = true;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }
        catch (Throwable t) {
            Trace.ignored(t);
            if (!(t instanceof ThreadDeath)) return false;
            throw (ThreadDeath)t;
        }
    }

    private static boolean quickFullCheck(Class<?>[] context, URL url, String host, int port, boolean socketLevelAccessRequired) {
        String domainID;
        List<URL> list;
        if (CrossDomainXML.quickCheck(context, host, port)) {
            return true;
        }
        if (socketLevelAccessRequired) {
            return false;
        }
        if (!CrossDomainXML.hasURLLevelAccess(host, port)) {
            return false;
        }
        if (!CrossDomainXML.checkContext(context, HttpURLConnection.class)) {
            return false;
        }
        return url == null || CrossDomainXML.checkSubpath(url, list = allowedURLs.get(domainID = CrossDomainXML.getDomainID(host, port)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean quickCheck(Class<?>[] context, String host, int port) {
        if (port == -1 && CrossDomainXML.checkContext(context, Socket.class)) {
            return true;
        }
        lock.lock();
        try {
            if (CrossDomainXML.hasSocketLevelAccess(host, port)) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            lock.unlock();
        }
        return false;
    }

    private static boolean checkContext(Class<?>[] context, Class<?> ctxClass) {
        for (int i = 0; i < context.length; ++i) {
            if (context[i].getClassLoader() != null) {
                if (i <= 0) continue;
                return false;
            }
            if (!ctxClass.isAssignableFrom(context[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean checkSubpath(URL url, List<URL> urls) {
        String path = url.getPath();
        if (path == "") {
            path = "/";
        }
        for (URL cur : urls) {
            String prefix;
            int index;
            String parentPath = cur.getPath();
            if (parentPath == "") {
                parentPath = "/";
            }
            if ((index = parentPath.lastIndexOf(47)) == -1 || !path.startsWith(prefix = parentPath.substring(0, index + 1))) continue;
            return true;
        }
        return false;
    }

    private static List<URL> getAlternatePolicyFilesURLs() {
        block7: {
            if (alternateURLs == null) {
                alternateURLs = new ArrayList<URL>();
                try {
                    String urlList = AccessController.doPrivileged(new PrivilegedAction<String>(){

                        @Override
                        public String run() {
                            return System.getProperty(CrossDomainXML.ALT_XDOMAIN_FILES);
                        }
                    });
                    if (urlList != null) {
                        String[] urls;
                        for (String tmpUrl : urls = urlList.split(",")) {
                            if (tmpUrl == null) continue;
                            try {
                                URL tmp = new URL(tmpUrl);
                                if (!"http".equalsIgnoreCase(tmp.getProtocol()) && !"https".equalsIgnoreCase(tmp.getProtocol())) continue;
                                alternateURLs.add(tmp);
                            }
                            catch (MalformedURLException malformedURLException) {
                                // empty catch block
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    if (!(t instanceof ThreadDeath)) break block7;
                    throw (ThreadDeath)t;
                }
            }
        }
        return alternateURLs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean check(URL policyFileURL) {
        block19: {
            try {
                Handler handler;
                block18: {
                    handler = new Handler();
                    try {
                        int i2;
                        URLConnection conn = policyFileURL.openConnection();
                        int lockCount = lock.getHoldCount();
                        try {
                            for (i2 = 0; i2 < lockCount; ++i2) {
                                lock.unlock();
                            }
                        }
                        catch (IllegalMonitorStateException i2) {
                            // empty catch block
                        }
                        try {
                            CrossDomainXML.privilegedConnect(conn);
                        }
                        finally {
                            for (i2 = 0; i2 < lockCount; ++i2) {
                                lock.lock();
                            }
                        }
                        final SAXParser parser = CrossDomainXML.getParser();
                        InputStream rawIn = conn.getInputStream();
                        try (final BufferedInputStream in = new BufferedInputStream(rawIn);){
                            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                                @Override
                                public Void run() throws SAXException, IOException {
                                    parser.parse(in, (DefaultHandler)handler);
                                    return null;
                                }
                            }, noPermissionACC);
                        }
                    }
                    catch (FileNotFoundException conn) {
                    }
                    catch (NoSuchMethodError e2) {
                        if (!Trace.isEnabled()) break block18;
                        Trace.msgNetPrintln("CrossDomainXML: cannot parse crossdomain.xml. You may be running in a JRE older than version 6.0");
                    }
                }
                return handler.isAllowed();
            }
            catch (Exception e) {
                Trace.ignoredException(e);
            }
            catch (Throwable t) {
                if (!Trace.isEnabled()) break block19;
                t.printStackTrace();
            }
        }
        return false;
    }

    private static void privilegedConnect(final URLConnection connection) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    connection.connect();
                    return null;
                }
            }, onlyConnectACC);
        }
        catch (PrivilegedActionException exc) {
            Exception cause = exc.getException();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new Error(exc);
        }
    }

    static SAXParser getParser() throws SAXNotRecognizedException, ParserConfigurationException, SAXNotSupportedException, SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance("com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl", null);
        factory.setFeature(DTD_DOWNLOAD, false);
        factory.setFeature(DTD_VALIDATION, false);
        factory.setFeature(EXTERNAL_ENTITIES, false);
        factory.setFeature(EXTERNAL_PARAMETERS, false);
        return factory.newSAXParser();
    }

    static void resetForUnitTests() {
        domains.clear();
        allowedURLs.clear();
        alternateURLs = null;
    }

    private static boolean checkFile(final String filename) {
        block3: {
            try {
                final Handler handler = new Handler();
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        block3: {
                            try {
                                SAXParser parser = CrossDomainXML.getParser();
                                parser.parse(new File(filename), (DefaultHandler)handler);
                            }
                            catch (FileNotFoundException parser) {
                            }
                            catch (NoSuchMethodError e2) {
                                if (!Trace.isEnabled()) break block3;
                                Trace.msgNetPrintln("CrossDomainXML: cannot parse crossdomain.xml. You may be running in a JRE older than version 6.0");
                            }
                        }
                        return null;
                    }
                });
                return handler.isAllowed();
            }
            catch (Exception e) {
                Trace.ignoredException(e);
            }
            catch (Throwable t) {
                if (!Trace.isEnabled()) break block3;
                t.printStackTrace();
            }
        }
        return false;
    }

    public static void main(String[] args) {
        for (String arg : args) {
            System.out.println(arg + ": " + (CrossDomainXML.check(new Class[0], null, arg, -1, false) ? "Allowed" : "Denied"));
        }
    }

    static {
        Permissions perms = new Permissions();
        ((PermissionCollection)perms).add(new SocketPermission("*", "connect"));
        if (Config.isJavaVersionAtLeast18()) {
            ((PermissionCollection)perms).add(new URLPermission("http:*", "*:*"));
            ((PermissionCollection)perms).add(new URLPermission("https:*", "*:*"));
        }
        ((PermissionCollection)perms).add(new RuntimePermission("modifyThread"));
        ((PermissionCollection)perms).add(new RuntimePermission("modifyThreadGroup"));
        onlyConnectACC = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
        lock = new ReentrantLock();
        domains = new HashMap<String, Integer>();
        allowedURLs = new HashMap<String, List<URL>>();
        POLICY_FILE_PATH = "/crossdomain.xml";
    }

    private static class Handler
    extends DefaultHandler {
        private static final int INITIAL = 0;
        private static final int IN_CROSS_DOMAIN_POLICY = 1;
        private static final int ALLOWED = 2;
        private static final int DENIED = 3;
        private static final int UNKNOWN = 4;
        private int depth = 0;
        private int state = 0;
        private int result = 4;

        private Handler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            ++this.depth;
            switch (this.state) {
                case 0: {
                    if (this.depth != 1 || !qName.equals("cross-domain-policy")) break;
                    this.state = 1;
                    break;
                }
                case 1: {
                    if (this.depth != 2) break;
                    if (qName.equals("allow-access-from")) {
                        String grantedDomains = attributes.getValue("domain");
                        if (grantedDomains.equals("*") && this.result == 4) {
                            this.result = 2;
                            break;
                        }
                        this.result = 3;
                        break;
                    }
                    if (qName.equals("site-control")) {
                        String policy = attributes.getValue("permitted-cross-domain-policies");
                        if (policy == null || policy.equals("none")) {
                            this.result = 3;
                            break;
                        }
                        if (policy.equals("master-only") || policy.equals("by-content-type") || policy.equals("by-ftp-filename") || policy.equals("all")) break;
                        this.result = 3;
                        break;
                    }
                    this.state = 0;
                    break;
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            --this.depth;
        }

        public boolean isAllowed() {
            return this.result == 2;
        }
    }
}

