/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.resources.ResourceManager;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.jnlp.FileContents;
import javax.jnlp.JNLPRandomAccessFile;

public final class JNLPRandomAccessFileImpl
implements JNLPRandomAccessFile {
    private RandomAccessFile _raf = null;
    private FileContents _contents = null;
    private long _length = 0L;
    private String _message = null;

    JNLPRandomAccessFileImpl(File file, String string, FileContents fileContents) throws IOException {
        this._raf = new RandomAccessFile(file, string);
        this._length = this._raf.length();
        this._contents = fileContents;
        if (this._contents == null) {
            throw new IllegalArgumentException("FileContents can not be null");
        }
        if (this._message == null) {
            this._message = ResourceManager.getString((String)"api.persistence.filesizemessage");
        }
    }

    @Override
    public void close() throws IOException {
        this._raf.close();
    }

    @Override
    public long length() throws IOException {
        return this._raf.length();
    }

    @Override
    public long getFilePointer() throws IOException {
        return this._raf.getFilePointer();
    }

    @Override
    public int read() throws IOException {
        return this._raf.read();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this._raf.read(byArray, n, n2);
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this._raf.read(byArray);
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        this._raf.readFully(byArray);
    }

    @Override
    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this._raf.readFully(byArray, n, n2);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this._raf.skipBytes(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this._raf.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this._raf.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this._raf.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        return this._raf.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this._raf.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        return this._raf.readChar();
    }

    @Override
    public int readInt() throws IOException {
        return this._raf.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this._raf.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this._raf.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this._raf.readDouble();
    }

    @Override
    public String readLine() throws IOException {
        return this._raf.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        return this._raf.readUTF();
    }

    @Override
    public void seek(long l) throws IOException {
        this._raf.seek(l);
    }

    @Override
    public void setLength(long l) throws IOException {
        if (l > this._contents.getMaxLength()) {
            throw new IOException(this._message);
        }
        this._raf.setLength(l);
    }

    @Override
    public void write(int n) throws IOException {
        this.checkWrite(1);
        this._raf.write(n);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        if (byArray != null) {
            this.checkWrite(byArray.length);
        }
        this._raf.write(byArray);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.checkWrite(n2);
        this._raf.write(byArray, n, n2);
    }

    @Override
    public void writeBoolean(boolean bl) throws IOException {
        this.checkWrite(1);
        this._raf.writeBoolean(bl);
    }

    @Override
    public void writeByte(int n) throws IOException {
        this.checkWrite(1);
        this._raf.writeByte(n);
    }

    @Override
    public void writeShort(int n) throws IOException {
        this.checkWrite(2);
        this._raf.writeShort(n);
    }

    @Override
    public void writeChar(int n) throws IOException {
        this.checkWrite(2);
        this._raf.writeChar(n);
    }

    @Override
    public void writeInt(int n) throws IOException {
        this.checkWrite(4);
        this._raf.writeInt(n);
    }

    @Override
    public void writeLong(long l) throws IOException {
        this.checkWrite(8);
        this._raf.writeLong(l);
    }

    @Override
    public void writeFloat(float f) throws IOException {
        this.checkWrite(4);
        this._raf.writeFloat(f);
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.checkWrite(8);
        this._raf.writeDouble(d);
    }

    @Override
    public void writeBytes(String string) throws IOException {
        if (string != null) {
            this.checkWrite(string.length());
        }
        this._raf.writeBytes(string);
    }

    @Override
    public void writeChars(String string) throws IOException {
        if (string != null) {
            this.checkWrite(string.length() * 2);
        }
        this._raf.writeChars(string);
    }

    @Override
    public void writeUTF(String string) throws IOException {
        if (string != null) {
            this.checkWrite(this.getUTFLen(string));
        }
        this._raf.writeUTF(string);
    }

    private int getUTFLen(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int n2 = 2;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c >= '\u0001' && c <= '\u007f') {
                ++n2;
                continue;
            }
            if (c > '\u07ff') {
                n2 += 3;
                continue;
            }
            n2 += 2;
        }
        return n2;
    }

    private void checkWrite(int n) throws IOException {
        if (n < 0 || this._contents.getMaxLength() - this._raf.getFilePointer() < (long)n) {
            throw new IOException(this._message);
        }
    }
}

