/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.util;

import com.sun.applet2.AppletParameters;
import com.sun.deploy.Environment;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.JfxRuntime;
import com.sun.deploy.config.OSType;
import com.sun.deploy.config.Platform;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.JVMParameters;
import com.sun.deploy.util.VersionID;
import java.io.File;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.plugin2.main.client.ClientJVMSelectionParameters;
import sun.plugin2.util.BrowserType;

public class PluginJVMUtil {
    static boolean DEBUG = Config.getDebug();
    private static final String JAVA_EXT_DIRS = "-Djava.ext.dirs=";
    private static final String TRUSTED_DIR = File.separator + "lib" + File.separator + "trusted";

    private static String getVmArgs(JREInfo jREInfo) {
        String string = Environment.getenv((String)"FORCED_CLIENTVM_ARGS");
        if (DEBUG && string != null) {
            System.out.println("JVMManager: using override from FORCED_CLIENTVM_ARGS" + string);
        }
        if (string == null) {
            string = Environment.getenv((String)"_JPI_VM_OPTIONS");
        }
        if (string != null) {
            return string;
        }
        return jREInfo.getVmArgs();
    }

    public static JVMParameters getDefaultVmArgs(JREInfo jREInfo) {
        JVMParameters jVMParameters = new JVMParameters();
        jVMParameters.parseTrustedOptions(PluginJVMUtil.getVmArgs(jREInfo));
        jVMParameters.setDefault(true);
        return jVMParameters;
    }

    public static JVMParameters extractAppletParamsToJVMParameters(AppletParameters appletParameters, String string, boolean bl, boolean bl2) {
        JVMParameters jVMParameters = new JVMParameters();
        jVMParameters.addInternalArgument("-Djava.class.path=" + Config.getJREHome() + File.separator + "classes");
        String string2 = (String)appletParameters.get((Object)"__applet_session_data");
        if (string2 != null && bl) {
            jVMParameters.addInternalArgument("-Djnlpx.session.data=" + string2);
        }
        jVMParameters.setDefault(true);
        String string3 = (String)appletParameters.get((Object)"java_arguments");
        if (string3 != null) {
            jVMParameters.setIncludeExtendedASCIIValues(bl2);
            jVMParameters.setHtmlJavaArgs(true);
            jVMParameters.addEncodedArguments(string3, false, false, !bl);
        } else {
            jVMParameters.setHtmlJavaArgs(false);
        }
        if (OSType.isMac()) {
            PluginJVMUtil.scopeJVMInstanceByHost(PluginJVMUtil.getURLHost(string), jVMParameters);
        }
        return jVMParameters;
    }

    private static String getURLHost(String string) {
        if (string != null) {
            try {
                URI uRI = new URI(string);
                return uRI.getHost();
            }
            catch (Exception exception) {
                Trace.ignored((Throwable)exception);
            }
        }
        return null;
    }

    public static JVMParameters prepareJVMParameter(JVMParameters jVMParameters, JREInfo jREInfo, JVMParameters jVMParameters2, ClientJVMSelectionParameters clientJVMSelectionParameters, boolean bl) {
        JVMParameters jVMParameters3 = new JVMParameters();
        VersionID versionID = clientJVMSelectionParameters.getJfxRequirement();
        boolean bl2 = false;
        JfxRuntime jfxRuntime = null;
        if (null != versionID) {
            if (DEBUG) {
                System.out.println("Need JavaFX version: " + versionID);
            }
            if (!jREInfo.getProductVersion().isGreaterThanOrEqual(ClientJVMSelectionParameters.JFX_JRE_MINIMUM_VER)) {
                if (DEBUG) {
                    System.out.println("JavaFX requires minimum JRE version: " + ClientJVMSelectionParameters.JFX_JRE_MINIMUM_VER);
                }
                return null;
            }
            jfxRuntime = jREInfo.getJfxRuntime();
            if (jfxRuntime == null) {
                System.out.println("Launching in a vanilla JVM to install JavaFX and relaunch.");
            } else {
                if (!clientJVMSelectionParameters.useJfxToolkit()) {
                    jVMParameters3.addInternalArgument("-Djnlp.tk=awt");
                } else {
                    bl2 = true;
                }
                jVMParameters3.addInternalArgument("-Djnlp.fx=" + jfxRuntime.getProductVersion().toString());
            }
        }
        if (DEBUG) {
            System.out.println("    JVMManager.createJVMInstance passing along JVM parameters from deployment.properties");
        }
        jVMParameters3.addArguments(jVMParameters2);
        if (DEBUG) {
            System.out.println("    JVMManager.createJVMInstance passing along JVM parameters from this applet instance");
        }
        PluginJVMUtil.addClassPath(jVMParameters, jREInfo);
        jVMParameters3.addArguments(jVMParameters);
        jVMParameters3.setHtmlJavaArgs(jVMParameters.isHtmlJavaArgs());
        PluginJVMUtil.maintainCurrentArchFlag(jVMParameters3, jREInfo);
        PluginJVMUtil.addJavaExtDirsOption(jVMParameters3);
        PluginJVMUtil.addXToolkitOption(jVMParameters3, jREInfo.getProductVersion());
        PluginJVMUtil.addUIElementOption(jVMParameters3);
        if (!bl2) {
            jVMParameters3.addInternalArgument("-Dsun.awt.warmup=true");
        }
        return jVMParameters3;
    }

    private static void addClassPath(JVMParameters jVMParameters, JREInfo jREInfo) {
        if (!jREInfo.isModularJRE()) {
            jVMParameters.parseBootClassPath(JVMParameters.getPlugInDependentJars());
        }
    }

    private static void scopeJVMInstanceByHost(String string, JVMParameters jVMParameters) {
        String string2;
        String string3;
        if (string != null) {
            jVMParameters.addInternalArgument("-Djava.applet.host=" + string);
            string3 = ResourceManager.getString((String)"applet.host.app.title", (Object[])new Object[]{string});
        } else {
            string3 = ResourceManager.getString((String)"applet.host.app.title.nohost");
        }
        String string4 = "-Xdock:name=" + string3;
        Charset charset = Charset.forName("UTF-8");
        CharsetDecoder charsetDecoder = charset.newDecoder();
        CharsetEncoder charsetEncoder = charset.newEncoder();
        try {
            ByteBuffer byteBuffer = charsetEncoder.encode(CharBuffer.wrap(string4));
            CharBuffer charBuffer = charsetDecoder.decode(byteBuffer);
            string2 = charBuffer.toString();
        }
        catch (CharacterCodingException characterCodingException) {
            string2 = "-Xdock:name=Java Applet - " + string;
        }
        jVMParameters.addInternalArgument(string2);
        jVMParameters.addInternalArgument("-Xdock:icon=" + Platform.get().getDefaultIconPath());
    }

    private static void maintainCurrentArchFlag(JVMParameters jVMParameters, JREInfo jREInfo) {
        if (OSType.isMac() && !jVMParameters.contains("-d32") && !jVMParameters.contains("-d64")) {
            if ("x86_64".equals(jREInfo.getOSArch()) || "amd64".equals(jREInfo.getOSArch())) {
                jVMParameters.addInternalArgument("-d64");
            } else {
                jVMParameters.addInternalArgument("-d32");
            }
        }
    }

    private static void addXToolkitOption(JVMParameters jVMParameters, VersionID versionID) {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.startsWith("sunos") && new VersionID("1.5*").match(versionID)) {
            jVMParameters.addInternalArgument("-Dawt.toolkit=sun.awt.X11.XToolkit");
        }
    }

    private static void addUIElementOption(JVMParameters jVMParameters) {
        if (OSType.isMac()) {
            jVMParameters.addInternalArgument("-Dapple.awt.UIElement=true");
        }
    }

    private static void addJavaExtDirsOption(JVMParameters jVMParameters) {
        String string = PluginJVMUtil.getJavaExtDirsProp(jVMParameters);
        if (null != string) {
            jVMParameters.addInternalArgument(string);
        }
    }

    private static String getJavaExtDirsProp(JVMParameters jVMParameters) {
        String string;
        String string2;
        File file;
        boolean bl;
        if (jVMParameters.containsPrefix(JAVA_EXT_DIRS)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(JAVA_EXT_DIRS);
        stringBuilder.append(Config.getJREHome() + File.separator + "lib" + File.separator + "ext");
        String string3 = stringBuilder.toString();
        boolean bl2 = bl = BrowserType.getBrowserType() == 3;
        if (bl && (file = new File(string2 = Platform.get().getBrowserHomePath() + File.separator + "jss")).exists()) {
            stringBuilder.append(File.pathSeparator);
            stringBuilder.append(string2);
        }
        string2 = Config.getSystemHome() + TRUSTED_DIR;
        file = new File(string2);
        if (OSType.isWin() && file.exists()) {
            stringBuilder.append(File.pathSeparator);
            stringBuilder.append(string2);
        }
        if ((string = stringBuilder.toString()).equals(string3)) {
            return null;
        }
        return string;
    }
}

