/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.main.client;

import com.sun.deploy.config.Config;
import java.io.IOException;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;
import sun.plugin2.applet.Plugin2Manager;
import sun.plugin2.liveconnect.BrowserSideObject;
import sun.plugin2.main.client.LiveConnectSupport;
import sun.plugin2.main.client.MessagePassingExecutionContext;
import sun.plugin2.message.Conversation;
import sun.plugin2.message.JavaObjectOpMessage;
import sun.plugin2.message.JavaScriptCallMessage;
import sun.plugin2.message.JavaScriptEvalMessage;
import sun.plugin2.message.JavaScriptMemberOpMessage;
import sun.plugin2.message.JavaScriptReplyMessage;
import sun.plugin2.message.JavaScriptSlotOpMessage;
import sun.plugin2.message.JavaScriptToStringMessage;
import sun.plugin2.message.Message;
import sun.plugin2.message.Pipe;

public class MessagePassingJSObject
extends JSObject {
    static final IllegalArgumentException BAD_METHOD_NAME_EXCEPTION = new IllegalArgumentException("Method name should not be null.");
    private BrowserSideObject object;
    private int appletID;
    private Pipe pipe;
    private Plugin2Manager manager;
    private static final boolean DEBUG = Config.getDebug();

    public MessagePassingJSObject(BrowserSideObject browserSideObject, int n, Pipe pipe) {
        this.object = browserSideObject;
        this.appletID = n;
        this.pipe = pipe;
        this.manager = null;
    }

    public MessagePassingJSObject(BrowserSideObject browserSideObject, int n, Pipe pipe, Plugin2Manager plugin2Manager) {
        this.object = browserSideObject;
        this.appletID = n;
        this.pipe = pipe;
        this.manager = plugin2Manager;
    }

    public BrowserSideObject getBrowserSideObject() {
        return this.object;
    }

    public int getAppletID() {
        return this.appletID;
    }

    public Plugin2Manager getManager() {
        return this.manager;
    }

    @Override
    public Object call(String string, Object ... objectArray) throws JSException {
        if (this.isInvalidJSMethodName(string)) {
            throw BAD_METHOD_NAME_EXCEPTION;
        }
        if (this.manager != null) {
            this.manager.decreaseJava2JSCounter();
        }
        if ("eval".equals(string) && this.concatenatable(objectArray)) {
            return this.eval(this.concat(objectArray));
        }
        Conversation conversation = this.pipe.beginConversation();
        try {
            MessagePassingExecutionContext.AllowSetForegroundWindow();
            JavaScriptCallMessage javaScriptCallMessage = new JavaScriptCallMessage(conversation, this.object, this.appletID, string, this.convert(objectArray));
            this.pipe.send(javaScriptCallMessage);
            Object object = this.waitForReply(conversation);
            return object;
        }
        catch (IOException iOException) {
            throw this.newJSException(iOException);
        }
        finally {
            this.pipe.endConversation(conversation);
        }
    }

    @Override
    public Object eval(String string) throws JSException {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (this.manager != null) {
            this.manager.decreaseJava2JSCounter();
        }
        Conversation conversation = this.pipe.beginConversation();
        try {
            MessagePassingExecutionContext.AllowSetForegroundWindow();
            JavaScriptEvalMessage javaScriptEvalMessage = new JavaScriptEvalMessage(conversation, this.object, this.appletID, string);
            this.pipe.send(javaScriptEvalMessage);
            Object object = this.waitForReply(conversation);
            return object;
        }
        catch (IOException iOException) {
            throw this.newJSException(iOException);
        }
        finally {
            this.pipe.endConversation(conversation);
        }
    }

    @Override
    public Object getMember(String string) throws JSException {
        if (this.isInvalidJSMethodName(string)) {
            throw BAD_METHOD_NAME_EXCEPTION;
        }
        if (this.manager != null) {
            this.manager.decreaseJava2JSCounter();
        }
        return this.doMemberOp(string, 1, null);
    }

    @Override
    public void setMember(String string, Object object) throws JSException {
        if (this.isInvalidJSMethodName(string)) {
            throw BAD_METHOD_NAME_EXCEPTION;
        }
        if (this.manager != null) {
            this.manager.decreaseJava2JSCounter();
        }
        this.doMemberOp(string, 2, object);
    }

    @Override
    public void removeMember(String string) throws JSException {
        if (this.isInvalidJSMethodName(string)) {
            throw BAD_METHOD_NAME_EXCEPTION;
        }
        if (this.manager != null) {
            this.manager.decreaseJava2JSCounter();
        }
        this.doMemberOp(string, 3, null);
    }

    @Override
    public Object getSlot(int n) throws JSException {
        if (this.manager != null) {
            this.manager.decreaseJava2JSCounter();
        }
        return this.doSlotOp(n, 1, null);
    }

    @Override
    public void setSlot(int n, Object object) throws JSException {
        if (this.manager != null) {
            this.manager.decreaseJava2JSCounter();
        }
        this.doSlotOp(n, 2, object);
    }

    public String toString() {
        if (this.manager != null) {
            this.manager.decreaseJava2JSCounter();
        }
        Conversation conversation = this.pipe.beginConversation();
        try {
            JavaScriptToStringMessage javaScriptToStringMessage = new JavaScriptToStringMessage(conversation, this.object, this.appletID);
            this.pipe.send(javaScriptToStringMessage);
            String string = (String)this.waitForReply(conversation);
            return string;
        }
        catch (IOException iOException) {
            throw this.newJSException(iOException);
        }
        finally {
            this.pipe.endConversation(conversation);
        }
    }

    private Object waitForReply(Conversation conversation) throws JSException {
        try {
            Message message;
            block9: while (true) {
                message = this.pipe.receive(0L, conversation);
                switch (message.getID()) {
                    case 27: {
                        JavaScriptReplyMessage javaScriptReplyMessage = (JavaScriptReplyMessage)message;
                        if (javaScriptReplyMessage.getExceptionMessage() != null) {
                            throw this.newJSException(javaScriptReplyMessage.getExceptionMessage());
                        }
                        return LiveConnectSupport.importObject(javaScriptReplyMessage.getResult(), this.appletID);
                    }
                    case 33: {
                        try {
                            LiveConnectSupport.doObjectOp((JavaObjectOpMessage)message);
                        }
                        catch (IOException iOException) {
                            throw this.newJSException(iOException);
                        }
                    }
                    continue block9;
                }
                break;
            }
            throw this.newJSException("Unexpected reply message ID " + message.getID() + " from web browser");
        }
        catch (IOException iOException) {
            throw this.newJSException(iOException);
        }
        catch (InterruptedException interruptedException) {
            throw this.newJSException(interruptedException);
        }
    }

    private Object[] convert(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = LiveConnectSupport.exportObject(objectArray[i], this.appletID, false, false);
        }
        return objectArray2;
    }

    private Object doMemberOp(String string, int n, Object object) throws JSException {
        Conversation conversation = this.pipe.beginConversation();
        try {
            JavaScriptMemberOpMessage javaScriptMemberOpMessage = new JavaScriptMemberOpMessage(conversation, this.object, this.appletID, string, n, LiveConnectSupport.exportObject(object, this.appletID, false, false));
            this.pipe.send(javaScriptMemberOpMessage);
            Object object2 = this.waitForReply(conversation);
            return object2;
        }
        catch (IOException iOException) {
            throw this.newJSException(iOException);
        }
        finally {
            this.pipe.endConversation(conversation);
        }
    }

    private Object doSlotOp(int n, int n2, Object object) throws JSException {
        Conversation conversation = this.pipe.beginConversation();
        try {
            JavaScriptSlotOpMessage javaScriptSlotOpMessage = new JavaScriptSlotOpMessage(conversation, this.object, this.appletID, n, n2, LiveConnectSupport.exportObject(object, this.appletID, false, false));
            this.pipe.send(javaScriptSlotOpMessage);
            Object object2 = this.waitForReply(conversation);
            return object2;
        }
        catch (IOException iOException) {
            throw this.newJSException(iOException);
        }
        finally {
            this.pipe.endConversation(conversation);
        }
    }

    private JSException newJSException(Exception exception) {
        JSException jSException = new JSException(exception);
        if (DEBUG) {
            jSException.printStackTrace();
        }
        return jSException;
    }

    private JSException newJSException(String string) {
        JSException jSException = new JSException(string);
        if (DEBUG) {
            jSException.printStackTrace();
        }
        return jSException;
    }

    private boolean concatenatable(Object[] objectArray) {
        if (objectArray == null) {
            return true;
        }
        for (Object object : objectArray) {
            if (object instanceof String) continue;
            return false;
        }
        return true;
    }

    private String concat(Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) continue;
                stringBuilder.append(objectArray[i]);
                if (i >= objectArray.length - 1) continue;
                stringBuilder.append(" ");
            }
        }
        return stringBuilder.toString();
    }

    private boolean isInvalidJSMethodName(String string) {
        return string == null || string.replaceAll("\\s", "").isEmpty();
    }
}

